/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.execution.ExecutionStepFinder;
import org.squashtest.tm.service.execution.IssueHolder;
import org.squashtest.tm.service.internal.bugtracker.RemoteIssueContextHelper;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;

@Service
@Transactional
public class ExecutionStepFinderServiceImpl
implements ExecutionStepFinder,
IssueHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionStepFinderServiceImpl.class);
    private final ExecutionStepDao executionStepDao;
    private final SprintManagerService sprintManagerService;

    public ExecutionStepFinderServiceImpl(ExecutionStepDao executionStepDao, SprintManagerService sprintManagerService) {
        this.executionStepDao = executionStepDao;
        this.sprintManagerService = sprintManagerService;
    }

    @Override
    public RemoteIssueContext getRemoteIssueContext(long stepId, String squashPublicUrl, MessageSource messageSource) {
        ExecutionStep executionStep = this.findExecutionStepById(stepId);
        return RemoteIssueContextHelper.getRemoteIssueContext(executionStep, squashPublicUrl, messageSource);
    }

    @Override
    public ExecutionStep findExecutionStepById(long stepId) {
        return (ExecutionStep)this.executionStepDao.findById(stepId);
    }

    @Override
    public BugTracker findBugTrackerByEntityId(long stepId) {
        return this.findExecutionStepById(stepId).getBugTracker();
    }

    @Override
    public void checkCanAddIssue(long stepId) {
        LOGGER.trace("Posting new issue for execution step %d".formatted(stepId), new Object[0]);
        if (SprintStatus.CLOSED.equals((Object)this.sprintManagerService.getSprintStatusByExecutionId(this.executionStepDao.findParentExecution(stepId).getId()))) {
            throw new SprintClosedException();
        }
    }

    @Override
    public IssueDetector fetchIssueDetector(long stepId) {
        return this.findExecutionStepById(stepId);
    }
}

