/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.pivotdefinition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public abstract class AbstractPivotObject {
    protected static final String PIVOT_GENERATED = "%s%s-Project";
    @JsonProperty(value="id")
    protected String pivotId;

    public String getPivotId() {
        return this.pivotId;
    }

    public String getPivotId(String id) {
        return String.format("%s%s", this.getBasePivotId(), id);
    }

    public void setPivotId(String pivotId) {
        this.pivotId = pivotId;
    }

    public void setPivotId(Integer id) {
        if (Objects.isNull(id)) {
            return;
        }
        this.pivotId = this.getPivotId(String.valueOf(id));
    }

    public void setPivotId(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        this.pivotId = this.getPivotId(String.valueOf(id));
    }

    public void setPivotIdGenerated(Long id) {
        this.pivotId = PIVOT_GENERATED.formatted(this.getBasePivotId(), id);
    }

    public Long pivotIdToSquashId() {
        return this.pivotIdToSquashId(this.getBasePivotId());
    }

    @JsonIgnore
    protected Long pivotIdToSquashId(String basePivotId) {
        return Long.parseLong(this.pivotId.replace(basePivotId, ""));
    }

    @JsonIgnore
    public abstract String getBasePivotId();
}

