/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectLimitAfterOffsetStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.filters.collector.DefaultFilterCollector;

public abstract class AbstractGrid {
    protected final Map<String, GridColumn> aliasToFieldDictionary;
    protected final Map<String, String> fieldToAliasDictionary = this.getColumns().stream().collect(Collectors.toMap(column -> column.getAliasedField().getName(), GridColumn::findRuntimeAlias));

    protected AbstractGrid() {
        this.aliasToFieldDictionary = this.getColumns().stream().collect(Collectors.toMap(GridColumn::findRuntimeAlias, column -> column));
    }

    protected abstract List<GridColumn> getColumns();

    protected abstract Table<?> getTable();

    protected Condition craftInvariantFilter() {
        return DSL.val((int)1).eq((Object)1);
    }

    protected abstract Field<?> getIdentifier();

    protected abstract Field<?> getProjectIdentifier();

    protected SortField<?> getDefaultOrder() {
        return this.getIdentifier().asc();
    }

    protected List<Field<?>> getFields() {
        return this.getColumns().stream().map(GridColumn::getAliasedField).toList();
    }

    public GridResponse getRows(GridRequest request, DSLContext dslContext) {
        Long count = this.countRows(dslContext, request);
        Integer actualPage = GridResponse.getPageNumberWithinBounds(request, count);
        List<DataRow> dataRows = this.getDataRows(request, actualPage, dslContext);
        GridResponse gridResponse = new GridResponse();
        gridResponse.setCount(count);
        gridResponse.setDataRows(dataRows);
        gridResponse.setPage(actualPage);
        return gridResponse;
    }

    protected List<DataRow> getDataRows(GridRequest request, Integer actualPage, DSLContext dslContext) {
        Select<?> baseRequest = this.getBaseRequest(request, actualPage, dslContext);
        return baseRequest.fetch().stream().collect(this.getCollector());
    }

    private Select<?> getBaseRequest(GridRequest request, Integer actualPage, DSLContext dslContext) {
        int offset = 0;
        if (actualPage != null && request.getSize() != null) {
            offset = actualPage * request.getSize();
        }
        SelectLimitAfterOffsetStep query = this.createQuery(request, dslContext).offset((Number)offset);
        if (request.getSize() != null) {
            return query.limit((Number)request.getSize());
        }
        return query;
    }

    protected SelectSeekStepN<?> createQuery(GridRequest request, DSLContext dslContext) {
        return dslContext.select(this.getFields()).from(this.getTable()).where(this.craftInvariantFilter()).and(this.craftVariableFilters(request)).orderBy(this.getOrderClause(request));
    }

    protected List<OrderField<?>> getOrderClause(GridRequest request) {
        if (request.getSort().isEmpty()) {
            return Collections.singletonList(this.getDefaultOrder());
        }
        return this.generateOrderClause(request);
    }

    protected List<OrderField<?>> generateOrderClause(GridRequest request) {
        return request.getSort().stream().map(gridSort -> {
            GridColumn gridColumn = this.aliasToFieldDictionary.get(gridSort.getProperty());
            return gridColumn.generateOrderClause(gridSort.getDirection());
        }).toList();
    }

    protected Long countRows(DSLContext dslContext, GridRequest request) {
        return (Long)dslContext.select((SelectField)DSL.count()).from(this.getTable()).where(this.craftInvariantFilter()).and(this.craftVariableFilters(request)).fetchOne(0, Long.class);
    }

    protected Collector<Record, ?, List<DataRow>> getCollector() {
        return new DefaultCollector(this.getIdentifier(), this.getProjectIdentifier(), this.fieldToAliasDictionary);
    }

    protected Condition craftVariableFilters(GridRequest request) {
        if (request.getFilterValues().isEmpty()) {
            return DSL.val((int)1).eq((Object)1);
        }
        return request.getFilterValues().stream().collect(new DefaultFilterCollector(this.aliasToFieldDictionary, request.isSearchOnMultiColumns()));
    }

    static class DefaultCollector
    implements Collector<Record, List<DataRow>, List<DataRow>> {
        private final Field<?> idField;
        private final Field<?> projectIdField;
        private final Map<String, String> columnNameMap;

        public DefaultCollector(Field<?> idField, Field<?> projectIdField, Map<String, String> columnNameMap) {
            this.idField = idField;
            this.projectIdField = projectIdField;
            this.columnNameMap = columnNameMap;
        }

        @Override
        public Supplier<List<DataRow>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<DataRow>, Record> accumulator() {
            return (list, record) -> {
                DataRow dataRow = new DataRow();
                Map rawData = record.intoMap();
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (Map.Entry entry : rawData.entrySet()) {
                    data.put(this.columnNameMap.get(entry.getKey()), entry.getValue());
                }
                dataRow.setId((String)record.get(this.idField, String.class));
                if (this.projectIdField != null) {
                    dataRow.setProjectId((Long)record.get(this.projectIdField, Long.class));
                }
                dataRow.setData(data);
                list.add(dataRow);
            };
        }

        @Override
        public BinaryOperator<List<DataRow>> combiner() {
            return (x, y) -> {
                throw new UnsupportedOperationException();
            };
        }

        @Override
        public Function<List<DataRow>, List<DataRow>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            HashSet<Collector.Characteristics> characteristics = new HashSet<Collector.Characteristics>();
            characteristics.add(Collector.Characteristics.IDENTITY_FINISH);
            return characteristics;
        }
    }
}

