/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.execution;

import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.execution.AutomatedExecutionDisplayService;
import org.squashtest.tm.service.internal.display.dto.FailureDetailDto;
import org.squashtest.tm.service.internal.repository.display.AutomatedExecutionDisplayDao;
import org.squashtest.tm.service.plugin.PluginFinderService;

@Service
@Transactional(readOnly=true)
public class AutomatedExecutionDisplayServiceImpl
implements AutomatedExecutionDisplayService {
    private final AutomatedExecutionDisplayDao automatedExecutionDisplayDao;
    private final PluginFinderService pluginFinderService;

    public AutomatedExecutionDisplayServiceImpl(AutomatedExecutionDisplayDao automatedExecutionDisplayDao, PluginFinderService pluginFinderService) {
        this.automatedExecutionDisplayDao = automatedExecutionDisplayDao;
        this.pluginFinderService = pluginFinderService;
    }

    @Override
    public List<FailureDetailDto> findFailureDetailList(Long executionExtenderId) {
        if (this.pluginFinderService.isPremiumPluginInstalled()) {
            return this.automatedExecutionDisplayDao.findAllFailureDetailsByAutomatedExecutionExtenderId(executionExtenderId);
        }
        return new ArrayList<FailureDetailDto>();
    }
}

