/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.attachment;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.attachment.FileViewerService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.display.attachment.FileViewerExtension;
import org.squashtest.tm.service.internal.display.dto.FileViewerDto;
import org.squashtest.tm.service.internal.display.dto.FileViewerRequest;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;

@Service
@Transactional(readOnly=true)
public class FileViewerServiceImpl
implements FileViewerService {
    private static final String IS_DIRECTORY = "isDirectory";
    private static final String NAME = "name";
    private static final FileViewerExtension[] UNSAFE_EXTENSIONS = new FileViewerExtension[]{FileViewerExtension.HTML, FileViewerExtension.SVG};
    @Inject
    private AttachmentRepository attachmentRepository;
    @Inject
    private FeatureManager featureManager;
    @Autowired(required=false)
    private HttpServletRequest httpServletRequest;

    @Override
    public FileViewerDto preview(FileViewerRequest viewerRequest) throws IOException {
        boolean unsafeAttachmentPreviewEnabled = this.featureManager.isEnabled(FeatureManager.Feature.UNSAFE_ATTACHMENT_PREVIEW);
        if (!unsafeAttachmentPreviewEnabled && List.of(UNSAFE_EXTENSIONS).contains((Object)viewerRequest.getFileType())) {
            return new FileViewerDto(FileViewerExtension.HTML, "Unsafe files preview is disabled.");
        }
        switch (viewerRequest.getFileType()) {
            case JSON: 
            case LOG: 
            case TXT: 
            case XML: 
            case JS: 
            case CSS: {
                String content = IOUtils.toString((InputStream)this.getStream(viewerRequest), (Charset)Charset.defaultCharset());
                return new FileViewerDto(viewerRequest.getFileType(), content);
            }
            case HTML: {
                String content = IOUtils.toString((InputStream)this.getStream(viewerRequest), (Charset)Charset.defaultCharset());
                content = this.appendHtmlBaseURI(content, viewerRequest.getTarget(), viewerRequest.getSource());
                return new FileViewerDto(viewerRequest.getFileType(), content);
            }
            case JPEG: 
            case JPG: 
            case PDF: 
            case PNG: 
            case SVG: 
            case GIF: 
            case BMP: {
                byte[] buffer = this.getContentBytes(viewerRequest);
                return new FileViewerDto(viewerRequest.getFileType(), buffer);
            }
        }
        throw new IllegalArgumentException("Invalid extension + " + String.valueOf((Object)viewerRequest.getFileType()) + " for preview");
    }

    private String appendHtmlBaseURI(String content, String target, String source) {
        if (target == null) {
            return content;
        }
        Document document = Jsoup.parse((String)content);
        String baseUri = this.buildHtmlBaseURI(target, source);
        Element script = new Element("base");
        script.attr("href", baseUri);
        document.head().prependChild((Node)script);
        return document.html();
    }

    private String buildHtmlBaseURI(String source, String id) {
        String baseUrl = this.httpServletRequest.getContextPath() + "/backend/file-viewer/archive-source/" + id + "/";
        if (source.split("/").length > 1) {
            String targetPath = "target:" + source.substring(0, source.lastIndexOf("/"));
            return baseUrl + targetPath + "/";
        }
        return baseUrl;
    }

    @Override
    public TreeGridResponse getArchiveFileTree(FileViewerRequest viewerRequest) throws IOException {
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
        TarArchiveInputStream tarInput = new TarArchiveInputStream(this.getSourceStream(viewerRequest));
        FileViewerServiceImpl.processArchiveIntoDataRows(tarInput, dataRows);
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        treeGridResponse.setDataRows(dataRows);
        return treeGridResponse;
    }

    private static void processArchiveIntoDataRows(TarArchiveInputStream tarInput, List<DataRow> dataRows) throws IOException {
        TarArchiveEntry entry;
        HashMap<Path, DataRow> map = new HashMap<Path, DataRow>();
        while ((entry = tarInput.getNextEntry()) != null) {
            Path entryPath = Paths.get(entry.getName(), new String[0]);
            DataRow row = new DataRow();
            String rowId = entry.getName();
            row.setId(rowId);
            Path parentPath = entryPath.getParent();
            if (parentPath != null) {
                FileViewerServiceImpl.processParent(dataRows, row, parentPath, map, rowId);
            }
            if (entry.isDirectory()) {
                row.setState(DataRow.State.leaf);
                row.setData(Map.of(NAME, FileViewerServiceImpl.getFileName(entryPath), IS_DIRECTORY, true));
                map.put(entryPath, row);
            } else {
                row.setState(DataRow.State.leaf);
                row.setData(Map.of(NAME, FileViewerServiceImpl.getFileName(entryPath), IS_DIRECTORY, false));
            }
            dataRows.add(row);
        }
    }

    private static void processParent(List<DataRow> dataRows, DataRow row, Path parentPath, Map<Path, DataRow> map, String rowId) {
        row.setParentRowId(parentPath.toString());
        DataRow parent = map.get(parentPath);
        if (parent != null) {
            if (parent.getState().equals((Object)DataRow.State.leaf)) {
                parent.setState(DataRow.State.closed);
            }
            parent.getChildren().add(rowId);
        } else {
            DataRow parentRow = new DataRow();
            parentRow.setId(parentPath.toString());
            parentRow.setState(DataRow.State.closed);
            parentRow.setChildren(new ArrayList<String>(List.of(rowId)));
            parentRow.setData(Map.of(NAME, FileViewerServiceImpl.getFileName(parentPath), IS_DIRECTORY, true));
            map.put(parentPath, parentRow);
            dataRows.add(parentRow);
            if (parentPath.getParent() != null) {
                FileViewerServiceImpl.processParent(dataRows, parentRow, parentPath.getParent(), map, parentPath.toString());
            }
        }
    }

    private static String getFileName(Path entryPath) {
        return entryPath.getFileName().toString();
    }

    private InputStream getSourceStream(FileViewerRequest viewerRequest) throws IOException {
        String source = viewerRequest.getSource();
        return viewerRequest.isAttachment() ? this.attachmentRepository.getContentStream(Long.parseLong(source)) : new FileInputStream(source);
    }

    private InputStream getStream(FileViewerRequest viewerRequest) throws IOException {
        if (viewerRequest.getTarget() != null) {
            return this.getInputStreamFromArchive(this.getSourceStream(viewerRequest), viewerRequest.getTarget(), viewerRequest.getSource());
        }
        return this.getSourceStream(viewerRequest);
    }

    private TarArchiveInputStream getInputStreamFromArchive(InputStream tarStream, String target, String source) throws IOException {
        TarArchiveEntry entry;
        Path path = Paths.get(target, new String[0]);
        TarArchiveInputStream tarInput = new TarArchiveInputStream(tarStream);
        while ((entry = tarInput.getNextEntry()) != null) {
            Path entryPath = Paths.get(entry.getName(), new String[0]);
            if (!entryPath.equals(path)) continue;
            return tarInput;
        }
        throw new FileNotFoundException("File " + target + " not found in archive " + source);
    }

    private byte[] getContentBytes(FileViewerRequest viewerRequest) throws IOException {
        if (viewerRequest.getTarget() != null) {
            return this.getContentBytesFromArchive(viewerRequest);
        }
        String source = viewerRequest.getSource();
        return viewerRequest.isAttachment() ? this.attachmentRepository.getContentBytes(Long.parseLong(source)) : Files.readAllBytes(Paths.get(source, new String[0]));
    }

    private byte[] getContentBytesFromArchive(FileViewerRequest viewerRequest) throws IOException {
        TarArchiveEntry entry;
        Path path = Paths.get(viewerRequest.getTarget(), new String[0]);
        TarArchiveInputStream tarInput = new TarArchiveInputStream(this.getSourceStream(viewerRequest));
        while ((entry = tarInput.getNextEntry()) != null) {
            int length;
            Path entryPath = Paths.get(entry.getName(), new String[0]);
            if (!entryPath.equals(path)) continue;
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = tarInput.read(buffer)) != -1) {
                byteOutput.write(buffer, 0, length);
            }
            return byteOutput.toByteArray();
        }
        throw new FileNotFoundException("File " + viewerRequest.getTarget() + " not found in archive " + viewerRequest.getSource());
    }
}

