/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.adapter;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueFindContext;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.RemoteProject;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.lang.CollectionUtils;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.internal.bugtracker.adapter.AbstractInternalConnectorAdapter;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

public class AdvancedBugtrackerConnectorAdapter
extends AbstractInternalConnectorAdapter {
    private AdvancedBugTrackerConnector connector;

    public AdvancedBugtrackerConnectorAdapter() {
    }

    public AdvancedBugtrackerConnectorAdapter(AdvancedBugTrackerConnector connector) {
        this.connector = connector;
    }

    @Override
    public AdvancedBugTrackerConnector getConnector() {
        return this.connector;
    }

    public void setConnector(AdvancedBugTrackerConnector connector) {
        this.connector = connector;
    }

    @Override
    public RemoteProject findProject(String projectName) throws ProjectNotFoundException, BugTrackerRemoteException {
        return this.connector.findProject(projectName);
    }

    @Override
    public RemoteProject findProjectById(String projectId) throws ProjectNotFoundException, BugTrackerRemoteException {
        return this.connector.findProject(projectId);
    }

    @Override
    public RemoteIssue createIssue(RemoteIssue issue) throws BugTrackerRemoteException {
        return this.connector.createIssue(issue);
    }

    @Override
    public RemoteIssue findIssue(String key) {
        return this.connector.findIssue(key);
    }

    @Override
    public List<RemoteIssue> findIssues(Collection<String> issueKeys) {
        throw new RuntimeException("Unsupported method signature.");
    }

    @Override
    public List<RemoteIssue> findKnownIssues(Collection<String> issueKeys, RemoteIssueFindContext context) {
        return this.connector.findKnownIssues(CollectionUtils.coerceToList(issueKeys), context).stream().map(RemoteIssue.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest searchRequest) {
        return this.connector.searchIssue(searchRequest);
    }

    @Override
    public URL makeViewIssueUrl(BugTracker bugTracker, String issueId) {
        return this.connector.makeViewIssueUrl(issueId);
    }

    @Override
    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        return this.connector.createReportIssueTemplate(projectName, context);
    }

    @Override
    public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        return this.connector.createIssueSearchForm(bugTrackerBindingInfo);
    }

    @Override
    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
        this.connector.forwardAttachments(remoteIssueKey, attachments);
    }

    @Override
    public Object executeDelegateCommand(DelegateCommand command) {
        return this.connector.executeDelegateCommand(command);
    }

    @Override
    public void linkIssues(Long bugtrackerId, String remoteIssueKey, List<RemoteRequirementAndProjectId> remoteReqIds) {
        this.connector.linkIssues(bugtrackerId, remoteIssueKey, remoteReqIds);
    }
}

