/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.internal.batchimport.column.ExcelWorkbookParser;
import org.squashtest.tm.service.internal.batchimport.excel.ExcelBatchImporter;
import org.squashtest.tm.service.internal.batchimport.instruction.container.CoverageInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.DatasetInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.DatasetParamValueInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.Importer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.ParameterInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.StepInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.TestCaseInstructionContainer;

@Component
public class TestCaseExcelBatchImporter
extends ExcelBatchImporter {
    private static final List<EntityType> TC_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER = Arrays.asList(EntityType.TEST_CASE, EntityType.PARAMETER, EntityType.DATASET, EntityType.TEST_STEP, EntityType.DATASET_PARAM_VALUES, EntityType.COVERAGE);

    public TestCaseExcelBatchImporter() {
        super(LoggerFactory.getLogger(TestCaseExcelBatchImporter.class));
    }

    @Override
    public void addInstructionsByEntity(ExcelWorkbookParser parser, EntityType entityType, Importer importer) {
        this.LOGGER.debug("creating instruction container for entity type : {}", new Object[]{entityType});
        switch (entityType) {
            case TEST_CASE: {
                this.addInstructionsToImporter(parser.getTestCaseInstructions(), importer, TestCaseInstructionContainer::new);
                break;
            }
            case PARAMETER: {
                this.addInstructionsToImporter(parser.getParameterInstructions(), importer, ParameterInstructionContainer::new);
                break;
            }
            case DATASET: {
                this.addInstructionsToImporter(parser.getDatasetInstructions(), importer, DatasetInstructionContainer::new);
                break;
            }
            case TEST_STEP: {
                this.addInstructionsToImporter(parser.getTestStepInstructions(), importer, StepInstructionContainer::new);
                break;
            }
            case DATASET_PARAM_VALUES: {
                this.addInstructionsToImporter(parser.getDatasetParamValuesInstructions(), importer, DatasetParamValueInstructionContainer::new);
                break;
            }
            case COVERAGE: {
                this.addInstructionsToImporter(parser.getCoverageInstructions(), importer, CoverageInstructionContainer::new);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType for TestCase import : " + String.valueOf(this));
            }
        }
    }

    @Override
    public List<EntityType> getEntityType() {
        return TC_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER;
    }
}

