/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionLink;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.requirement.RequirementImportService;
import org.squashtest.tm.service.internal.batchimport.requirement.RequirementImportServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.CoverageImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.ExistLinkImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.LinkImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementFolderImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementVersionImportDto;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.requirement.CategoryChainFixer;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;

@Service
@Transactional
public class RequirementImportServiceImpl
implements RequirementImportService {
    private final RequirementLibraryDao requirementLibraryDao;
    private final RequirementFolderDao requirementFolderDao;
    private final RequirementDao requirementDao;
    private final EntityManager entityManager;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final MilestoneMembershipManager milestoneService;
    private final TestCaseLoader testCaseLoader;
    private final RequirementVersionDao requirementVersionDao;
    private final RequirementVersionLinkTypeDao reqVersionLinkTypeDao;
    private final RequirementVersionLinkDao reqVersionLinkDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public RequirementImportServiceImpl(RequirementLibraryDao requirementLibraryDao, RequirementFolderDao requirementFolderDao, RequirementDao requirementDao, EntityManager entityManager, PrivateCustomFieldValueService customFieldValueService, MilestoneMembershipManager milestoneService, TestCaseLoader testCaseLoader, RequirementVersionDao requirementVersionDao, RequirementVersionLinkTypeDao reqVersionLinkTypeDao, RequirementVersionLinkDao reqVersionLinkDao) {
        this.requirementLibraryDao = requirementLibraryDao;
        this.requirementFolderDao = requirementFolderDao;
        this.requirementDao = requirementDao;
        this.entityManager = entityManager;
        this.customFieldValueService = customFieldValueService;
        this.milestoneService = milestoneService;
        this.testCaseLoader = testCaseLoader;
        this.requirementVersionDao = requirementVersionDao;
        this.reqVersionLinkTypeDao = reqVersionLinkTypeDao;
        this.reqVersionLinkDao = reqVersionLinkDao;
    }

    @Override
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public void addRequirementsToLibrary(@Id Long libraryId, Project project, List<RequirementImportDto> requirementsDto) {
        RequirementLibrary library = this.requirementLibraryDao.loadForNodeAddition(libraryId);
        for (RequirementImportDto dto : requirementsDto) {
            Requirement newRequirement = dto.getRequirement();
            library.addContent((LibraryNode)newRequirement);
            this.replaceInfoListReferences(newRequirement);
            this.requirementDao.persist(newRequirement);
        }
        this.createRequirementCustomFieldValues(requirementsDto, project);
        this.initializeMilestoneBindings(requirementsDto);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @BatchPreventConcurrent(entityType=RequirementFolder.class)
    public void addRequirementsToFolders(@Ids List<Long> folderIds, Project project, List<Batch<RequirementImportDto>> batches) {
        Map requirementFolderById = this.requirementFolderDao.loadForNodeAddition(folderIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        for (Batch<RequirementImportDto> batch : batches) {
            RequirementFolder folder = (RequirementFolder)requirementFolderById.get(batch.getTargetId());
            for (RequirementImportDto dto : batch.getEntities()) {
                Requirement newRequirement = dto.getRequirement();
                folder.addContent((RequirementLibraryNode)newRequirement);
                this.replaceInfoListReferences(newRequirement);
                this.requirementDao.persist(newRequirement);
            }
        }
        List<RequirementImportDto> requirementDtoList = batches.stream().flatMap(b -> b.getEntities().stream()).toList();
        this.createRequirementCustomFieldValues(requirementDtoList, project);
        this.initializeMilestoneBindings(requirementDtoList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public void addRequirementsToRequirements(List<Long> requirementIds, Project project, List<Batch<RequirementImportDto>> batches) {
        Map requirementById = this.requirementDao.loadForNodeAddition(requirementIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        for (Batch<RequirementImportDto> batch : batches) {
            Requirement parent = (Requirement)requirementById.get(batch.getTargetId());
            for (RequirementImportDto dto : batch.getEntities()) {
                Requirement newRequirement = dto.getRequirement();
                parent.addContent(newRequirement);
                this.replaceInfoListReferences(newRequirement);
                this.requirementDao.persist(newRequirement);
            }
        }
        List<RequirementImportDto> requirementDtoList = batches.stream().flatMap(b -> b.getEntities().stream()).toList();
        this.createRequirementCustomFieldValues(requirementDtoList, project);
        this.initializeMilestoneBindings(requirementDtoList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void replaceInfoListReferences(Requirement requirement) {
        CategoryChainFixer.fix(requirement);
    }

    @Override
    public void addFoldersToLibrary(Long libraryId, Project project, List<RequirementFolderImportDto> batch) {
        RequirementLibrary library = this.requirementLibraryDao.loadForNodeAddition(libraryId);
        List<RequirementFolder> folders = batch.stream().map(RequirementFolderImportDto::getFolder).toList();
        CategoryChainFixer fixer = new CategoryChainFixer();
        for (RequirementFolder folder : folders) {
            library.addContent((LibraryNode)folder);
            fixer.fix(folder);
            this.requirementFolderDao.persist(folder);
        }
        this.batchFolderCustomFieldsAndMilestonesInit(batch, project);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void batchFolderCustomFieldsAndMilestonesInit(List<RequirementFolderImportDto> foldersDto, Project project) {
        ArrayList<RequirementFolder> requirementFolders = new ArrayList<RequirementFolder>();
        ArrayList<RequirementVersionImportDto> requirementVersions = new ArrayList<RequirementVersionImportDto>();
        for (RequirementFolderImportDto folderDto : foldersDto) {
            requirementFolders.addAll(folderDto.getGeneratedFolders());
            requirementVersions.addAll(folderDto.getGeneratedVersions());
        }
        this.customFieldValueService.batchFolderCustomFieldValuesCreation(requirementFolders, BindableEntity.REQUIREMENT_FOLDER, project.getId());
        this.createVersionsCustomFieldValues(requirementVersions, project);
        Map<RequirementVersion, List> versionsMilestones = requirementVersions.stream().filter(entry -> !entry.milestoneIds().isEmpty()).collect(Collectors.toMap(RequirementVersionImportDto::requirementVersion, RequirementVersionImportDto::milestoneIds));
        this.milestoneService.bindHoldersToMilestones(versionsMilestones);
    }

    @Override
    public void addFoldersToFolders(List<Long> folderIds, Project project, List<Batch<RequirementFolderImportDto>> batches) {
        Map requirementFolderById = this.requirementFolderDao.loadForNodeAddition(folderIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        ArrayList<RequirementFolderImportDto> foldersDto = new ArrayList<RequirementFolderImportDto>();
        CategoryChainFixer fixer = new CategoryChainFixer();
        for (Batch<RequirementFolderImportDto> batch : batches) {
            RequirementFolder folder = (RequirementFolder)requirementFolderById.get(batch.getTargetId());
            batch.getEntities().forEach(content -> {
                RequirementFolder contentFolder = content.getFolder();
                folder.addContent((RequirementLibraryNode)contentFolder);
                fixer.fix(contentFolder);
                this.requirementFolderDao.persist(contentFolder);
                foldersDto.add((RequirementFolderImportDto)content);
            });
        }
        this.batchFolderCustomFieldsAndMilestonesInit(foldersDto, project);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public void addVersions(List<Long> requirementIds, Project project, List<Batch<RequirementVersionImportDto>> batch) {
        Map requirementById = this.requirementDao.loadForVersionsAddition(requirementIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        HashMap<RequirementVersion, Map<Long, RawValue>> versionsCustomFields = new HashMap<RequirementVersion, Map<Long, RawValue>>();
        HashMap<RequirementVersion, List<Long>> versionsMilestones = new HashMap<RequirementVersion, List<Long>>();
        for (Batch<RequirementVersionImportDto> batchDto : batch) {
            Requirement parent = (Requirement)requirementById.get(batchDto.getTargetId());
            for (RequirementVersionImportDto dto : batchDto.getEntities()) {
                RequirementVersion version = dto.requirementVersion();
                parent.addExistingRequirementVersion(version);
                this.replaceInfoListReferences(parent);
                this.entityManager.persist((Object)version);
                if (!dto.customFields().isEmpty()) {
                    versionsCustomFields.put(version, dto.customFields());
                }
                if (dto.milestoneIds().isEmpty()) continue;
                versionsMilestones.put(version, dto.milestoneIds());
            }
        }
        this.customFieldValueService.initBatchCustomFieldValues(versionsCustomFields);
        this.milestoneService.bindHoldersToMilestones(versionsMilestones);
    }

    private void createRequirementCustomFieldValues(List<RequirementImportDto> requirementDtoList, Project project) {
        List<RequirementVersionImportDto> requirementVersionsDto = requirementDtoList.stream().flatMap(requirementDto -> requirementDto.getGeneratedVersions().stream()).toList();
        this.createVersionsCustomFieldValues(requirementVersionsDto, project);
    }

    private void createVersionsCustomFieldValues(List<RequirementVersionImportDto> requirementVersionsDto, Project project) {
        List<RequirementVersion> requirementVersions = requirementVersionsDto.stream().map(RequirementVersionImportDto::requirementVersion).toList();
        this.createBatchCustomFieldValues(requirementVersions, project);
        Map<RequirementVersion, Map> versionsCustomFields = requirementVersionsDto.stream().filter(entry -> !entry.customFields().isEmpty()).collect(Collectors.toMap(RequirementVersionImportDto::requirementVersion, RequirementVersionImportDto::customFields));
        this.customFieldValueService.initBatchCustomFieldValues(versionsCustomFields);
    }

    private void createBatchCustomFieldValues(List<RequirementVersion> requirementVersions, Project project) {
        this.customFieldValueService.createAllCustomFieldValues(requirementVersions, (GenericProject)project);
    }

    private void initializeMilestoneBindings(List<RequirementImportDto> requirementDtoList) {
        Map<RequirementVersion, List> versionsMilestones = requirementDtoList.stream().flatMap(dto -> dto.getGeneratedVersions().stream()).filter(entry -> !entry.milestoneIds().isEmpty()).collect(Collectors.toMap(RequirementVersionImportDto::requirementVersion, RequirementVersionImportDto::milestoneIds));
        this.milestoneService.bindHoldersToMilestones(versionsMilestones);
    }

    @Override
    public void createCoverages(List<Long> testCaseIds, List<Batch<CoverageImportDto>> batches) {
        Map testCases = this.testCaseLoader.load(testCaseIds, EnumSet.of(TestCaseLoader.Options.FETCH_REQUIREMENT_VERSION_COVERAGES)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        Set versionIds = batches.stream().flatMap(b -> b.getEntities().stream()).map(CoverageImportDto::versionId).collect(Collectors.toSet());
        Map versions = this.requirementVersionDao.loadForCoverageAddition(versionIds).stream().collect(Collectors.toMap(Resource::getId, Function.identity()));
        for (Batch<CoverageImportDto> batch : batches) {
            TestCase testCase = (TestCase)testCases.get(batch.getTargetId());
            for (CoverageImportDto coverageImport : batch.getEntities()) {
                RequirementVersionCoverage coverage = coverageImport.getCoverage(testCase);
                RequirementVersion version = (RequirementVersion)versions.get(coverageImport.versionId());
                coverage.setVerifiedRequirementVersion(version);
                if (coverageImport.coverageExists()) continue;
                coverage.setVerifyingTestCase(testCase);
                this.entityManager.persist((Object)coverage);
            }
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public void createLinks(List<Batch<LinkImportDto>> batches) {
        Set versionIds = batches.stream().flatMap(batch -> batch.getEntities().stream()).flatMap(linkImport -> Stream.of(linkImport.sourceVersionId(), linkImport.destVersionId())).collect(Collectors.toSet());
        Set<String> roles = batches.stream().flatMap(batch -> batch.getEntities().stream()).map(LinkImportDto::destRole).collect(Collectors.toSet());
        Set set = versionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, set);
        Object[] objectArray = new Object[]{this, requirementVersionDao, set, joinPoint};
        RequirementImportServiceImpl$AjcClosure1 requirementImportServiceImpl$AjcClosure1 = new RequirementImportServiceImpl$AjcClosure1(objectArray);
        Map versions = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(requirementImportServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112))).stream().collect(Collectors.toMap(Resource::getId, Function.identity()));
        Map<String, RequirementVersionLinkType> linkTypes = this.getLinkTypes(roles);
        for (Batch<LinkImportDto> batch2 : batches) {
            RequirementVersion source = (RequirementVersion)versions.get(batch2.getTargetId());
            for (LinkImportDto linkImport2 : batch2.getEntities()) {
                RequirementVersion dest = (RequirementVersion)versions.get(linkImport2.destVersionId());
                RequirementVersionLinkType type = linkTypes.get(linkImport2.destRole());
                boolean outboundDirection = !type.getRole2Code().equals(linkImport2.destRole());
                RequirementVersionLink outboundLink = new RequirementVersionLink(source, dest, type, outboundDirection);
                this.entityManager.persist((Object)outboundLink);
                RequirementVersionLink inboundLink = outboundLink.createSymmetricalRequirementVersionLink();
                this.entityManager.persist((Object)inboundLink);
            }
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private Map<String, RequirementVersionLinkType> getLinkTypes(Set<String> roles) {
        HashMap<String, RequirementVersionLinkType> result = new HashMap<String, RequirementVersionLinkType>();
        for (RequirementVersionLinkType link : this.reqVersionLinkTypeDao.findByRoleCodes(roles)) {
            result.put(link.getRole1Code(), link);
            result.put(link.getRole2Code(), link);
        }
        return result;
    }

    @Override
    public void updateLinks(List<ExistLinkImportDto> batch) {
        Set<Long> linkIds = batch.stream().flatMap(link -> Stream.of(link.inboundLinkId(), link.outboundLinkId())).collect(Collectors.toSet());
        Set<String> roles = batch.stream().map(ExistLinkImportDto::destRole).collect(Collectors.toSet());
        Map links = this.reqVersionLinkDao.findAllByIds(linkIds).stream().collect(Collectors.toMap(RequirementVersionLink::getId, Function.identity()));
        Map<String, RequirementVersionLinkType> linkTypes = this.getLinkTypes(roles);
        for (ExistLinkImportDto link2 : batch) {
            RequirementVersionLink inboundLink = (RequirementVersionLink)links.get(link2.inboundLinkId());
            RequirementVersionLink outboundLink = (RequirementVersionLink)links.get(link2.outboundLinkId());
            RequirementVersionLinkType type = linkTypes.get(link2.destRole());
            boolean outboundDirection = !type.getRole2Code().equals(link2.destRole());
            outboundLink.setLinkType(type);
            outboundLink.setLinkDirection(outboundDirection);
            inboundLink.setLinkType(type);
            inboundLink.setLinkDirection(!outboundDirection);
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public void linkToHighLevelRequirements(List<Long> highLevelRequirementIds, List<Batch<Long>> batches) {
        Map highLevelRequirements = this.requirementDao.loadHighLevelRequirements(highLevelRequirementIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        Set<Long> lowLevelRequirementIds = batches.stream().flatMap(batch -> batch.getEntities().stream()).collect(Collectors.toSet());
        Map<Long, List<Requirement>> requirementDescendant = this.requirementDao.findRecursiveContentsBySourceIds(lowLevelRequirementIds);
        Map lowLevelRequirements = this.requirementDao.load(lowLevelRequirementIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        for (Batch<Long> batch2 : batches) {
            HighLevelRequirement highLevelRequirement = (HighLevelRequirement)highLevelRequirements.get(batch2.getTargetId());
            for (Long lowLevelRequirementId : batch2.getEntities()) {
                Requirement lowLevelRequirement = (Requirement)lowLevelRequirements.get(lowLevelRequirementId);
                if (lowLevelRequirement == null) continue;
                lowLevelRequirement.setHighLevelRequirement(highLevelRequirement);
                List descendants = requirementDescendant.getOrDefault(lowLevelRequirementId, Collections.emptyList());
                for (Requirement descendant : descendants) {
                    descendant.setHighLevelRequirement(highLevelRequirement);
                }
            }
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    static {
        RequirementImportServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllById_aroundBody0(RequirementImportServiceImpl requirementImportServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RequirementImportServiceImpl.java", RequirementImportServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "arg0", "", "java.util.List"), 412);
    }
}

