/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction.targets;

import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;

public class RequirementLinkTarget
implements Target {
    private RequirementVersionTarget sourceVersion;
    private RequirementVersionTarget destVersion;
    private Long existingOutboundLinkId;
    private Long existingInboundLinkId;

    public RequirementLinkTarget() {
        this.sourceVersion = new RequirementVersionTarget();
        this.destVersion = new RequirementVersionTarget();
    }

    public RequirementLinkTarget(RequirementVersionTarget source, RequirementVersionTarget dest) {
        this.sourceVersion = source;
        this.destVersion = dest;
    }

    @Override
    public EntityType getType() {
        return EntityType.REQUIREMENT_LINK;
    }

    @Override
    public boolean isWellFormed() {
        return this.sourceVersion.isWellFormed() && this.destVersion.isWellFormed();
    }

    @Override
    public String getSourcePath() {
        return this.sourceVersion.getSourcePath();
    }

    @Override
    public String getLinkPath() {
        return this.destVersion.getSourcePath();
    }

    public RequirementVersionTarget getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(RequirementVersionTarget sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public RequirementVersionTarget getDestVersion() {
        return this.destVersion;
    }

    public void setDestVersion(RequirementVersionTarget destVersion) {
        this.destVersion = destVersion;
    }

    public Long getExistingOutboundLinkId() {
        return this.existingOutboundLinkId;
    }

    public void setExistingOutboundLinkId(Long existingOutboundLinkId) {
        this.existingOutboundLinkId = existingOutboundLinkId;
    }

    public Long getExistingInboundLinkId() {
        return this.existingInboundLinkId;
    }

    public void setExistingInboundLinkId(Long existingInboundLinkId) {
        this.existingInboundLinkId = existingInboundLinkId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destVersion == null ? 0 : this.destVersion.hashCode());
        result = 31 * result + (this.sourceVersion == null ? 0 : this.sourceVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementLinkTarget other = (RequirementLinkTarget)obj;
        if (this.destVersion == null ? other.destVersion != null : !this.destVersion.equals(other.destVersion)) {
            return false;
        }
        if (this.sourceVersion == null) {
            return other.sourceVersion == null;
        }
        return this.sourceVersion.equals(other.sourceVersion);
    }
}

