/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityUtils;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ValidationFacility;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;

@Component
@Scope(value="prototype")
public class SimulationFacility
implements Facility {
    private final ValidationFacility validator;

    public SimulationFacility(ValidationFacility validator) {
        this.validator = validator;
    }

    @Override
    public LogTrain deleteTestCase(TestCaseTarget target) {
        LogTrain logs = this.validator.deleteTestCase(target);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().setToBeDeleted(target);
        }
        return logs;
    }

    @Override
    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        return this.validator.updateActionStep(target, testStep, cufValues);
    }

    @Override
    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo, ActionTestStep actionStepBackup) {
        LogTrain logs = this.validator.updateCallStep(target, testStep, calledTestCase, paramInfo, actionStepBackup);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().updateCallStepTarget(target, calledTestCase, paramInfo);
        }
        return logs;
    }

    @Override
    public LogTrain deleteTestStep(TestStepTarget target) {
        LogTrain logs = this.validator.deleteTestStep(target);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().remove(target);
        }
        return logs;
    }

    @Override
    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        LogTrain logs = this.validator.updateParameter(target, param);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().addParameter(target);
        }
        return logs;
    }

    @Override
    public LogTrain deleteParameter(ParameterTarget target) {
        LogTrain logs = this.validator.deleteParameter(target);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().removeParameter(target);
        }
        return logs;
    }

    @Override
    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        LogTrain logs = this.validator.failsafeUpdateParameterValue(dataset, param, value, isUpdate);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().addDataset(dataset);
        }
        return logs;
    }

    @Override
    public LogTrain deleteDataset(DatasetTarget dataset) {
        LogTrain logs = this.validator.deleteDataset(dataset);
        if (!logs.hasCriticalErrors()) {
            this.validator.getModel().removeDataset(dataset);
        }
        return logs;
    }

    @Override
    public LogTrain updateTestCase(TestCaseInstruction instr) {
        return this.validator.updateTestCase(instr);
    }

    @Override
    public void updateRequirementVersions(List<RequirementVersionInstruction> updateInstructions, Project project) {
        this.validator.updateRequirementVersions(updateInstructions, project);
    }

    @Override
    public void createCoverages(List<CoverageInstruction> coverageInstructions, Project project) {
        this.validator.createCoverages(coverageInstructions, project);
    }

    @Override
    public void createOrUpdateRequirementLinks(List<RequirementLinkInstruction> requirementLinkInstructions, Project project) {
        this.validator.createOrUpdateRequirementLinks(requirementLinkInstructions, project);
    }

    @Override
    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        throw new NotImplementedException("implement me - must return a Failure : Not implemented in the log train instead of throwing this exception");
    }

    @Override
    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        return this.validator.deleteRequirementLink(instr);
    }

    @Override
    public void createTestCases(List<TestCaseInstruction> instructions, Project project) {
        this.validator.createTestCases(instructions, project);
        for (TestCaseInstruction instruction : instructions) {
            TestCaseTarget target = (TestCaseTarget)instruction.getTarget();
            if (!instruction.hasCriticalErrors()) {
                this.validator.getModel().setToBeCreated(target);
                continue;
            }
            this.validator.getModel().setNotExists(target);
        }
    }

    @Override
    public void createParameters(List<ParameterInstruction> instructions, Project project) {
        this.validator.createParameters(instructions, project);
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> this.validator.getModel().addParameter((ParameterTarget)i.getTarget()));
    }

    @Override
    public void createDatasets(List<DatasetInstruction> instructions, Project project) {
        this.validator.createDatasets(instructions, project);
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> this.validator.getModel().addDataset((DatasetTarget)i.getTarget()));
    }

    @Override
    public void addActionSteps(List<ActionStepInstruction> instructions, Project project) {
        this.validator.addActionSteps(instructions, project);
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> this.validator.getModel().addActionStep((TestStepTarget)i.getTarget()));
    }

    @Override
    public void addCallSteps(List<CallStepInstruction> instructions, Project project) {
        this.validator.addCallSteps(instructions, project);
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> {
            if (FacilityUtils.mustImportCallAsActionStep(i.getLogTrain()) == null) {
                this.validator.getModel().addCallStep((TestStepTarget)i.getTarget(), i.getCalledTC(), i.getDatasetInfo().getParamMode());
            } else {
                this.validator.getModel().addActionStep((TestStepTarget)i.getTarget());
            }
        });
    }

    @Override
    public void addDatasetParametersValues(List<DatasetParamValueInstruction> instructions, Project project) {
        this.validator.addDatasetParametersValues(instructions, project);
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> this.validator.getModel().addDataset((DatasetTarget)i.getTarget()));
    }

    @Override
    public void createRequirementVersions(List<RequirementVersionInstruction> requirementVersionInstructions, Project project) {
        this.validator.createRequirementVersions(requirementVersionInstructions, project);
    }

    @Override
    public void createOrUpdateLinkedLowLevelRequirements(List<LinkedLowLevelRequirementInstruction> linkedLowLevelRequirementInstructions) {
        this.validator.createOrUpdateLinkedLowLevelRequirements(linkedLowLevelRequirementInstructions);
    }
}

