/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport.models;

import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementNature;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementExportModel;

public final class RequirementModel
implements RequirementExportModel.RequirementPathSortable {
    public static final Comparator<RequirementExportModel.RequirementPathSortable> COMPARATOR = new Comparator<RequirementExportModel.RequirementPathSortable>(){

        @Override
        public int compare(RequirementExportModel.RequirementPathSortable o1, RequirementExportModel.RequirementPathSortable o2) {
            int path1length = PathUtils.splitPath((String)o1.getPath()).length;
            int path2length = PathUtils.splitPath((String)o2.getPath()).length;
            int compareProjectName = o1.getProjectName().compareTo(o2.getProjectName());
            int comparePathSize = Integer.compare(path1length, path2length);
            int comparePathName = o1.getPath().compareTo(o2.getPath());
            int compareVersionNumber = Integer.compare(o1.getRequirementVersionNumber(), o2.getRequirementVersionNumber());
            return compareProjectName != 0 ? compareProjectName : (comparePathSize != 0 ? comparePathSize : (comparePathName != 0 ? comparePathName : compareVersionNumber));
        }
    };
    private Long id;
    private Long requirementId;
    private Long projectId;
    private String projectName;
    private String path;
    private int requirementIndex;
    private int requirementVersionNumber;
    private String reference;
    private String name;
    private boolean isHighLevel;
    private RequirementCriticality criticality;
    private String categoryLabel;
    private String categoryCode;
    private RequirementStatus status;
    private String description;
    private Long requirementVersionCoveragesSize;
    private Long requirementVersionNumberSize;
    private Long attachmentListSize;
    private Date createdOn;
    private String createdBy;
    private Date lastModifiedOn;
    private String lastModifiedBy;
    private String milestonesLabels;
    private List<ExportModel.CustomField> cufs = new LinkedList<ExportModel.CustomField>();
    private Long milestonesCount;
    private Long versionCount;
    private int milestoneCount;

    public RequirementModel(Long id, Long requirementId, Long projectId, String projectName, int requirementVersionNumber, String reference, String name, boolean isHighLevel, RequirementCriticality criticality, String categoryLabel, String categoryCode, RequirementStatus status, String description, Long requirementVersionCoveragesSize, Long requirementVersionNumberSize, Long attachmentListSize, Date createdOn, String createdBy, Date lastModifiedOn, String lastModifiedBy, String milestonesLabels, Long milestonesCount, Long versionCount, int milestoneCount) {
        this.id = id;
        this.requirementId = requirementId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.requirementVersionNumber = requirementVersionNumber;
        this.reference = reference;
        this.name = name;
        this.isHighLevel = isHighLevel;
        this.criticality = criticality;
        this.categoryLabel = categoryLabel;
        this.categoryCode = categoryCode;
        this.status = status;
        this.description = description;
        this.requirementVersionCoveragesSize = requirementVersionCoveragesSize;
        this.requirementVersionNumberSize = requirementVersionNumberSize;
        this.attachmentListSize = attachmentListSize;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.lastModifiedOn = lastModifiedOn;
        this.lastModifiedBy = lastModifiedBy;
        this.milestonesLabels = milestonesLabels;
        this.milestonesCount = milestonesCount;
        this.versionCount = versionCount;
        this.milestoneCount = milestoneCount;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRequirementId() {
        return this.requirementId;
    }

    public void setRequirementId(Long requirementId) {
        this.requirementId = requirementId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getRequirementIndex() {
        return this.requirementIndex;
    }

    public void setRequirementIndex(int requirementIndex) {
        this.requirementIndex = requirementIndex;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public int getRequirementVersionNumber() {
        return this.requirementVersionNumber;
    }

    public void setRequirementVersionNumber(int requirementVersionNumber) {
        this.requirementVersionNumber = requirementVersionNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHighLevel() {
        return this.isHighLevel;
    }

    public void setHighLevel(boolean highLevel) {
        this.isHighLevel = highLevel;
    }

    public RequirementNature getNature() {
        return this.isHighLevel ? RequirementNature.HIGH_LEVEL : RequirementNature.STANDARD;
    }

    public RequirementCriticality getCriticality() {
        return this.criticality;
    }

    public void setCriticality(RequirementCriticality criticality) {
        this.criticality = criticality;
    }

    public String getCategoryLabel() {
        return this.categoryLabel;
    }

    public void setCategoryLabel(String categoryLabel) {
        this.categoryLabel = categoryLabel;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public RequirementStatus getStatus() {
        return this.status;
    }

    public void setStatus(RequirementStatus status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getRequirementVersionCoveragesSize() {
        return this.requirementVersionCoveragesSize;
    }

    public void setRequirementVersionCoveragesSize(Long requirementVersionCoveragesSize) {
        this.requirementVersionCoveragesSize = requirementVersionCoveragesSize;
    }

    public Long getRequirementVersionNumberSize() {
        return this.requirementVersionNumberSize;
    }

    public void setRequirementVersionNumberSize(Long requirementVersionNumberSize) {
        this.requirementVersionNumberSize = requirementVersionNumberSize;
    }

    public Long getAttachmentListSize() {
        return this.attachmentListSize;
    }

    public void setAttachmentListSize(Long attachmentListSize) {
        this.attachmentListSize = attachmentListSize;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getMilestonesLabels() {
        return this.milestonesLabels;
    }

    public void setMilestonesLabels(String milestonesLabels) {
        this.milestonesLabels = milestonesLabels;
    }

    public List<ExportModel.CustomField> getCufs() {
        return this.cufs;
    }

    public void setCufs(List<ExportModel.CustomField> cufs) {
        this.cufs = cufs;
    }

    public Long getMilestonesCount() {
        return this.milestonesCount;
    }

    public Long getVersionCount() {
        return this.versionCount;
    }

    public int getMilestoneCount() {
        return this.milestoneCount;
    }

    public String toString() {
        return "RequirementModel [id=" + String.valueOf(this.id) + ", requirementId=" + String.valueOf(this.requirementId) + ", projectId=" + String.valueOf(this.projectId) + ", projectName=" + this.projectName + ", path=" + this.path + ", requirementVersionNumber=" + this.requirementVersionNumber + ", reference=" + this.reference + ", name=" + this.name + ", criticality=" + String.valueOf(this.criticality) + ", categoryLabel=" + this.categoryLabel + ", categoryCode=" + this.categoryCode + ", status=" + String.valueOf(this.status) + ", description=" + this.description + ", requirementVersionCoveragesSize=" + String.valueOf(this.requirementVersionCoveragesSize) + ", requirementVersionNumberSize=" + String.valueOf(this.requirementVersionNumberSize) + ", attachmentListSize=" + String.valueOf(this.attachmentListSize) + ", createdOn=" + String.valueOf(this.createdOn) + ", createdBy=" + this.createdBy + ", lastModifiedOn=" + String.valueOf(this.lastModifiedOn) + ", lastModifiedBy=" + this.lastModifiedBy + ", milestonesLabels=" + this.milestonesLabels + "]";
    }
}

