/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.exception.actionword.InvalidActionWordInputException;
import org.squashtest.tm.exception.actionword.InvalidActionWordParameterNameException;
import org.squashtest.tm.exception.actionword.InvalidActionWordParameterValueException;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.actionword.ActionWordParameterService;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.internal.repository.ActionWordParameterDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;

@Service
@Transactional
public class ActionWordParameterServiceImpl
implements ActionWordParameterService {
    @Inject
    private ActionWordParameterDao actionWordParameterDao;
    @Inject
    private ActionWordLibraryNodeService actionWordLibraryNodeService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    @Override
    @IsUltimateLicenseAvailable
    public String renameParameter(long parameterId, String newName) {
        ActionWordParameter parameter = (ActionWordParameter)this.actionWordParameterDao.getReferenceById(parameterId);
        if (StringUtils.isBlank((CharSequence)newName)) {
            throw new InvalidActionWordParameterNameException("Action word parameter name cannot be blank.");
        }
        String trimmedName = newName.trim();
        if (!parameter.getName().equals(trimmedName)) {
            ActionWord actionWord = parameter.getActionWord();
            this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(actionWord, Permissions.WRITE.name()));
            this.checkNewActionWordLength(actionWord);
            ActionWordParameter.checkIfParamNameIsValid((String)trimmedName);
            parameter.setName(trimmedName);
            this.actionWordLibraryNodeService.renameNodeFromActionWord(actionWord);
        }
        return trimmedName;
    }

    private void checkNewActionWordLength(ActionWord actionWord) {
        String newWord = actionWord.createWord();
        String newWordWithDefaultValues = actionWord.createWordWithDefaultValues();
        if (newWord.length() > 255 || newWordWithDefaultValues.length() > 255) {
            throw new InvalidActionWordInputException("Invalid action word input");
        }
    }

    @Override
    @IsUltimateLicenseAvailable
    public String updateParameterDefaultValue(long parameterId, @NotNull String newDefaultValue) {
        String string = newDefaultValue;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        ActionWordParameter parameter = (ActionWordParameter)this.actionWordParameterDao.getReferenceById(parameterId);
        ActionWord actionWord = parameter.getActionWord();
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(actionWord, Permissions.WRITE.name()));
        String updatedNewDefaultValue = ActionWordUtil.replaceExtraSpacesInText((String)newDefaultValue.trim());
        if (updatedNewDefaultValue.contains("<") || updatedNewDefaultValue.contains(">") || updatedNewDefaultValue.contains("\"")) {
            throw new InvalidActionWordParameterValueException("The default value cannot contain <, > or \" character");
        }
        parameter.setDefaultValue(updatedNewDefaultValue);
        this.checkNewActionWordLength(actionWord);
        return updatedNewDefaultValue;
    }
}

