/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.testplanretriever;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.TagsValue;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.campaign.AutomatedExecutionCreationService;
import org.squashtest.tm.service.internal.dto.AutomatedTestCaseDTO;
import org.squashtest.tm.service.internal.dto.AutomatedTestPlanDTO;
import org.squashtest.tm.service.internal.dto.ExecutionOrderDTO;
import org.squashtest.tm.service.internal.dto.TestPlanContextDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestExtendedDTO;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.TagDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.testautomation.testplanretriever.RestAutomatedSuiteManagerService;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.testautomation.testplanretriever.CustomFieldValuesForExec;
import org.squashtest.tm.service.testautomation.testplanretriever.RestTestPlanFinder;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.NotFoundCustomFieldException;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.TestPlanException;

@Service
@Transactional
public class TestPlanRetrievalService<T extends TriggerRequestDTO, C extends CustomFieldValuesForExec> {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    @Inject
    private CustomFieldDao cufDao;
    @Inject
    private TagDao tagDao;
    @Inject
    protected IterationTestPlanDao itpiDao;
    @Inject
    protected RestAutomatedSuiteManagerService<C> restService;
    @Inject
    protected RestTestPlanFinder restTestPlanFinder;
    @Inject
    private EntityPathHeaderDao pathHeaderDao;
    @Inject
    protected ProjectDao projectDao;
    @Inject
    private AutomatedExecutionCreationService automatedExecutionCreationService;
    @Value(value="${info.app.version}")
    protected String squashTMVersion;

    @BatchPreventConcurrent(entityType=TestPlanItem.class)
    public AutomatedTestPlanDTO getIterationTestPlan(T triggerRequest, Iteration iteration, @Ids List<Long> itemTestPlanIds) throws TestPlanException {
        String path = this.pathHeaderDao.buildIterationPathHeader(iteration.getId());
        TestPlanContextDTO testPlanContext = new TestPlanContextDTO(EntityType.ITERATION, iteration.getName(), path, iteration.getUuid(), this.squashTMVersion);
        AutomatedSuite suite = this.restService.createAutomatedSuiteLinkedToIteration(iteration);
        Project project = this.projectDao.fetchByIterationIdForAutomatedExecutionCreation(iteration.getId());
        return this.getAutomatedTestPlanDTO(triggerRequest, itemTestPlanIds, suite, testPlanContext, project);
    }

    @BatchPreventConcurrent(entityType=TestPlanItem.class)
    public AutomatedTestPlanDTO getTestSuiteTestPlan(T triggerRequest, TestSuite testSuite, @Ids List<Long> itemTestPlanIds) throws TestPlanException {
        String path = this.pathHeaderDao.buildTestSuitePathHeader(testSuite.getId());
        TestPlanContextDTO testPlanContext = new TestPlanContextDTO(EntityType.TEST_SUITE, testSuite.getName(), path, testSuite.getUuid(), this.squashTMVersion);
        AutomatedSuite suite = this.restService.createAutomatedSuiteLinkedToTestSuite(testSuite);
        Project project = this.projectDao.fetchByTestSuiteForAutomatedExecutionCreation(testSuite.getId());
        return this.getAutomatedTestPlanDTO(triggerRequest, itemTestPlanIds, suite, testPlanContext, project);
    }

    private AutomatedTestPlanDTO getAutomatedTestPlanDTO(T triggerRequest, List<Long> itemIds, AutomatedSuite suite, TestPlanContextDTO testPlanContext, Project project) throws NotFoundCustomFieldException {
        Map<Long, Long> itemExecutionMap = this.getItemExecutionMap(triggerRequest, itemIds, suite, project);
        List<TestPlanItem> items = this.itpiDao.fetchWithServerByIds(itemExecutionMap.keySet());
        ExecutionOrderDTO executionOrder = this.getExecutionOrder(items, itemExecutionMap);
        return new AutomatedTestPlanDTO(suite.getUuid(), suite.getId(), executionOrder, testPlanContext);
    }

    private Map<Long, Long> getItemExecutionMap(T triggerRequest, List<Long> itemIds, AutomatedSuite suite, Project project) throws NotFoundCustomFieldException {
        List<Long> filtered = this.filterIterationTestPlanItems(triggerRequest, itemIds);
        return this.automatedExecutionCreationService.createSquashOrchestratorAutomatedExecutions(suite, filtered, project);
    }

    protected List<Long> filterIterationTestPlanItems(T triggerRequest, List<Long> itemIds) throws NotFoundCustomFieldException {
        Map<Long, List<Long>> itemsByTestCaseId = this.itpiDao.getTestPlanItemIdsGroupByTestCaseId(itemIds);
        return this.activateFilter(triggerRequest, itemsByTestCaseId);
    }

    private List<Long> activateFilter(T triggerRequest, Map<Long, List<Long>> itemsByTestCaseId) throws NotFoundCustomFieldException {
        if (!this.ultimateLicenseService.isAvailable()) {
            return itemsByTestCaseId.values().stream().flatMap(Collection::stream).toList();
        }
        TriggerRequestExtendedDTO extendedUltimateTriggerRequest = (TriggerRequestExtendedDTO)triggerRequest;
        if (StringUtils.hasLength((String)extendedUltimateTriggerRequest.getTagLabel())) {
            if (this.cufDao.findByLabelAndInputType(extendedUltimateTriggerRequest.getTagLabel(), InputType.TAG) != null) {
                return this.filterByTag(extendedUltimateTriggerRequest, itemsByTestCaseId);
            }
            throw new NotFoundCustomFieldException();
        }
        return itemsByTestCaseId.values().stream().flatMap(Collection::stream).toList();
    }

    private List<Long> filterByTag(TriggerRequestExtendedDTO triggerRequest, Map<Long, List<Long>> itemsByTestCaseId) {
        List<Long> testCasesIds = itemsByTestCaseId.keySet().stream().toList();
        List<TagsValue> tagsValues = this.getTagsValuesByTagLabelAndTestCaseIds(testCasesIds, triggerRequest.getTagLabel());
        List<String> givenValues = this.cleanAndSplitValueList(triggerRequest.getTagValue());
        Set testCasesWithTags = tagsValues.stream().filter(tagsValue -> tagsValue.getValues().stream().anyMatch(givenValues::contains)).map(CustomFieldValue::getBoundEntityId).collect(Collectors.toSet());
        return itemsByTestCaseId.entrySet().stream().filter(entry -> testCasesWithTags.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
    }

    private List<TagsValue> getTagsValuesByTagLabelAndTestCaseIds(List<Long> testCasesIds, String tagLabel) {
        return this.tagDao.getTagsValuesByTagLabelAndTestCaseIds(testCasesIds, tagLabel);
    }

    private List<String> cleanAndSplitValueList(String valuesAsString) {
        return Stream.of(valuesAsString.trim().split("\\|")).map(String::trim).filter(value -> !value.isEmpty()).toList();
    }

    private ExecutionOrderDTO createExecutionOrder(Collection<Triple<TestPlanItem, Map<String, Object>, Map<String, Object>>> testListWithParams) {
        ExecutionOrderDTO executionOrder = new ExecutionOrderDTO();
        testListWithParams.forEach(testWithParams -> {
            AutomatedTestCaseDTO testCaseDTO = new AutomatedTestCaseDTO(((TestPlanItem)testWithParams.getLeft()).getId(), (Map)testWithParams.getMiddle(), (Map)testWithParams.getRight());
            executionOrder.getTestList().add(testCaseDTO);
            LoggerFactory.getLogger(TestPlanRetrievalService.class).debug("Including test {} to execution order.", new Object[]{testCaseDTO.getParamMap().get("TC_AUTOMATED_TEST_REFERENCE")});
        });
        return executionOrder;
    }

    private ExecutionOrderDTO getExecutionOrder(List<TestPlanItem> items, Map<Long, Long> itemExecutionMap) {
        Collection<Triple<TestPlanItem, Map<String, Object>, Map<String, Object>>> testListWithParams = this.restService.prepareExecutionOrder(items, itemExecutionMap);
        return this.createExecutionOrder(testListWithParams);
    }
}

