/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.testingstatus;

import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.exception.IllegalStatisticRatesException;

public enum RemoteTestingStatus {
    NOT_INITIALIZED,
    CONCEPTION,
    TO_EXECUTE,
    VALIDATION_IN_PROGRESS,
    VALID,
    INVALID;


    public static RemoteTestingStatus findStatus(RemoteRequirementStatistics stats) {
        double redactionRate = stats.redactionRate.normalizedRate;
        double verificationRate = stats.verificationRate.normalizedRate;
        double validationRate = stats.validationRate.normalizedRate;
        if (RemoteTestingStatus.isZero(redactionRate) && RemoteTestingStatus.isZero(verificationRate) && RemoteTestingStatus.isZero(validationRate)) {
            return NOT_INITIALIZED;
        }
        if (RemoteTestingStatus.isIntermediateValue(redactionRate) && RemoteTestingStatus.isZero(verificationRate) && RemoteTestingStatus.isZero(validationRate)) {
            return CONCEPTION;
        }
        if (RemoteTestingStatus.isCompleteValue(redactionRate) && RemoteTestingStatus.isZero(verificationRate) && RemoteTestingStatus.isZero(validationRate)) {
            return TO_EXECUTE;
        }
        if (RemoteTestingStatus.isIntermediateValue(verificationRate) && RemoteTestingStatus.isCompleteValue(validationRate)) {
            return VALIDATION_IN_PROGRESS;
        }
        if (RemoteTestingStatus.isStartedValue(verificationRate) && RemoteTestingStatus.isNotCompleteValue(validationRate)) {
            return INVALID;
        }
        if (RemoteTestingStatus.isCompleteValue(verificationRate) && RemoteTestingStatus.isCompleteValue(validationRate)) {
            return VALID;
        }
        String msg = String.format("Programmatic error. Unable to compute proper testing status. Rates are %f , %f , %f .", redactionRate, verificationRate, validationRate);
        throw new IllegalStatisticRatesException(msg);
    }

    private static boolean isNotCompleteValue(double rate) {
        return rate < 1.0;
    }

    private static boolean isCompleteValue(double rate) {
        return Double.compare(rate, 1.0) == 0;
    }

    private static boolean isZero(double rate) {
        return Double.doubleToRawLongBits(rate) == 0L;
    }

    private static boolean isIntermediateValue(double rate) {
        return rate > 0.0 && rate < 1.0;
    }

    private static boolean isStartedValue(double rate) {
        return rate > 0.0;
    }
}

