/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.pivot;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;

public interface PivotFileManager {
    public File createAttachmentDir(File var1, AttachmentPivotType var2);

    public void saveTmpSaveAttachment(File var1, AttachmentPivot var2);

    public void addAttachmentsToZip(ArchiveOutputStream<ZipArchiveEntry> var1, File var2, File var3) throws IOException;

    public void readPivotFile(MultipartFile var1, BiConsumerThrowing<ZipInputStream, ZipEntry, IOException> var2) throws IOException;

    public void checkJsonFileName(String var1);

    public void checkJsonSyntaxError(ZipEntry var1, ZipInputStream var2) throws IOException;

    public <T> Consumer<T> consumerThrowingIOException(ConsumerThrowing<T, IOException> var1);

    public <T> Consumer<T> consumerThrowingRecordAndId(BiConsumerThrowing<T, AtomicInteger, IOException> var1);

    public void copyPivotFileToImport(MultipartFile var1, File var2, PivotMetaDataModel var3) throws IOException;

    public void writeObjectToZip(JsonFactory var1, ConsumerThrowing<JsonGenerator, IOException> var2, JsonImportFile var3, ArchiveOutputStream<ZipArchiveEntry> var4) throws IOException;

    public void writePivotObjectToZip(JsonFactory var1, Consumer<JsonGenerator> var2, JsonImportFile var3, ArchiveOutputStream<ZipArchiveEntry> var4) throws IOException;

    public <P extends AbstractPivotObject> void writePivotObject(P var1, JsonGenerator var2, JsonImportFile var3);

    @FunctionalInterface
    public static interface BiConsumerThrowing<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerThrowing<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

