/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.InconsistentInfoListItemException;
import org.squashtest.tm.exception.requirement.IllegalRequirementModificationException;
import org.squashtest.tm.exception.requirement.IllegalRequirementVersionCreationException;
import org.squashtest.tm.exception.sync.SynchronizedFieldException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.SynchronizedRequirementVersionsExceptionSummary;
import org.squashtest.tm.service.internal.repository.CustomReqVersionDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionDisplayDao;
import org.squashtest.tm.service.internal.requirement.RequirementVersionManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.requirement.RequirementVersionManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.requirement.RequirementVersionManagerServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.requirement.RequirementVersionManagerServiceImpl$AjcClosure7;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementBulkUpdate;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Service
@Transactional
public class RequirementVersionManagerServiceImpl
implements RequirementVersionManagerService {
    private static final Logger LOGGER;
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Lazy
    @Inject
    private RequirementVersionDisplayDao requirementVersionDisplayDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private MilestoneMembershipManager milestoneManager;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private LinkedRequirementVersionManagerService requirementLinkService;
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    AttachmentManagerService attachmentManagerService;
    @Inject
    private CustomReqVersionDao reqVersionDao;
    @PersistenceContext
    private EntityManager em;
    @Inject
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private LibraryNodeDao<RequirementLibraryNode> requirementLibraryNodeDao;
    @Inject
    @Lazy
    private ConfigurablePluginManager configurablePluginManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        RequirementVersionManagerServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(RequirementVersionManagerServiceImpl.class);
    }

    @Override
    @UsedInPlugin(value="rest-api")
    public Requirement findRequirementById(long requirementId) {
        return this.requirementVersionDao.findRequirementById(requirementId);
    }

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasPermission(returnObject,'READ') or hasRole('ROLE_ADMIN')")
    public RequirementVersion findById(long requirementVersionId) {
        return (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
    }

    @Override
    public List<String> retrieveFullNameByRequirementLibraryNodeIds(List<Long> requirementLibraryNodeIds, List<Long> projectIds) {
        return this.requirementVersionDisplayDao.retrieveFullNameByRequirementLibraryNodeIds(requirementLibraryNodeIds, projectIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void createNewVersion(long requirementId, boolean inheritReqLinks, boolean inheritTestcasesReqLinks) {
        this.createNewVersion(requirementId, inheritReqLinks, inheritTestcasesReqLinks, null);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void createNewVersion(long requirementId, boolean inheritReqLinks, boolean inheritTestcasesReqLinks, AuditableMixin audit) {
        Requirement req = this.requirementVersionDao.findRequirementById(requirementId);
        if (req.isSynchronized()) {
            throw new IllegalRequirementVersionCreationException();
        }
        RequirementVersion previousVersion = req.getCurrentVersion();
        if (Objects.isNull(audit)) {
            req.increaseVersion();
        } else {
            req.increaseVersionWithAuditable(audit);
        }
        this.em.persist((Object)req.getCurrentVersion());
        RequirementVersion newVersion = this.copyAttachmentsForNewVersions(req);
        this.customFieldValueService.copyCustomFieldValues((BoundEntity)previousVersion, (BoundEntity)newVersion);
        if (inheritReqLinks) {
            this.requirementLinkService.copyRequirementVersionLinks(previousVersion, newVersion);
        }
        if (inheritTestcasesReqLinks) {
            this.requirementLinkService.postponeTestCaseToNewRequirementVersion(previousVersion, newVersion);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void createNewVersion(long requirementId, Collection<Long> milestoneIds, boolean inheritReqLinks, boolean inheritTestcasesReqLinks) {
        this.createNewVersion(requirementId, inheritReqLinks, inheritTestcasesReqLinks);
        Requirement req = this.requirementVersionDao.findRequirementById(requirementId);
        for (RequirementVersion version : req.getRequirementVersions()) {
            for (Long mid : milestoneIds) {
                version.unbindMilestone(mid);
            }
        }
        this.milestoneManager.bindRequirementVersionToMilestones(req.getCurrentVersion().getId(), milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCriticality(long requirementVersionId, RequirementCriticality criticality) {
        RequirementCriticality requirementCriticality = criticality;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirementCriticality);
        this.changeCriticality(requirementVersionId, criticality, false);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCriticalityForSynchronisation(long requirementVersionId, RequirementCriticality criticality) {
        RequirementCriticality requirementCriticality = criticality;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirementCriticality);
        this.changeCriticality(requirementVersionId, criticality, true);
    }

    private void changeCriticality(long requirementVersionId, RequirementCriticality criticality, boolean isForSynchronisation) {
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (!isForSynchronisation) {
            this.configurablePluginManager.checkIfFieldIsSynchronized(requirementVersion, "CRITICALITY");
        }
        RequirementCriticality oldCriticality = requirementVersion.getCriticality();
        if (!isForSynchronisation) {
            requirementVersion.setCriticality(criticality);
        } else {
            requirementVersion.updateCriticalityWithoutCheckingStatus(criticality);
        }
        this.testCaseImportanceManagerService.changeImportanceIfRequirementCriticalityChanged(requirementVersionId, oldCriticality);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=RequirementVersion.class)
    public void rename(@Id long requirementVersionId, String newName) {
        RequirementVersion v = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (v.getRequirement().isSynchronized()) {
            throw new SynchronizedFieldException();
        }
        if (!v.isModifiable()) {
            throw new IllegalRequirementModificationException();
        }
        v.setName(newName.trim());
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Page<RequirementVersion> findAllByRequirement(long requirementId, Pageable pageable) {
        Pageable pageable2 = pageable;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)pageable2);
        return this.requirementVersionDao.findAllByRequirementId(requirementId, pageable);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public List<RequirementVersion> findAllByRequirement(long requirementId) {
        PageRequest pageable = PageRequest.of((int)0, (int)Integer.MAX_VALUE, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"versionNumber"});
        return this.findAllByRequirement(requirementId, (Pageable)pageable).getContent();
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCategory(long requirementVersionId, String categoryCode) {
        this.changeCategory(requirementVersionId, categoryCode, false);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCategoryForSynchronisation(long requirementVersionId, String categoryCode) {
        this.changeCategory(requirementVersionId, categoryCode, true);
    }

    public void changeCategory(long requirementVersionId, String categoryCode, boolean isForSynchronisation) {
        InfoListItem category = this.infoListItemService.findByCode(categoryCode);
        this.changeCategory((Long)requirementVersionId, category, isForSynchronisation);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCategory(long requirementVersionId, Long categoryId) {
        InfoListItem category = this.infoListItemService.findById(categoryId);
        this.changeCategory((Long)requirementVersionId, category, false);
    }

    private void changeCategory(Long requirementVersionId, InfoListItem category, boolean isForSynchronisation) {
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (!isForSynchronisation) {
            this.configurablePluginManager.checkIfFieldIsSynchronized(version, "CATEGORY");
        }
        if (this.infoListItemService.isCategoryConsistent(version.getProject().getId(), category.getCode())) {
            if (!isForSynchronisation) {
                version.setCategory(category);
            } else {
                version.updateCategoryWithoutCheckingStatus(category);
            }
        } else {
            throw new InconsistentInfoListItemException("requirementCategory", category.getCode());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeReference(long requirementVersionId, @NotNull String reference) {
        String string = reference;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        this.changeReference(requirementVersionId, reference, false);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeReferenceForSynchronisation(long requirementVersionId, @NotNull String reference) {
        String string = reference;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        this.changeReference(requirementVersionId, reference, true);
    }

    private void changeReference(long requirementVersionId, @NotNull String reference, boolean isForSynchronisation) {
        String string = reference;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (!isForSynchronisation) {
            this.configurablePluginManager.checkIfFieldIsSynchronized(version, "REFERENCE");
            version.setReference(reference);
        } else {
            version.updateReferenceWithoutCheckingStatus(reference);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeDescription(long requirementVersionId, @NotNull String newDescription) {
        String string = newDescription;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        this.changeDescription(requirementVersionId, newDescription, false);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeDescriptionForSynchronisation(long requirementVersionId, @NotNull String newDescription) {
        String string = newDescription;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        this.changeDescription(requirementVersionId, newDescription, true);
    }

    private void changeDescription(long requirementVersionId, @NotNull String newDescription, boolean isForSynchronisation) {
        String string = newDescription;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (!isForSynchronisation) {
            this.configurablePluginManager.checkIfFieldIsSynchronized(version, "DESCRIPTION");
            version.setDescription(newDescription);
        } else {
            version.updateDescriptionWithoutCheckingStatus(newDescription);
        }
    }

    @Override
    @CheckBlockingMilestone(entityType=RequirementVersion.class)
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeStatus(@Id long requirementVersionId, @NotNull RequirementStatus status) {
        RequirementStatus requirementStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirementStatus);
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        this.configurablePluginManager.checkIfFieldIsSynchronized(version, "STATUS");
        version.setStatus(status);
    }

    @Override
    public SynchronizedRequirementVersionsExceptionSummary bulkUpdate(List<Long> requirementVersionIds, RequirementBulkUpdate update) {
        SynchronizedRequirementVersionsExceptionSummary summary = new SynchronizedRequirementVersionsExceptionSummary();
        List<Long> list = requirementVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        RequirementVersionManagerServiceImpl$AjcClosure1 requirementVersionManagerServiceImpl$AjcClosure1 = new RequirementVersionManagerServiceImpl$AjcClosure1(objectArray);
        List versions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(requirementVersionManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        for (RequirementVersion rv : versions) {
            try {
                SecurityCheckableObject check = new SecurityCheckableObject(rv, Permissions.WRITE.name());
                this.permService.checkPermission(check);
                this.checkAndAssignStatus(summary, update, rv);
                this.checkAndAssignCategory(summary, update, rv);
                this.checkAndAssignCriticality(summary, update, rv);
            }
            catch (Exception ex) {
                LOGGER.info("An error occurred during requirement version {} update", new Object[]{rv.getId(), ex});
                summary.addOtherFailure(rv.getName());
            }
        }
        return summary;
    }

    private void checkAndAssignStatus(SynchronizedRequirementVersionsExceptionSummary summary, RequirementBulkUpdate update, RequirementVersion rv) {
        if (update.hasStatusDefined()) {
            try {
                this.changeStatus(rv.getId(), update.getStatus());
            }
            catch (SynchronizedFieldException ex) {
                LOGGER.info("Status of requirement version {} cannot be modified because it is updated by synchronization", new Object[]{rv.getId(), ex});
                summary.addSynchronizedStatus(rv.getName());
            }
        }
    }

    private void checkAndAssignCategory(SynchronizedRequirementVersionsExceptionSummary summary, RequirementBulkUpdate update, RequirementVersion rv) {
        if (update.hasCategoryDefined()) {
            try {
                this.changeCategory((long)rv.getId(), update.getCategory());
            }
            catch (SynchronizedFieldException ex) {
                LOGGER.info("Category of requirement version {} cannot be modified because it is updated by synchronization", new Object[]{rv.getId(), ex});
                summary.addSynchronizedCategory(rv.getName());
            }
        }
    }

    private void checkAndAssignCriticality(SynchronizedRequirementVersionsExceptionSummary summary, RequirementBulkUpdate update, RequirementVersion rv) {
        if (update.hasCriticalityDefined()) {
            try {
                this.changeCriticality(rv.getId(), update.getCriticality());
            }
            catch (SynchronizedFieldException ex) {
                LOGGER.info("Criticality of requirement version {} cannot be modified because it is updated by synchronization", new Object[]{rv.getId(), ex});
                summary.addSynchronizedCriticality(rv.getName());
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAllMilestones(long versionId) {
        return this.milestoneManager.findMilestonesForRequirementVersion(versionId);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAssociableMilestones(long versionId) {
        return this.milestoneManager.findAssociableMilestonesToRequirementVersion(versionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void bindMilestones(long versionId, Collection<Long> milestoneIds) {
        this.milestoneManager.bindRequirementVersionToMilestones(versionId, milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void unbindMilestones(long versionId, Collection<Long> milestoneIds) {
        this.milestoneManager.unbindRequirementVersionFromMilestones(versionId, milestoneIds);
    }

    @Override
    public Collection<Milestone> findAssociableMilestonesForMassModif(List<Long> reqVersionIds) {
        List<Long> list = reqVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        RequirementVersionManagerServiceImpl$AjcClosure3 requirementVersionManagerServiceImpl$AjcClosure3 = new RequirementVersionManagerServiceImpl$AjcClosure3(objectArray);
        List versions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(requirementVersionManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        List<Set<Milestone>> milestoneSetList = versions.stream().map(v -> v.getProject()).distinct().map(p -> this.retainModifiableMilestones(p.getMilestones())).toList();
        return this.intersect(milestoneSetList);
    }

    @Override
    public Collection<Long> findBindedMilestonesIdForMassModif(List<Long> reqVersionIds) {
        List<Long> list = reqVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        RequirementVersionManagerServiceImpl$AjcClosure5 requirementVersionManagerServiceImpl$AjcClosure5 = new RequirementVersionManagerServiceImpl$AjcClosure5(objectArray);
        List versions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(requirementVersionManagerServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        List<Set<Milestone>> milestoneSetList = versions.stream().map(version -> this.retainModifiableMilestones(version.getMilestones())).toList();
        Set<Milestone> milestones = this.intersect(milestoneSetList);
        return IdCollector.collect(milestones);
    }

    private Set<Milestone> retainModifiableMilestones(Collection<Milestone> milestones) {
        return milestones.stream().filter(this::isModifiableMilestone).collect(Collectors.toSet());
    }

    private boolean isModifiableMilestone(Milestone milestone) {
        MilestoneStatus status = milestone.getStatus();
        return status != MilestoneStatus.LOCKED && status != MilestoneStatus.PLANNED;
    }

    private Set<Milestone> intersect(List<Set<Milestone>> milestoneSetList) {
        if (milestoneSetList.isEmpty()) {
            return new HashSet<Milestone>();
        }
        HashSet result = new HashSet(milestoneSetList.get(0));
        return milestoneSetList.stream().skip(1L).collect(() -> result, Collection::retainAll, CollectionUtils::retainAll);
    }

    @Override
    public boolean haveSamePerimeter(List<Long> reqVersionIds) {
        boolean allMatch = true;
        if (reqVersionIds.size() != 1) {
            List<Long> list = reqVersionIds;
            RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)requirementVersionDao, list);
            Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
            RequirementVersionManagerServiceImpl$AjcClosure7 requirementVersionManagerServiceImpl$AjcClosure7 = new RequirementVersionManagerServiceImpl$AjcClosure7(objectArray);
            List<HashSet> milestoneSetList = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(requirementVersionManagerServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112))).stream().map(RequirementVersion::getProject).distinct().map(p -> new HashSet(p.getMilestones())).toList();
            Set sample = milestoneSetList.get(0);
            allMatch = milestoneSetList.stream().allMatch(set2 -> set2.size() == sample.size() && set2.containsAll(sample));
        }
        return allMatch;
    }

    @Override
    public boolean isOneMilestoneAlreadyBindToAnotherRequirementVersion(List<Long> reqVIds, List<Long> milestoneIds) {
        return this.milestoneDao.isOneMilestoneAlreadyBindToAnotherRequirementVersion(reqVIds, milestoneIds);
    }

    @Override
    public Long findLatestRequirementVersionByRequirementIdAndVerifyingTestCaseId(long requirementId, long tcId) {
        return this.reqVersionDao.findAllByRequirementIdAndVerifyingTestCaseId(requirementId, tcId);
    }

    @Override
    @Transactional(readOnly=true)
    public Long findReqVersionIdByRequirementAndVersionNumber(long requirementId, Integer versionNumber) {
        RequirementVersion requirementVersion = this.requirementVersionDao.findByRequirementIdAndVersionNumber(requirementId, versionNumber);
        if (requirementVersion != null) {
            return requirementVersion.getId();
        }
        return null;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion' , 'READ') or hasRole('ROLE_ADMIN')")
    public RequirementVersion findByRequirementIdAndVersionNumber(long requirementVersionId, int versionNumber) {
        return this.requirementVersionDao.findByRequirementIdAndVersionNumber(requirementVersionId, versionNumber);
    }

    private RequirementVersion copyAttachmentsForNewVersions(Requirement req) {
        RequirementVersion newVersion = req.getCurrentVersion();
        for (Attachment attachment : newVersion.getAttachmentList().getAllAttachments()) {
            this.attachmentManagerService.copyContent(attachment);
        }
        return newVersion;
    }

    static final /* synthetic */ List findAllById_aroundBody0(RequirementVersionManagerServiceImpl requirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody2(RequirementVersionManagerServiceImpl requirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody4(RequirementVersionManagerServiceImpl requirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody6(RequirementVersionManagerServiceImpl requirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RequirementVersionManagerServiceImpl.java", RequirementVersionManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 396);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 504);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 524);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 572);
    }
}

