/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Provider;
import java.util.Collection;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;

@Repository
public class HibernateSprintGroupDao
extends HibernateEntityDao<SprintGroup>
implements SprintGroupDao {
    private final DSLContext dslContext;
    private final Provider<HibernateCampaignFolderDao> campaignFolderDaoProvider;
    private final Provider<HibernateSprintDao> sprintDaoProvider;

    @Autowired
    public HibernateSprintGroupDao(DSLContext dslContext, Provider<HibernateCampaignFolderDao> campaignFolderDaoProvider, Provider<HibernateSprintDao> sprintDaoProvider) {
        this.dslContext = dslContext;
        this.campaignFolderDaoProvider = campaignFolderDaoProvider;
        this.sprintDaoProvider = sprintDaoProvider;
    }

    @Override
    public void setRemoteSyncIdsToNull(List<Long> syncIds) {
        this.dslContext.update((Table)Tables.SPRINT_GROUP).set((Field)Tables.SPRINT_GROUP.REMOTE_SYNCHRONISATION_ID, null).where(Tables.SPRINT_GROUP.REMOTE_SYNCHRONISATION_ID.in(syncIds)).execute();
    }

    @Override
    @UsedInPlugin(value="Xsquash4jira & Xsquash4GitLab")
    public void updateRemoteSyncId(Long clnId, Long syncId) {
        this.dslContext.update((Table)Tables.SPRINT_GROUP).set((Field)Tables.SPRINT_GROUP.REMOTE_SYNCHRONISATION_ID, (Object)syncId).where(Tables.SPRINT_GROUP.CLN_ID.eq((Object)clnId)).execute();
    }

    @Override
    public Long findRootNodeIdByProjectIdAndName(Long projectId, String rootFolderName) {
        return (Long)this.dslContext.select((SelectField)Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_CONTENT).on(Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.NAME.eq((Object)rootFolderName)).and(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Long.class);
    }

    @Override
    @UsedInPlugin(value="Xsquash4jira & Xsquash4GitLab")
    public Long findIdByProjectIdAndRemoteSynchronisationId(Long projectId, Long remoteSynchronisationId) {
        return (Long)this.dslContext.select((SelectField)Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.SPRINT_GROUP.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).and(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Long.class);
    }

    @Override
    @UsedInPlugin(value="Xsquash4jira & Xsquash4GitLab")
    public List<Long> findIdsByClnIds(List<Long> ids) {
        return this.dslContext.select((SelectField)Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).where(Tables.SPRINT_GROUP.CLN_ID.in(ids)).fetchInto(Long.class);
    }

    @Override
    public <LN extends LibraryNode> NodeContainer<LN> findByContent(LN node) {
        SetNodeContentParameter callback = new SetNodeContentParameter(node);
        return (NodeContainer)this.executeEntityNamedQuery("sprintGroup.findByContent", callback);
    }

    @Override
    public SprintGroup loadContainerForPaste(long id) {
        return (SprintGroup)this.entityManager.createQuery("select sg from SprintGroup sg left join fetch sg.content where sg.id = :id", SprintGroup.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<SprintGroup> loadContainersForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct sg from SprintGroup sg left join fetch sg.content where sg.id in :ids", SprintGroup.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public List<SprintGroup> loadNodeForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct sg from SprintGroup sg left join fetch sg.attachmentList al left join fetch al.attachments a left join fetch a.content c where sg.id in :ids", SprintGroup.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public ChildEntityDtoResult loadChildForPaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select c, sg.id from SprintGroup sg join sg.content c where sg.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            switch (k) {
                case CAMPAIGN_FOLDER: {
                    ((HibernateCampaignFolderDao)this.campaignFolderDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case SPRINT: {
                    ((HibernateSprintDao)this.sprintDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported entity type: " + String.valueOf(k));
                }
            }
        });
    }
}

