/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignIteration;
import org.squashtest.tm.jooq.domain.tables.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.tables.Iteration;
import org.squashtest.tm.jooq.domain.tables.IterationTestSuite;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.jooq.domain.tables.TestSuite;
import org.squashtest.tm.jooq.domain.tables.TestSuiteTestPlanItem;
import org.squashtest.tm.service.internal.display.dto.campaign.TestSuiteDto;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;

@Repository
public class TestSuiteDisplayDaoImpl
implements TestSuiteDisplayDao {
    private DSLContext dsl;

    public TestSuiteDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public TestSuiteDto findById(long testSuiteId) {
        return (TestSuiteDto)this.dsl.select((SelectField)TestSuite.TEST_SUITE.ID, (SelectField)TestSuite.TEST_SUITE.UUID, (SelectField)TestSuite.TEST_SUITE.NAME, (SelectField)TestSuite.TEST_SUITE.DESCRIPTION, (SelectField)TestSuite.TEST_SUITE.EXECUTION_STATUS, (SelectField)TestSuite.TEST_SUITE.ATTACHMENT_LIST_ID, (SelectField)TestSuite.TEST_SUITE.CREATED_BY, (SelectField)TestSuite.TEST_SUITE.CREATED_ON, (SelectField)TestSuite.TEST_SUITE.LAST_MODIFIED_BY, (SelectField)TestSuite.TEST_SUITE.LAST_MODIFIED_ON, (SelectField)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)DSL.count((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID).gt((Object)0).as("HAS_AUTOMATED_TESTS"), (SelectField)DSL.count((Field)Tables.TEST_PLAN_ITEM.DATASET_ID).gt((Object)0).as("HAS_DATASETS"), (SelectField)IterationTestSuite.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)TestSuite.TEST_SUITE).join((TableLike)IterationTestSuite.ITERATION_TEST_SUITE).on(TestSuite.TEST_SUITE.ID.eq((Field)IterationTestSuite.ITERATION_TEST_SUITE.TEST_SUITE_ID)).join((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(IterationTestSuite.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM).on(TestSuite.TEST_SUITE.ID.eq((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)TestCase.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)TestCase.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(TestCase.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCase.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Project.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Project.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Project.PROJECT.TA_SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).and(Project.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name()).and(TestCase.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name())).or(Project.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NONE.name()))).and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(TestCase.TEST_CASE.TA_TEST.isNotNull()).or(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(TestCase.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(TestCase.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(TestCase.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()))).where(TestSuite.TEST_SUITE.ID.eq((Object)testSuiteId)).groupBy(new GroupField[]{TestSuite.TEST_SUITE.ID, CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, IterationTestSuite.ITERATION_TEST_SUITE.ITERATION_ID}).fetchOneInto(TestSuiteDto.class);
    }

    @Override
    public List<NamedReference> findForIteration(Long iterationId) {
        return this.dsl.select((SelectField)TestSuite.TEST_SUITE.ID, (SelectField)TestSuite.TEST_SUITE.NAME).from((TableLike)TestSuite.TEST_SUITE).innerJoin((TableLike)IterationTestSuite.ITERATION_TEST_SUITE).on(TestSuite.TEST_SUITE.ID.eq((Field)IterationTestSuite.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(IterationTestSuite.ITERATION_TEST_SUITE.ITERATION_ID.eq((Object)iterationId)).fetch().into(NamedReference.class);
    }

    @Override
    public Long findIterationIdByTestsuiteId(Long testSuiteId) {
        return (Long)this.dsl.select((SelectField)IterationTestSuite.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)IterationTestSuite.ITERATION_TEST_SUITE).where(IterationTestSuite.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)testSuiteId)).fetchOne(0, Long.TYPE);
    }

    @Override
    public HashMap<Long, String> getExecutionStatusMap(Long testSuiteId) {
        return (HashMap)this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)TestSuite.TEST_SUITE).innerJoin((TableLike)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM).on(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)TestSuite.TEST_SUITE.ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(TestSuite.TEST_SUITE.ID.eq((Object)testSuiteId)).fetch().intoMap((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS);
    }

    @Override
    public int getNbTestPlanItem(Long testSuiteId, String login) {
        Integer count;
        SelectConditionStep allTestPlanItemsFromCampaign = this.dsl.selectCount().from((TableLike)TestSuite.TEST_SUITE).innerJoin((TableLike)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM).on(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)TestSuite.TEST_SUITE.ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID)).where(TestSuite.TEST_SUITE.ID.eq((Object)testSuiteId));
        if (login != null) {
            allTestPlanItemsFromCampaign = allTestPlanItemsFromCampaign.and(Tables.CORE_USER.LOGIN.eq((Object)login));
        }
        return (count = (Integer)allTestPlanItemsFromCampaign.groupBy(new GroupField[]{TestSuite.TEST_SUITE.ID}).fetchOneInto(Integer.TYPE)) != null ? count : 0;
    }

    @Override
    public ExecutionStatus findTestSuiteStatusById(Long testSuiteId) {
        String executionStatus = (String)this.dsl.select((SelectField)TestSuite.TEST_SUITE.EXECUTION_STATUS).from((TableLike)TestSuite.TEST_SUITE).where(TestSuite.TEST_SUITE.ID.eq((Object)testSuiteId)).fetchOneInto(String.class);
        return ExecutionStatus.valueOf((String)executionStatus);
    }

    @Override
    public Set<Long> findCampaignIdsBySuiteIds(Set<Long> longs) {
        return this.dsl.select((SelectField)CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID).from((TableLike)CampaignIteration.CAMPAIGN_ITERATION).innerJoin((TableLike)Iteration.ITERATION).on(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Iteration.ITERATION.ITERATION_ID)).innerJoin((TableLike)IterationTestSuite.ITERATION_TEST_SUITE).on(Iteration.ITERATION.ITERATION_ID.eq((Field)IterationTestSuite.ITERATION_TEST_SUITE.ITERATION_ID)).where(IterationTestSuite.ITERATION_TEST_SUITE.TEST_SUITE_ID.in(longs)).fetchSet((Field)CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID);
    }

    @Override
    public List<NamedReference> findNamedReferences(List<Long> testSuiteIds) {
        return this.dsl.select((SelectField)TestSuite.TEST_SUITE.ID, (SelectField)TestSuite.TEST_SUITE.NAME).from((TableLike)TestSuite.TEST_SUITE).where(TestSuite.TEST_SUITE.ID.in(testSuiteIds)).fetch().into(NamedReference.class);
    }

    @Override
    public Map<Long, List<Long>> findExecutionIdsBySuiteIds(List<Long> targetIds) {
        return this.dsl.select((SelectField)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM).leftJoin((TableLike)Tables.EXECUTION).on(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).where(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(targetIds)).fetchGroups((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (Field)Tables.EXECUTION.EXECUTION_ID);
    }

    @Override
    public Map<Long, Set<Long>> findLinkedSuites(Set<Long> testSuiteIds) {
        TestSuiteTestPlanItem linkedSuite = TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.as("linkedSuite");
        Map resultWithDuplicates = this.dsl.select((SelectField)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (SelectField)linkedSuite.field((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).from((TableLike)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM).innerJoin((TableLike)linkedSuite).on(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq(linkedSuite.field((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID))).where(TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(testSuiteIds)).fetchGroups((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, linkedSuite.field((Field)TestSuiteTestPlanItem.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID));
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        for (Map.Entry entry : resultWithDuplicates.entrySet()) {
            result.put((Long)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        return result;
    }
}

