/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Record3;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.display.SingleHierarchyTreeBrowserDao;
import org.squashtest.tm.service.internal.repository.display.impl.SingleHierarchyAncestorLookupDefinition;
import org.squashtest.tm.service.internal.repository.display.impl.SingleHierarchyDescendantLookupDefinition;
import org.squashtest.tm.service.internal.repository.display.impl.SingleHierarchyLibraryLookupDefinition;

@Repository
public class SingleHierarchyTreeBrowserDaoImpl
implements SingleHierarchyTreeBrowserDao {
    public static final String LIBRARY = "LIBRARY";
    private final DSLContext dsl;
    private final Map<NodeType, SingleHierarchyLibraryLookupDefinition> singleHierarchyLibrariesLookupDefinitions;
    private final Map<NodeType, SingleHierarchyAncestorLookupDefinition> singleHierarchyAncestorLookupDefinitions;
    private final Map<NodeType, SingleHierarchyDescendantLookupDefinition> singleHierarchyDescendantLookupDefinitions;

    public SingleHierarchyTreeBrowserDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
        this.singleHierarchyAncestorLookupDefinitions = EnumSet.allOf(SingleHierarchyAncestorLookupDefinition.class).stream().collect(Collectors.toMap(SingleHierarchyAncestorLookupDefinition::getLibraryNodeType, Function.identity()));
        this.singleHierarchyLibrariesLookupDefinitions = EnumSet.allOf(SingleHierarchyLibraryLookupDefinition.class).stream().collect(Collectors.toMap(SingleHierarchyLibraryLookupDefinition::getLibraryNodeType, Function.identity()));
        this.singleHierarchyDescendantLookupDefinitions = EnumSet.allOf(SingleHierarchyDescendantLookupDefinition.class).stream().collect(Collectors.toMap(SingleHierarchyDescendantLookupDefinition::getLibraryNodeType, Function.identity()));
    }

    @Override
    @UsedInPlugin(value="rest-api")
    public Set<NodeReference> findLibraryReferences(NodeWorkspace workspace, Collection<Long> projectIds) {
        SingleHierarchyLibraryLookupDefinition lookupDefinition = this.singleHierarchyLibrariesLookupDefinitions.get(workspace.getLibraryType());
        return this.dsl.select(lookupDefinition.getNodeIdColumn()).from((TableLike)Tables.PROJECT).innerJoin(lookupDefinition.getNodeTable()).on(lookupDefinition.getLibraryColumnInProject().eq(lookupDefinition.getEntityIdColumn())).and(lookupDefinition.getEntityTypeColumn().eq((Object)LIBRARY)).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetch(lookupDefinition.getNodeIdColumn()).stream().map(id -> new NodeReference(workspace.getLibraryType(), id)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    @UsedInPlugin(value="rest-api")
    public ListMultimap<NodeReference, NodeReference> findChildrenReference(Set<NodeReference> parentReferences) {
        Set parentIds = parentReferences.stream().map(NodeReference::getId).collect(Collectors.toSet());
        Map parentById = parentReferences.stream().collect(Collectors.toMap(NodeReference::getId, Function.identity()));
        ArrayListMultimap childrenReferences = ArrayListMultimap.create();
        Optional nodeReference = parentReferences.stream().findFirst();
        if (nodeReference.isPresent()) {
            SingleHierarchyDescendantLookupDefinition lookupDefinition = this.findLookupDefinition((NodeReference)nodeReference.get());
            this.dsl.select(lookupDefinition.getNodePrimaryKey(), lookupDefinition.getDiscriminatorField(), lookupDefinition.getAncestorField()).from(lookupDefinition.getNodeTable()).innerJoin(lookupDefinition.getHierarchyTable()).on(lookupDefinition.getDescendantField().eq(lookupDefinition.getNodePrimaryKey())).where(lookupDefinition.getAncestorField().in(parentIds)).orderBy(lookupDefinition.getOrderField()).forEach(arg_0 -> SingleHierarchyTreeBrowserDaoImpl.lambda$7(lookupDefinition, (ListMultimap)childrenReferences, parentById, arg_0));
        }
        return childrenReferences;
    }

    private SingleHierarchyDescendantLookupDefinition findLookupDefinition(NodeReference nodeReference) {
        NodeType nodeType = nodeReference.getNodeType();
        if (!nodeType.isLibrary()) {
            nodeType = nodeType.getLibraryType();
        }
        return this.singleHierarchyDescendantLookupDefinitions.get(nodeType);
    }

    @Override
    public Set<NodeReference> findAncestors(NodeReferences nodeReferences) {
        Set filteredReferences = nodeReferences.extractNonLibraries();
        return filteredReferences.stream().findFirst().map(nodeReference -> this.getAncestorReferences(this.singleHierarchyAncestorLookupDefinitions.get(nodeReference.getNodeType().getLibraryType()), filteredReferences)).orElseGet(HashSet::new);
    }

    private Set<NodeReference> getAncestorReferences(SingleHierarchyAncestorLookupDefinition ancestorLookupDefinition, Set<NodeReference> descendants) {
        if (descendants.isEmpty()) {
            return new HashSet<NodeReference>();
        }
        Set descendantIds = descendants.stream().map(NodeReference::getId).collect(Collectors.toSet());
        List nodeReferences = this.dsl.select(ancestorLookupDefinition.getAncestorField(), ancestorLookupDefinition.getDiscriminatorField()).from(ancestorLookupDefinition.getHierarchyTable()).innerJoin(ancestorLookupDefinition.getNodeTable()).on(ancestorLookupDefinition.getNodePrimaryKey().eq(ancestorLookupDefinition.getAncestorField())).where(ancestorLookupDefinition.getDescendantField().in(descendantIds)).and(ancestorLookupDefinition.getAncestorField().notIn(descendantIds)).fetch(record -> {
            NodeType nodeType = ancestorLookupDefinition.discriminateAncestor((String)record.get(ancestorLookupDefinition.getDiscriminatorField()));
            Long id = (Long)record.get(ancestorLookupDefinition.getAncestorField());
            return new NodeReference(nodeType, id);
        });
        return new HashSet<NodeReference>(nodeReferences);
    }

    private static /* synthetic */ void lambda$7(SingleHierarchyDescendantLookupDefinition singleHierarchyDescendantLookupDefinition, ListMultimap listMultimap, Map map, Record3 record) {
        NodeType childType = singleHierarchyDescendantLookupDefinition.discriminateDescendant((String)record.get(singleHierarchyDescendantLookupDefinition.getDiscriminatorField()));
        Long childId = (Long)record.get(singleHierarchyDescendantLookupDefinition.getNodePrimaryKey());
        Long parentId = (Long)record.get(singleHierarchyDescendantLookupDefinition.getAncestorField());
        NodeReference childReference = new NodeReference(childType, childId);
        listMultimap.put((Object)((NodeReference)map.get(parentId)), (Object)childReference);
    }
}

