/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record4;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.service.internal.display.dto.requirement.HighLevelRequirementVersionDto;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;

@Repository
public class HighLevelRequirementDisplayDaoImpl
implements HighLevelRequirementDisplayDao {
    private static final String LINKED_LOW_LEVEL_REQ_VERSION_ALIAS = "LINKED_LOW_LEVEL_REQ_VERSION";
    private static final String REQUIREMENT_ID = "REQUIREMENT_ID";
    private static final String REQUIREMENT_VERSION_ID = "REQUIREMENT_VERSION_ID";
    private static final String PROJECT_NAME = "PROJECT_NAME";
    private static final String MILESTONE_SUB_SELECT_RES_ID = "MILESTONE_SUB_SELECT_RES_ID";
    private static final String MILESTONE_LABELS = "MILESTONE_LABELS";
    private static final String MILESTONE_MAX_DATE = "MILESTONE_MAX_DATE";
    private static final String MILESTONE_MIN_DATE = "MILESTONE_MIN_DATE";
    private static final String NB_VERIFYING_TEST_CASES = "NB_VERIFYING_TEST_CASES";
    private final DSLContext dslContext;
    private final RequirementDao requirementDao;

    public HighLevelRequirementDisplayDaoImpl(DSLContext dslContext, RequirementDao requirementDao) {
        this.dslContext = dslContext;
        this.requirementDao = requirementDao;
    }

    @Override
    public List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> findLinkedLowLevelRequirements(Long requirementId) {
        Set<Long> linkedRequirementIds = this.findLinkedLowLevelRequirementIdsByRequirementIds(Collections.singletonList(requirementId));
        HashSet<Long> ancestorIds = new HashSet<Long>(linkedRequirementIds);
        ancestorIds.add(requirementId);
        List<Long> descendantIds = this.requirementDao.findDescendantRequirementIds(new ArrayList<Long>(ancestorIds));
        HashSet<Long> requirementToFetch = new HashSet<Long>(linkedRequirementIds);
        requirementToFetch.addAll(descendantIds);
        return this.fetchProjections(requirementToFetch);
    }

    @Override
    public Set<Long> findRequirementIdsByLibraryIds(Collection<Long> readLibIds, boolean isExtendedHighLvlReqScope) {
        SelectConditionStep reqIds = this.dslContext.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.RL_ID.in(readLibIds));
        if (isExtendedHighLvlReqScope) {
            reqIds.union((Select)this.dslContext.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).join((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.RL_ID.in(readLibIds)));
        }
        return reqIds.fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    @Override
    public Set<Long> findRequirementIdsByNodeIds(Collection<Long> readNodeIds, boolean isExtendedHighLvlReqScope) {
        SelectConditionStep reqIds = this.dslContext.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(readNodeIds));
        if (isExtendedHighLvlReqScope) {
            reqIds.union((Select)this.dslContext.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).join((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(readNodeIds)));
        }
        return reqIds.fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    @Override
    @UsedInPlugin(value="rest-api")
    public Set<Long> findStandardRequirementsByHighLvlReqId(Long highLevelRequirementId) {
        return this.findLinkedLowLevelRequirementIdsByRequirementIds(Collections.singletonList(highLevelRequirementId));
    }

    @Override
    public Set<Long> findStandardRequirementsByRequirementIdsAndProjectIds(List<Long> requirementIds, List<Long> projectIds) {
        return this.findLinkedLowLevelRequirementIdsByRequirementIdsAndProjectIds(requirementIds, projectIds);
    }

    @Override
    public Set<Long> findLinkedLowLevelReqVersionIdsByReqVersionIdsAndProjectIds(List<Long> requirementVersionIds, List<Long> projectIds) {
        RequirementVersion linkedLowLevelReqVersion = Tables.REQUIREMENT_VERSION.as(LINKED_LOW_LEVEL_REQ_VERSION_ALIAS);
        return this.dslContext.selectDistinct((SelectField)linkedLowLevelReqVersion.RES_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).innerJoin((TableLike)linkedLowLevelReqVersion).on(Tables.REQUIREMENT.RLN_ID.eq((Field)linkedLowLevelReqVersion.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetchSet((Field)linkedLowLevelReqVersion.RES_ID);
    }

    @Override
    public Map<Long, List<Long>> findAllLinkedLowLevelReqIdsMappedByHighLevelReqIdFromVersionIds(List<Long> versionIds) {
        Field highLevelRequirementIdField = DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNull(), (Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID).otherwise((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID);
        return this.dslContext.selectDistinct((SelectField)highLevelRequirementIdField, (SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).or(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNull().and(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.isNotNull().and(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)))).where(Tables.REQUIREMENT_VERSION.RES_ID.in(versionIds)).fetchGroups(highLevelRequirementIdField, (Field)Tables.REQUIREMENT.RLN_ID);
    }

    private List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> fetchProjections(Set<Long> requirementsToFetch) {
        List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> levelRequirements = this.fetchBaseProjections(requirementsToFetch);
        levelRequirements.forEach(dto -> {
            if (this.requirementDao.checkIfRequirementIsChild(dto.getRequirementId())) {
                dto.setChildOfRequirement(true);
            }
        });
        return levelRequirements;
    }

    private List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> fetchBaseProjections(Set<Long> requirementsToFetch) {
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneSubSelect = this.getMilestoneDates(requirementsToFetch);
        return this.dslContext.select((SelectField)Tables.REQUIREMENT.RLN_ID.as(REQUIREMENT_ID), (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.RESOURCE.RES_ID.as(REQUIREMENT_VERSION_ID), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, (SelectField)Tables.PROJECT.NAME.as(PROJECT_NAME), (SelectField)DSL.field((String)MILESTONE_LABELS), (SelectField)DSL.field((String)MILESTONE_MIN_DATE), (SelectField)DSL.field((String)MILESTONE_MAX_DATE), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)DSL.selectCount().from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).asField(NB_VERIFYING_TEST_CASES)).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin(milestoneSubSelect).on(milestoneSubSelect.field(MILESTONE_SUB_SELECT_RES_ID, Long.class).eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.REQUIREMENT.RLN_ID.in(requirementsToFetch)).fetchInto(HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto.class);
    }

    private Set<Long> findLinkedLowLevelRequirementIdsByRequirementIds(List<Long> requirementIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).where(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.in(requirementIds)).fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    private Set<Long> findLinkedLowLevelRequirementIdsByRequirementIdsAndProjectIds(List<Long> requirementIds, List<Long> projectIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.in(requirementIds)).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    private SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates(Set<Long> requirementsToFetch) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID.as(MILESTONE_SUB_SELECT_RES_ID), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as(MILESTONE_MIN_DATE), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as(MILESTONE_MAX_DATE), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as(MILESTONE_LABELS)).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.in(requirementsToFetch)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID, Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID});
    }
}

