/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionView;
import org.squashtest.tm.service.internal.display.dto.execution.ExploratorySessionOverviewDto;
import org.squashtest.tm.service.internal.display.dto.execution.ModificationDuringExecutionView;
import org.squashtest.tm.service.internal.repository.display.ExecutionDisplayDao;

@Repository
public class ExecutionDisplayDaoImpl
implements ExecutionDisplayDao {
    private final DSLContext dsl;

    public ExecutionDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public ExecutionView findExecutionView(Long executionId) {
        return this.findExecutionLinkedToTestPlanItem(executionId);
    }

    public ExecutionView findExecutionLinkedToTestPlanItem(Long executionId) {
        Record record = this.dsl.select(new SelectFieldOrAsterisk[]{Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION.NAME, Tables.EXECUTION.PREREQUISITE, Tables.EXECUTION.DESCRIPTION, Tables.EXECUTION.ATTACHMENT_LIST_ID, Tables.EXECUTION.TCLN_ID, Tables.EXECUTION.TC_DESCRIPTION, Tables.EXECUTION.IMPORTANCE, Tables.EXECUTION.TC_STATUS, Tables.EXECUTION.TC_NAT_LABEL, Tables.EXECUTION.TC_NAT_ICON_NAME, Tables.EXECUTION.TC_TYP_LABEL, Tables.EXECUTION.TC_TYP_ICON_NAME, Tables.EXECUTION.DATASET_LABEL, Tables.EXECUTION.EXECUTION_MODE, Tables.EXECUTION.LAST_EXECUTED_ON, Tables.EXECUTION.LAST_EXECUTED_BY, Tables.EXECUTION.EXECUTION_STATUS, Tables.EXECUTION.EXECUTION_ORDER, Tables.TEST_PLAN_ITEM.TEST_PLAN_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, DSL.when((Condition)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.isNotNull(), (Field)Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID).otherwise((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID).as("ASSIGNEE_ID"), Tables.PROJECT.PROJECT_ID, Tables.TEST_AUTOMATION_SERVER.KIND, Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID, Tables.AUTOMATED_EXECUTION_EXTENDER.RESULT_URL, Tables.AUTOMATED_EXECUTION_EXTENDER.RESULT_SUMMARY, Tables.AUTOMATED_EXECUTION_EXTENDER.DURATION, Tables.KEYWORD_EXECUTION.EXECUTION_ID, Tables.SCRIPTED_EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION.REVIEWED, Tables.EXPLORATORY_EXECUTION.TASK_DIVISION, Tables.SPRINT.STATUS}).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY).on(Tables.CAMPAIGN_LIBRARY.CL_ID.eq((Field)Tables.TEST_PLAN.CL_ID)).leftJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID)).leftJoin((TableLike)Tables.KEYWORD_EXECUTION).on(Tables.KEYWORD_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.SCRIPTED_EXECUTION).on(Tables.SCRIPTED_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXPLORATORY_EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOne();
        Long executionCount = (Long)this.dsl.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.EXECUTION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Object)((Long)record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)))).fetchOneInto(Long.class);
        ExecutionView executionView = new ExecutionView();
        executionView.setId((Long)record.get((Field)Tables.EXECUTION.EXECUTION_ID));
        executionView.setName((String)record.get((Field)Tables.EXECUTION.NAME));
        executionView.setExecutionOrder((Integer)record.get((Field)Tables.EXECUTION.EXECUTION_ORDER));
        executionView.setProjectId((Long)record.get((Field)Tables.PROJECT.PROJECT_ID));
        executionView.setPrerequisite((String)record.get((Field)Tables.EXECUTION.PREREQUISITE));
        executionView.setTcDescription((String)record.get((Field)Tables.EXECUTION.TC_DESCRIPTION));
        executionView.setTcImportance((String)record.get((Field)Tables.EXECUTION.IMPORTANCE));
        executionView.setTcStatus((String)record.get((Field)Tables.EXECUTION.TC_STATUS));
        executionView.setTcNatLabel((String)record.get((Field)Tables.EXECUTION.TC_NAT_LABEL));
        executionView.setTcNatIconName((String)record.get((Field)Tables.EXECUTION.TC_NAT_ICON_NAME));
        executionView.setTcTypeLabel((String)record.get((Field)Tables.EXECUTION.TC_TYP_LABEL));
        executionView.setTcTypeIconName((String)record.get((Field)Tables.EXECUTION.TC_TYP_ICON_NAME));
        executionView.setDatasetLabel((String)record.get((Field)Tables.EXECUTION.DATASET_LABEL));
        executionView.setAttachmentListId((Long)record.get((Field)Tables.EXECUTION.ATTACHMENT_LIST_ID));
        executionView.setTestCaseId((Long)record.get((Field)Tables.EXECUTION.TCLN_ID));
        executionView.setExecutionMode((String)record.get((Field)Tables.EXECUTION.EXECUTION_MODE));
        executionView.setLastExecutedOn((Date)record.get((Field)Tables.EXECUTION.LAST_EXECUTED_ON));
        executionView.setLastExecutedBy((String)record.get((Field)Tables.EXECUTION.LAST_EXECUTED_BY));
        executionView.setExecutionStatus((String)record.get((Field)Tables.EXECUTION.EXECUTION_STATUS));
        executionView.setExtenderId((Long)record.get((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID));
        executionView.setTestAutomationServerKind((String)record.get((Field)Tables.TEST_AUTOMATION_SERVER.KIND));
        executionView.setAutomatedExecutionResultUrl((String)record.get((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.RESULT_URL));
        executionView.setAutomatedExecutionResultSummary((String)record.get((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.RESULT_SUMMARY));
        executionView.setAutomatedExecutionDuration((Integer)record.get((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.DURATION));
        executionView.setComment((String)record.get((Field)Tables.EXECUTION.DESCRIPTION));
        executionView.setKeywordExecutionId((Long)record.get((Field)Tables.KEYWORD_EXECUTION.EXECUTION_ID));
        executionView.setScriptedExecutionId((Long)record.get((Field)Tables.SCRIPTED_EXECUTION.EXECUTION_ID));
        executionView.setTestPlanItemId((Long)record.get((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID));
        executionView.setExecutionsCount(executionCount);
        executionView.setAssigneeId((Long)record.get("ASSIGNEE_ID", Long.class));
        executionView.setReviewed((Boolean)record.get((Field)Tables.EXPLORATORY_EXECUTION.REVIEWED));
        executionView.setTaskDivision((String)record.get((Field)Tables.EXPLORATORY_EXECUTION.TASK_DIVISION));
        if (record.get((Field)Tables.SPRINT.STATUS) != null) {
            executionView.setParentSprintStatus(SprintStatus.valueOf((String)((String)record.get((Field)Tables.SPRINT.STATUS))));
        }
        return executionView;
    }

    @Override
    public List<ModificationDuringExecutionView.ExecutionStepActionTestStepPair> findExecutionStepActionStepPairs(Long executionId) {
        return this.dsl.select((SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)Tables.TEST_STEP.TEST_STEP_ID).from((TableLike)Tables.EXECUTION_EXECUTION_STEPS).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).innerJoin((TableLike)Tables.TEST_STEP).on(Tables.EXECUTION_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_STEP.TEST_STEP_ID)).where(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Object)executionId)).orderBy((OrderField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.asc()).fetchInto(ModificationDuringExecutionView.ExecutionStepActionTestStepPair.class);
    }

    @Override
    public Set<Long> findAllTestCaseInExecution(Long executionId) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.EXECUTION_EXECUTION_STEPS).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).innerJoin((TableLike)Tables.TEST_STEP).on(Tables.EXECUTION_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Object)executionId)).fetchSet((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID);
    }

    @Override
    public Long findAttachmentList(Long executionId) {
        return (Long)this.dsl.select((SelectField)Tables.EXECUTION.ATTACHMENT_LIST_ID).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(Long.class);
    }

    @Override
    public ExploratorySessionOverviewDto findSessionByExecutionId(Long executionId) {
        return (ExploratorySessionOverviewDto)this.dsl.select((SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.as("sessionOverviewId"), (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_DURATION, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.CHARTER).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(ExploratorySessionOverviewDto.class);
    }
}

