/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.SprintRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;

public interface SprintRequirementSyncExtenderDao
extends JpaRepository<SprintRequirementSyncExtender, Long> {
    @Query(value="    delete SprintRequirementSyncExtender extender\n    where extender.sprintReqVersion.id\n    in (select srv.id\n        from SprintReqVersion srv\n        where srv.sprint.id = :sprintId)\n")
    @Modifying
    public void deleteAllSprintReqSyncExtendersBySprintId(@Param(value="sprintId") Long var1);

    @Query(value="delete SprintRequirementSyncExtender extender where extender.remoteSynchronisation.id in (:ids)")
    @Modifying
    public void deleteByRemoteSynchronisationIds(@Param(value="ids") List<Long> var1);

    @Query(value="select extender from SprintRequirementSyncExtender extender left join fetch extender.sprintReqVersion reqVersion where reqVersion.sprint.id = :sprintId and extender.remoteSynchronisation.id = :remoteSyncId and extender.remoteReqId = :remoteReqId ")
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public SprintRequirementSyncExtender findBySprintIdRemoteSyncIdAndRemoteReqId(@Param(value="sprintId") long var1, @Param(value="remoteSyncId") long var3, @Param(value="remoteReqId") String var5);

    @Query(value="update SprintRequirementSyncExtender ex set ex.remotePerimeterStatus=:status where ex.sprintReqVersion.id in (:sprintReqVersions)")
    @Modifying
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void updatePerimeterStatusForSprintReqVersions(@Param(value="sprintReqVersions") List<Long> var1, @Param(value="status") RemoteRequirementPerimeterStatus var2);

    @Query(value="update SprintRequirementSyncExtender ex set ex.remotePerimeterStatus=:status where ex.remoteSynchronisation.id = :remoteSyncId")
    @Modifying
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void updatePerimeterStatusByRemoteSyncId(@Param(value="remoteSyncId") Long var1, @Param(value="status") RemoteRequirementPerimeterStatus var2);

    @Query(value="update SprintRequirementSyncExtender ex set ex.remotePerimeterStatus=:status where ex.remoteReqId in (:remoteReqIds) and ex.sprintReqVersion in (select srv from SprintReqVersion srv where srv.sprint.id = (:sprintId))")
    @Modifying
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void updatePerimeterStatus(@Param(value="remoteReqIds") List<String> var1, @Param(value="sprintId") Long var2, @Param(value="status") RemoteRequirementPerimeterStatus var3);

    @Query(value="    select extender.remoteReqId from SprintRequirementSyncExtender extender\n    inner join extender.sprintReqVersion reqVersion\n    where reqVersion.sprint.id in (:sprintIds)\n")
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public List<String> findRemoteKeysBySprintIds(@Param(value="sprintIds") List<Long> var1);
}

