/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.service.annotation.EmptyCollectionGuard;
import org.squashtest.tm.service.internal.repository.CustomAttachmentDao;

public interface AttachmentDao
extends JpaRepository<Attachment, Long>,
CustomAttachmentDao {
    @Query
    public Set<Attachment> findAllByListId(@Param(value="id") Long var1);

    @Query(value="select Attachment from AttachmentList AttachmentList join AttachmentList.attachments Attachment where AttachmentList.id = :id")
    public Page<Attachment> findAllAttachmentsPagined(@Param(value="id") Long var1, Pageable var2);

    @Query(value="select Attachment.id from AttachmentList AttachmentList join AttachmentList.attachments Attachment where AttachmentList.id in (:ids)")
    public Set<Long> findAllAttachmentsFromLists(@Param(value="ids") List<Long> var1);

    @Modifying
    @Query(value="delete Attachment at where at.id in (:ids)")
    public void removeAllAttachments(@Param(value="ids") Set<Long> var1);

    @Modifying
    @Query(value="delete AttachmentList al where al.id in (:ids)")
    public void removeAllAttachmentsLists(@Param(value="ids") List<Long> var1);

    @Query(value="select ListAttachment.id from RequirementFolder RequirementFolder inner join RequirementFolder.resource Resource inner join Resource.attachmentList ListAttachment where RequirementFolder.id in (:ids)")
    public List<Long> findAttachmentsListsFromRequirementFolder(@Param(value="ids") List<Long> var1);

    @Query(value="select new org.squashtest.tm.domain.attachment.ExternalContentCoordinates(v.attachmentList.id,Attachment.content.id) from RequirementVersion v inner join  v.attachmentList.attachments Attachment where v.id in (:ids)")
    public List<ExternalContentCoordinates> getListPairContentIDListIDForRequirementVersions(@Param(value="ids") List<Long> var1);

    @Query(value="select new org.squashtest.tm.domain.attachment.ExternalContentCoordinates(Attachment.attachmentList.id,Attachment.content.id) from ExecutionStep exec inner join  exec.attachmentList attachmentList inner join attachmentList.attachments Attachment where exec.id in (:ids)")
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutionSteps(@Param(value="ids") List<Long> var1);

    @EmptyCollectionGuard
    @Query(value="select new org.squashtest.tm.domain.attachment.ExternalContentCoordinates(Attachment.attachmentList.id,Attachment.content.id) from Execution exec inner join exec.attachmentList attachmentList inner join attachmentList.attachments Attachment where exec.id in (:ids)")
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutions(@Param(value="ids") List<Long> var1);

    @Query(value="select new org.squashtest.tm.domain.attachment.ExternalContentCoordinates(Attachment.attachmentList.id,Attachment.content.id) from AutomatedSuite automatedSuite inner join automatedSuite.attachmentList attachmentList inner join attachmentList.attachments Attachment where automatedSuite.id in (:ids)")
    public List<ExternalContentCoordinates> getListPairContentIDListIDForAutomatedSuiteIds(@Param(value="ids") List<Long> var1);

    @Query(value="select a from Attachment a join fetch a.content where a.id in (:attachmentIds)")
    public List<Attachment> findAttachmentsForDeletion(@Param(value="attachmentIds") List<Long> var1);

    @Query(value="select a from Attachment a join fetch a.content c where c.id in (:attachmentContentIds)")
    public List<Attachment> findAttachmentsByContentIds(@Param(value="attachmentContentIds") Collection<Long> var1);
}

