/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;

public class PivotSubElementRecordProcessor<T extends AbstractPivotObject>
implements AutoCloseable {
    private PivotSubElementContainer<T> pivotSubElementContainer;
    private final Stream<? extends Record> stream;
    private final Iterator<? extends Record> recordIterator;
    private final Field<Long> mainPivotEntityIdField;
    private final Field<Long> subElementIdField;
    private final Function<Record, T> converterToPivot;
    private final BiConsumer<T, Record> appendSubElementToPivotSubElement;
    private final Class<T> pivotSubElementClazz;

    public PivotSubElementRecordProcessor(ResultQuery<? extends Record> query, Field<Long> mainPivotEntityIdField, Field<Long> subElementIdField, Function<Record, T> converterToPivot, Class<T> pivotSubElementClazz) {
        this.stream = query.fetchStream();
        this.recordIterator = this.stream.iterator();
        this.mainPivotEntityIdField = mainPivotEntityIdField;
        this.subElementIdField = subElementIdField;
        this.converterToPivot = converterToPivot;
        this.appendSubElementToPivotSubElement = (a, b) -> {};
        this.pivotSubElementContainer = this.getNewPivotSubElementContainerFromRecord();
        this.pivotSubElementClazz = pivotSubElementClazz;
    }

    public PivotSubElementRecordProcessor(ResultQuery<? extends Record> query, Field<Long> mainPivotEntityIdField, Field<Long> subElementIdField, Function<Record, T> converterToPivot, BiConsumer<T, Record> appendSubElementToPivotSubElement, Class<T> pivotSubElementClazz) {
        this.stream = query.fetchStream();
        this.recordIterator = this.stream.iterator();
        this.pivotSubElementClazz = pivotSubElementClazz;
        this.mainPivotEntityIdField = mainPivotEntityIdField;
        this.subElementIdField = subElementIdField;
        this.converterToPivot = converterToPivot;
        this.appendSubElementToPivotSubElement = appendSubElementToPivotSubElement;
        this.pivotSubElementContainer = this.getNewPivotSubElementContainerFromRecord();
    }

    public Class<T> getPivotSubElementClazz() {
        return this.pivotSubElementClazz;
    }

    public List<T> getPivotSubElements(Long mainPivotEntityIdField, boolean isLast) {
        if (this.pivotSubElementContainer != null && mainPivotEntityIdField.equals(this.pivotSubElementContainer.mainPivotEntityId())) {
            ArrayList<T> elements = new ArrayList<T>(this.pivotSubElementContainer.pivotSubElements());
            this.pivotSubElementContainer.pivotSubElements().clear();
            if (!isLast) {
                this.pivotSubElementContainer = this.getNewPivotSubElementContainerFromRecord();
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public PivotSubElementContainer<T> getNewPivotSubElementContainerFromRecord() {
        ArrayList pivotSubElements = new ArrayList();
        Object pivotSubElement = null;
        Long mainPivotEntityId = null;
        Record record = null;
        while (this.recordIterator.hasNext()) {
            if (this.shouldInitializeFirstRecord(pivotSubElements)) {
                record = this.recordIterator.next();
                pivotSubElement = this.processNewRecord(record, pivotSubElements);
                mainPivotEntityId = (Long)record.get(this.mainPivotEntityIdField);
                continue;
            }
            if (pivotSubElements.isEmpty()) {
                pivotSubElement = this.processStoredRecord(pivotSubElements);
                mainPivotEntityId = (Long)this.pivotSubElementContainer.record.get(this.mainPivotEntityIdField);
                continue;
            }
            record = this.recordIterator.next();
            if (this.isSameSubElement(record, pivotSubElement)) {
                this.appendSubElementToPivotSubElement.accept(pivotSubElement, record);
                continue;
            }
            if (this.isSameMainElement(record, mainPivotEntityId)) {
                pivotSubElement = this.processNewRecord(record, pivotSubElements);
                continue;
            }
            return new PivotSubElementContainer(pivotSubElements, mainPivotEntityId, record);
        }
        if (this.shouldProcessLastStoredRecord(pivotSubElements)) {
            this.processStoredRecord(pivotSubElements);
            mainPivotEntityId = (Long)this.pivotSubElementContainer.record.get(this.mainPivotEntityIdField);
        }
        return new PivotSubElementContainer(pivotSubElements, mainPivotEntityId, record);
    }

    private boolean shouldInitializeFirstRecord(List<T> pivotSubElements) {
        return this.pivotSubElementContainer == null && pivotSubElements.isEmpty();
    }

    private boolean shouldProcessLastStoredRecord(List<T> pivotSubElements) {
        return this.pivotSubElementContainer != null && pivotSubElements.isEmpty() && this.pivotSubElementContainer.record != null;
    }

    private T processNewRecord(Record record, List<T> pivotSubElements) {
        AbstractPivotObject pivotSubElement = (AbstractPivotObject)this.converterToPivot.apply(record);
        this.appendSubElementToPivotSubElement.accept(pivotSubElement, record);
        pivotSubElements.add(pivotSubElement);
        return (T)pivotSubElement;
    }

    private T processStoredRecord(List<T> pivotSubElements) {
        AbstractPivotObject pivotSubElement = (AbstractPivotObject)this.converterToPivot.apply(this.pivotSubElementContainer.record);
        this.appendSubElementToPivotSubElement.accept(pivotSubElement, this.pivotSubElementContainer.record);
        pivotSubElements.add(pivotSubElement);
        return (T)pivotSubElement;
    }

    private boolean isSameSubElement(Record record, T pivotSubElement) {
        return this.subElementIdField != null && ((Long)record.get(this.subElementIdField)).equals(((AbstractPivotObject)pivotSubElement).pivotIdToSquashId());
    }

    private boolean isSameMainElement(Record record, Long mainPivotEntityId) {
        return mainPivotEntityId.equals(record.get(this.mainPivotEntityIdField));
    }

    @Override
    public void close() {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public record PivotSubElementContainer<T>(List<T> pivotSubElements, Long mainPivotEntityId, Record record) {
    }
}

