/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.DenormalizedValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionEventPivot;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.PivotSubElementRecordProcessor;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class ExecutionPivotDaoImpl
extends AbstractPivotDao<ExecutionPivot>
implements ExecutionPivotDao {
    private static final String CTE_EXECUTION = "CTE_EXECUTION";
    private static final Field<Long> CTE_TEST_PLAN_ITEM_ID = DSL.field((Name)DSL.name((String[])new String[]{"CTE_EXECUTION", Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.getName()}), Long.class);
    private static final Field<Long> CTE_EXECUTION_ID = DSL.field((Name)DSL.name((String[])new String[]{"CTE_EXECUTION", Tables.EXECUTION.EXECUTION_ID.getName()}), Long.class);
    private static final Field<Integer> EXECUTION_STEP_ORDER = DSL.field((String)"EXECUTION_STEP_ORDER", Integer.class);
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public ExecutionPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasExecutionByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).unionAll((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId))));
    }

    private CommonTableExpression<Record2<Long, Long>> getExecutionTableCte(Long projectId) {
        return DSL.name((String)CTE_EXECUTION).fields(CTE_TEST_PLAN_ITEM_ID.getName(), CTE_EXECUTION_ID.getName()).as((ResultQuery)DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)Tables.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Tables.PROJECT.CL_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValue(Long projectId) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> executionCufTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.EXECUTION);
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> executionStepCufTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.EXECUTION_STEP);
        CommonTableExpression<Record2<Long, Long>> cte = this.getExecutionTableCte(projectId);
        SelectOnConditionStep executionQuery = this.dsl.with(new CommonTableExpression[]{cte}).select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null, Integer.class).as(EXECUTION_STEP_ORDER), CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from(cte).join(executionCufTable).on(CTE_EXECUTION_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID));
        SelectOnConditionStep executionStepQuery = this.dsl.select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.as(EXECUTION_STEP_ORDER), CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from(cte).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(CTE_EXECUTION_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID)).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).join(executionStepCufTable).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID));
        return executionQuery.unionAll((Select)executionStepQuery).orderBy(CTE_TEST_PLAN_ITEM_ID, CTE_EXECUTION_ID, EXECUTION_STEP_ORDER).fetchSize(50);
    }

    private ResultQuery<? extends Record> getDenormalizedValue(Long projectId) {
        CommonTableExpression<Record2<Long, Long>> cte = this.getExecutionTableCte(projectId);
        SelectConditionStep executionQuery = this.dsl.with(new CommonTableExpression[]{cte}).select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null, Integer.class).as(EXECUTION_STEP_ORDER), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.CODE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.LABEL, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.POSITION, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE, (SelectField)DSL.when((Condition)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE.eq((Object)InputType.RICH_TEXT.name()), (Field)Tables.DENORMALIZED_FIELD_VALUE.LARGE_VALUE).otherwise((Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE).as(ExecutionPivotDao.DENORMALIZED_VALUE)).from(cte).join((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq(CTE_EXECUTION_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFB_ID)).where(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)DenormalizedFieldHolderType.EXECUTION.name()));
        SelectConditionStep executionStepQuery = this.dsl.select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.as(EXECUTION_STEP_ORDER), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.CODE, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.LABEL, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.POSITION, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE, (SelectField)DSL.when((Condition)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE.eq((Object)InputType.RICH_TEXT.name()), (Field)Tables.DENORMALIZED_FIELD_VALUE.LARGE_VALUE).otherwise((Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE).as(ExecutionPivotDao.DENORMALIZED_VALUE)).from(cte).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(CTE_EXECUTION_ID)).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).join((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFB_ID)).where(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)DenormalizedFieldHolderType.EXECUTION_STEP.name()));
        return executionQuery.unionAll((Select)executionStepQuery).orderBy(CTE_TEST_PLAN_ITEM_ID, CTE_EXECUTION_ID, EXECUTION_STEP_ORDER, (OrderField)Tables.DENORMALIZED_FIELD_VALUE.POSITION).fetchSize(50);
    }

    private ResultQuery<? extends Record> getSessionEvent(Long projectId) {
        return this.dsl.select((SelectField)Tables.EXECUTION.EXECUTION_ID, (SelectField)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_ID, (SelectField)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_DATE, (SelectField)Tables.EXPLORATORY_EXECUTION_EVENT.AUTHOR, (SelectField)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_TYPE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.EXPLORATORY_EXECUTION_EVENT).on(Tables.EXPLORATORY_EXECUTION_EVENT.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (OrderField)Tables.EXECUTION.EXECUTION_ID, (OrderField)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record2<Long, Long>> cte = this.getExecutionTableCte(projectId);
        SelectOnConditionStep executionQuery = this.dsl.with(new CommonTableExpression[]{cte}).select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null, Integer.class).as(EXECUTION_STEP_ORDER), (SelectField)DSL.val(null, Integer.class).as((Field)Tables.SESSION_NOTE.NOTE_ORDER), (SelectField)CTE_EXECUTION_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.EXECUTION.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from(cte).join((TableLike)Tables.EXECUTION).on(CTE_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.EXECUTION.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID));
        SelectOnConditionStep executionStepQuery = this.dsl.select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null, Integer.class).as(EXECUTION_STEP_ORDER), (SelectField)DSL.val(null, Integer.class).as((Field)Tables.SESSION_NOTE.NOTE_ORDER), (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.EXECUTION_STEP.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from(cte).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(CTE_EXECUTION_ID)).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID));
        SelectOnConditionStep sessionNoteQuery = this.dsl.select(CTE_EXECUTION_ID, CTE_TEST_PLAN_ITEM_ID, (SelectField)DSL.val(null, Integer.class).as(EXECUTION_STEP_ORDER), (SelectField)Tables.SESSION_NOTE.NOTE_ORDER, (SelectField)Tables.SESSION_NOTE.NOTE_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.SESSION_NOTE.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from(cte).leftJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq(CTE_EXECUTION_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.SESSION_NOTE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID));
        return executionQuery.unionAll((Select)executionStepQuery).unionAll((Select)sessionNoteQuery).orderBy(CTE_TEST_PLAN_ITEM_ID, CTE_EXECUTION_ID, EXECUTION_STEP_ORDER, (OrderField)Tables.SESSION_NOTE.NOTE_ORDER).fetchSize(50);
    }

    @Override
    public void getExecutionByProjectId(Long projectId, Consumer<ExecutionPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        CommonTableExpression<Record2<Long, Long>> cte = this.getExecutionTableCte(projectId);
        ResultQuery resultQuery = this.dsl.with(new CommonTableExpression[]{cte}).select(new SelectFieldOrAsterisk[]{Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION.TEST_PLAN_ITEM_ID, Tables.EXECUTION.EXECUTION_ORDER, Tables.EXECUTION.EXECUTION_STATUS, Tables.EXECUTION.DESCRIPTION, Tables.EXECUTION.CREATED_BY, Tables.EXECUTION.CREATED_ON, Tables.EXECUTION.LAST_MODIFIED_BY, Tables.EXECUTION.LAST_MODIFIED_ON, Tables.EXECUTION.LAST_EXECUTED_BY, Tables.EXECUTION.LAST_EXECUTED_ON, Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.EXECUTION.REFERENCE, Tables.EXECUTION.NAME, Tables.EXECUTION.TC_DESCRIPTION, Tables.EXECUTION.TC_STATUS, Tables.EXECUTION.IMPORTANCE, Tables.EXECUTION.DATASET_LABEL, Tables.EXECUTION.PREREQUISITE, Tables.EXECUTION.TC_NAT_CODE, Tables.EXECUTION.TC_NAT_LABEL, Tables.EXECUTION.TC_NAT_ICON_NAME, Tables.EXECUTION.TC_TYP_CODE, Tables.EXECUTION.TC_TYP_LABEL, Tables.EXECUTION.TC_TYP_ICON_NAME, Tables.SCRIPTED_EXECUTION.SCRIPT_NAME, Tables.EXPLORATORY_EXECUTION.TASK_DIVISION, Tables.EXPLORATORY_EXECUTION.REVIEWED, DSL.when((Condition)Tables.SCRIPTED_EXECUTION.EXECUTION_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.name()).when(Tables.KEYWORD_EXECUTION.EXECUTION_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.name()).when(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.name()).otherwise((Object)TestCaseKind.STANDARD.name()).as(TestCasePivotDao.TC_KIND), Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.EXECUTION_STATUS, Tables.EXECUTION_STEP.COMMENT, Tables.EXECUTION_STEP.CREATED_BY, Tables.EXECUTION_STEP.CREATED_ON, Tables.EXECUTION_STEP.LAST_MODIFIED_BY, Tables.EXECUTION_STEP.LAST_MODIFIED_ON, Tables.EXECUTION_STEP.LAST_EXECUTED_BY, Tables.EXECUTION_STEP.LAST_EXECUTED_ON, Tables.EXECUTION_STEP.TEST_STEP_ID, Tables.SESSION_NOTE.NOTE_ID, Tables.SESSION_NOTE.NOTE_ORDER, Tables.SESSION_NOTE.CONTENT, Tables.SESSION_NOTE.KIND, Tables.SESSION_NOTE.CREATED_BY, Tables.SESSION_NOTE.CREATED_ON, Tables.SESSION_NOTE.LAST_MODIFIED_BY, Tables.SESSION_NOTE.LAST_MODIFIED_ON, Tables.EXECUTION_STEP.TEST_STEP_ID, Tables.EXECUTION_STEP.ACTION, Tables.EXECUTION_STEP.EXPECTED_RESULT}).from(cte).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(CTE_TEST_PLAN_ITEM_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq(CTE_EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.SCRIPTED_EXECUTION).on(Tables.SCRIPTED_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.KEYWORD_EXECUTION).on(Tables.KEYWORD_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXPLORATORY_EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).orderBy((OrderField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (OrderField)Tables.EXECUTION.EXECUTION_ID, (OrderField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER, (OrderField)Tables.SESSION_NOTE.NOTE_ORDER).fetchSize(50);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.EXECUTION, writingToJsonConsumer, writingAttachmentConsumer);
    }

    @Override
    protected ExecutionPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        ExecutionPivot executionPivot = this.executionWorkspaceConverterService.executionRecordToExecutionPivot(record);
        this.appendExecutionStepToExecutionPivot(executionPivot, record);
        return executionPivot;
    }

    private void appendExecutionStepToExecutionPivot(ExecutionPivot executionPivot, Record record) {
        if (record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID) != null) {
            ExecutionStepPivot executionStepPivot = this.executionWorkspaceConverterService.executionStepRecordToExecutionStepPivot(record);
            executionPivot.addExecutionSteps(executionStepPivot);
        }
        if (record.get((Field)Tables.SESSION_NOTE.NOTE_ID) != null) {
            executionPivot.addSessionNotePivot(this.executionWorkspaceConverterService.sessionNoteRecordToSessionNotePivot(record));
        }
    }

    @Override
    protected void fillPivotObject(ExecutionPivot pivotObject, Record record) {
        this.appendExecutionStepToExecutionPivot(pivotObject, record);
    }

    @Override
    protected List<PivotSubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getCufPivotContainer(projectId), this.getDenormalizedValuePivotContainer(projectId), this.getSessionEventPivotContainer(projectId), this.getAttachmentPivotContainer(this.getAttachmentByProjectIdQuery(projectId), CTE_EXECUTION_ID, (Record record) -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, TestCasePivotDao.ATTACHMENT_HOLDER_ID, TestCasePivotDao.ATTACHMENT_HOLDER_TYPE)));
    }

    private PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Long projectId) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(this.getCustomFieldValue(projectId), CTE_EXECUTION_ID, null, this.customFieldPivotDao::cufValueRecordToCufValuePivot, CustomFieldValuePivot.class);
    }

    private PivotSubElementRecordProcessor<DenormalizedValuePivot> getDenormalizedValuePivotContainer(Long projectId) {
        return new PivotSubElementRecordProcessor<DenormalizedValuePivot>(this.getDenormalizedValue(projectId), CTE_EXECUTION_ID, null, this.executionWorkspaceConverterService::recordToDenormalizedValuePivot, DenormalizedValuePivot.class);
    }

    private PivotSubElementRecordProcessor<SessionEventPivot> getSessionEventPivotContainer(Long projectId) {
        return new PivotSubElementRecordProcessor<SessionEventPivot>(this.getSessionEvent(projectId), (Field<Long>)Tables.EXECUTION.EXECUTION_ID, (Field<Long>)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_ID, this.executionWorkspaceConverterService::sessionEventRecordToSessionEventPivot, SessionEventPivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(ExecutionPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        pivotObject.addAllSessionEvent(this.getSubElement(SessionEventPivot.class, subElementsByClazz));
        this.appendCufDenormalizedAndAttachment(pivotObject, this.getSubElement(CustomFieldValuePivot.class, subElementsByClazz), this.getSubElement(DenormalizedValuePivot.class, subElementsByClazz), this.getSubElement(AttachmentPivot.class, subElementsByClazz), writingAttachmentConsumer);
    }

    private void appendCufDenormalizedAndAttachment(ExecutionPivot executionPivot, List<CustomFieldValuePivot> customFieldValuePivots, List<DenormalizedValuePivot> denormalizedValuePivots, List<AttachmentPivot> attachmentPivots, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        if (customFieldValuePivots.isEmpty() && denormalizedValuePivots.isEmpty() && attachmentPivots.isEmpty()) {
            return;
        }
        Map<Long, ExecutionStepPivot> executionStepsByStepId = executionPivot.getExecutionSteps().stream().collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, Function.identity()));
        this.appendDenormalized(executionPivot, executionStepsByStepId, denormalizedValuePivots);
        this.appendCuf(executionPivot, executionStepsByStepId, customFieldValuePivots);
        this.addAndWriteAttachmentPivot(executionPivot, attachmentPivots, executionStepsByStepId, writingAttachmentConsumer);
    }

    private void appendCuf(ExecutionPivot executionPivot, Map<Long, ExecutionStepPivot> executionStepsByStepId, List<CustomFieldValuePivot> customFieldValuePivots) {
        customFieldValuePivots.forEach(customFieldValuePivot -> {
            if (BindableEntity.EXECUTION.equals((Object)customFieldValuePivot.getBindableEntity())) {
                executionPivot.addCustomField((CustomFieldValuePivot)customFieldValuePivot);
                return;
            }
            executionStepsByStepId.computeIfPresent(customFieldValuePivot.getBindableId(), (k, v) -> {
                v.addCustomField((CustomFieldValuePivot)customFieldValuePivot);
                return v;
            });
        });
    }

    private void appendDenormalized(ExecutionPivot executionPivot, Map<Long, ExecutionStepPivot> executionStepsByStepId, List<DenormalizedValuePivot> denormalizedValues) {
        denormalizedValues.forEach(denormalizedValuePivot -> {
            if (DenormalizedFieldHolderType.EXECUTION.equals((Object)denormalizedValuePivot.getHolderType())) {
                executionPivot.addDenormalizedValue((DenormalizedValuePivot)denormalizedValuePivot);
                return;
            }
            executionStepsByStepId.computeIfPresent(denormalizedValuePivot.getHolderId(), (k, v) -> {
                v.addDenormalizedValue((DenormalizedValuePivot)denormalizedValuePivot);
                return v;
            });
        });
    }

    private void addAndWriteAttachmentPivot(ExecutionPivot executionPivot, List<AttachmentPivot> attachmentPivots, Map<Long, ExecutionStepPivot> executionStepsByStepId, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        Map sessionNotesById = executionPivot.getSessionNotePivots().stream().collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, Function.identity()));
        HashMap<AttachmentEntity, Map<Long, ? extends PivotAttachmentEntity>> attachmentEntityMap = new HashMap<AttachmentEntity, Map<Long, ? extends PivotAttachmentEntity>>();
        attachmentEntityMap.put(AttachmentEntity.EXECUTION_STEP, executionStepsByStepId);
        attachmentEntityMap.put(AttachmentEntity.SESSION_NOTE, sessionNotesById);
        this.addAndWriteAttachmentPivot(attachmentPivots, executionPivot, AttachmentEntity.EXECUTION, attachmentEntityMap, writingAttachmentConsumer);
    }
}

