/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

final class UrlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlParser.class);

    private UrlParser() {
    }

    public static List<String> extractFoldersNames(String path) {
        LinkedList<String> nameList = new LinkedList<String>();
        String trimedPath = path.trim();
        StringReader pathReader = new StringReader(trimedPath);
        try {
            int pathCharInt = pathReader.read();
            if (pathCharInt != -1) {
                pathCharInt = (char)pathCharInt != '/' ? UrlParser.readNextFolder(nameList, pathReader, pathCharInt) : UrlParser.readFirstFolder(nameList, pathReader, pathCharInt);
                while (pathCharInt != -1) {
                    pathCharInt = UrlParser.readNextFolder(nameList, pathReader, pathCharInt);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return nameList;
    }

    private static int readFirstFolder(List<String> nameList, StringReader pathReader, int pathCharIntParam) throws IOException {
        int pathCharInt = pathCharIntParam;
        StringBuilder nameBuffer = new StringBuilder();
        int slashesNumber = 1;
        pathCharInt = pathReader.read();
        while (pathCharInt != -1 && (char)pathCharInt == '/') {
            ++slashesNumber;
            pathCharInt = pathReader.read();
        }
        int slashesToaddToBuffer = UrlParser.isEven(slashesNumber) ? slashesNumber / 2 : (slashesNumber - 1) / 2;
        UrlParser.addSlashesToBuffer(nameBuffer, slashesToaddToBuffer);
        pathCharInt = UrlParser.readName(pathCharInt, pathReader, nameBuffer, nameList);
        return pathCharInt;
    }

    private static int readNextFolder(List<String> nameList, StringReader pathReader, int pathCharInt) throws IOException {
        StringBuilder folderNameBuffer = new StringBuilder();
        return UrlParser.readName(pathCharInt, pathReader, folderNameBuffer, nameList);
    }

    private static int readName(int pathCharIntParam, StringReader pathReader, StringBuilder folderNameBuffer, List<String> nameList) throws IOException {
        Integer slashesNumber = 0;
        int pathCharInt = pathCharIntParam;
        while (pathCharInt != -1) {
            if ((char)pathCharInt == '/') {
                int slashesToAdd;
                while ((char)pathCharInt == '/') {
                    slashesNumber = slashesNumber + 1;
                    pathCharInt = pathReader.read();
                }
                if (!UrlParser.isEven(slashesNumber)) {
                    slashesToAdd = (slashesNumber - 1) / 2;
                    UrlParser.addSlashesToBuffer(folderNameBuffer, slashesToAdd);
                    break;
                }
                slashesToAdd = slashesNumber / 2;
                UrlParser.addSlashesToBuffer(folderNameBuffer, slashesToAdd);
                slashesNumber = 0;
            }
            folderNameBuffer.append((char)pathCharInt);
            pathCharInt = pathReader.read();
        }
        String name = folderNameBuffer.toString();
        nameList.add(name.trim());
        return pathCharInt;
    }

    private static void addSlashesToBuffer(StringBuilder folderNameBuffer, int slashesToAdd) {
        int i = 0;
        while (i < slashesToAdd) {
            folderNameBuffer.append('/');
            ++i;
        }
    }

    private static boolean isEven(int n) {
        return n % 2 == 0;
    }
}

