/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.EnumSet;
import org.squashtest.tm.api.security.acls.Permissions;

public enum AccessPermission {
    MANAGE_PROJECT(Permissions.MANAGE_PROJECT),
    MANAGE_MILESTONE(Permissions.MANAGE_MILESTONE),
    MANAGE_PROJECT_CLEARANCE(Permissions.MANAGE_PROJECT_CLEARANCE),
    READ(Permissions.READ),
    WRITE_AS_AUTOMATION(Permissions.WRITE_AS_AUTOMATION),
    WRITE_AS_FUNCTIONAL(Permissions.WRITE_AS_FUNCTIONAL);

    private final Permissions permissionWithMask;

    private AccessPermission(Permissions permissionWithMask) {
        this.permissionWithMask = permissionWithMask;
    }

    public Permissions getPermissionWithMask() {
        return this.permissionWithMask;
    }

    public static AccessPermission findByMask(int mask) {
        EnumSet<AccessPermission> permissions = EnumSet.allOf(AccessPermission.class);
        for (AccessPermission permission : permissions) {
            if (permission.getPermissionWithMask().getMask() != mask) continue;
            return permission;
        }
        return null;
    }
}

