/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.testcase.exploratory.session;

import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.display.testcase.exploratory.session.TestCaseExploratorySessionsDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.testcase.TestCaseSessionsGrid;
import org.squashtest.tm.service.internal.repository.display.ExploratorySessionOverviewDisplayDao;

@Service
public class TestCaseExploratorySessionsDisplayServiceImpl
implements TestCaseExploratorySessionsDisplayService {
    private final DSLContext dslContext;
    private final ExploratorySessionOverviewDisplayDao exploratorySessionOverviewDisplayDao;

    public TestCaseExploratorySessionsDisplayServiceImpl(DSLContext dslContext, ExploratorySessionOverviewDisplayDao exploratorySessionOverviewDisplayDao) {
        this.dslContext = dslContext;
        this.exploratorySessionOverviewDisplayDao = exploratorySessionOverviewDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public GridResponse findByTestCaseId(Long testCaseId, GridRequest gridRequest) {
        return new TestCaseSessionsGrid(testCaseId).getRows(gridRequest, this.dslContext);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public Integer countExploratorySessionOverviewByTestCaseId(Long testCaseId) {
        return this.exploratorySessionOverviewDisplayDao.countSessionOverviewsByTestCaseId(testCaseId);
    }
}

