/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.Predicate;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.testplan.QTestPlanItem;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;

@Component
public class ItpiExecutionScopeFilterHandler
implements FilterHandler {
    private static final List<EntityType> scopableEntityList = Arrays.asList(EntityType.ITERATION, EntityType.CAMPAIGN, EntityType.CAMPAIGN_FOLDER, EntityType.CAMPAIGN_LIBRARY, EntityType.PROJECT, EntityType.TEST_SUITE);
    @Inject
    CustomItpiLastExecutionFilterDao customItpiLastExecutionFilterDao;
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"ITEM_TEST_PLAN_EXECUTION_SCOPE"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        ItpiExecutionScopeFilterValue executionScopeFilterValue = this.extractFilterValue(filter);
        if (executionScopeFilterValue.requireAdditionalFilterClause()) {
            this.addFilterClause(query, gridRequest.getScope(), gridRequest.getExcludedScope());
        }
    }

    private ItpiExecutionScopeFilterValue extractFilterValue(GridFilterValue filter) {
        List<String> values = filter.getValues();
        if (values.size() != 1) {
            throw new IllegalArgumentException("Invalid value for filter ITEM_TEST_PLAN_EXECUTION_SCOPE");
        }
        return ItpiExecutionScopeFilterValue.valueOf(values.get(0));
    }

    private void addFilterClause(ExtendedHibernateQuery<?> query, List<String> scope, List<String> excludedScope) {
        List<Long> filteredItpiIds;
        EnumMap<EntityType, List<Long>> scopableEntitiesMap = new EnumMap<EntityType, List<Long>>(EntityType.class);
        scopableEntityList.forEach(entityType -> ItpiExecutionScopeFilterHandler.extractEntityIdsFromScope(scope, scopableEntitiesMap, entityType));
        if (!excludedScope.isEmpty()) {
            ItpiExecutionScopeFilterHandler.extractEntityIdsFromScope(excludedScope, scopableEntitiesMap, EntityType.TEST_SUITE);
        }
        if (!(filteredItpiIds = this.customItpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInDynamicScope(scopableEntitiesMap)).isEmpty()) {
            query.where((Predicate)QTestPlanItem.testPlanItem.id.in(filteredItpiIds));
        }
    }

    public static void extractEntityIdsFromScope(List<String> scope, Map<EntityType, List<Long>> scopableEntitiesMap, EntityType entityType) {
        List<Long> scopedEntityIds = scope.stream().map(EntityReference::fromNodeId).filter(scopedEntity -> scopedEntity.getType().equals((Object)entityType)).map(EntityReference::getId).toList();
        if (!scopedEntityIds.isEmpty()) {
            scopableEntitiesMap.put(entityType, scopedEntityIds);
        }
    }

    public static enum ItpiExecutionScopeFilterValue {
        ALL,
        LAST_EXECUTED;


        boolean requireAdditionalFilterClause() {
            return !this.equals((Object)ALL);
        }
    }
}

