/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.requirement;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class RequirementVersionsGrid
extends AbstractGrid {
    private static final String RES_ID = "RES_ID";
    private final Long requirementId;

    public RequirementVersionsGrid(Long requirementId) {
        this.requirementId = requirementId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID), new GridColumn((Field<?>)Tables.REQUIREMENT.RLN_ID), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.RES_ID), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.VERSION_NUMBER), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.REFERENCE), new GridColumn((Field<?>)Tables.RESOURCE.NAME), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.CATEGORY), new GridColumn((Field<?>)Tables.REQUIREMENT_VERSION.CRITICALITY), new LevelEnumColumn(RequirementStatus.class, (Field<String>)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS), new GridColumn(DSL.field((String)"LINKS")), new GridColumn(DSL.field((String)"COVERAGES")), new GridColumn(DSL.field((String)"MILESTONE_MIN_DATE")), new GridColumn(DSL.field((String)"MILESTONE_MAX_DATE")), new GridColumn(DSL.field((String)"MILESTONE_LABELS")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<?> links = this.getRequirementLinks();
        SelectHavingStep<?> coverages = this.getCoverages();
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestones = this.getMilestoneDates();
        return Tables.REQUIREMENT.innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin(links).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(links.field(RES_ID, Long.class))).leftJoin(coverages).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(coverages.field(RES_ID, Long.class))).leftJoin(milestones).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(milestones.field(RES_ID, Long.class)));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.REQUIREMENT_VERSION.RES_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.REQUIREMENT.RLN_ID.eq((Object)this.requirementId);
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.REQUIREMENT_VERSION.VERSION_NUMBER.desc();
    }

    private SelectHavingStep<?> getRequirementLinks() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)DSL.count((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID).as("LINKS")).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_LINK).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID});
    }

    private SelectHavingStep<?> getCoverages() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).as("COVERAGES")).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID});
    }

    private SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MIN_DATE"), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MAX_DATE"), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as("MILESTONE_LABELS")).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID, Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID});
    }
}

