/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.display.dto.testcase.DataSetDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.display.DatasetDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;

@Component
@Scope(value="prototype")
public class AvailableDatasetAppender {
    private static final String TEST_CASE_ID_KEY = "testCaseId";
    private final DatasetDisplayDao datasetDisplayDao;

    public AvailableDatasetAppender(DatasetDisplayDao datasetDisplayDao) {
        this.datasetDisplayDao = datasetDisplayDao;
    }

    public void appendAvailableDatasets(GridResponse response) {
        this.appendAvailableDatasets(response.getDataRows());
    }

    private void appendAvailableDatasets(List<DataRow> dataRows) {
        List<Long> testCaseIds = this.extractTestCaseIds(dataRows);
        Map<Long, List<DataSetDto>> map = this.datasetDisplayDao.findAllByTestCaseIds(testCaseIds);
        String key = RequestAliasesConstants.toCamelCase("AVAILABLE_DATASETS");
        dataRows.forEach(dataRow -> {
            Long testCaseId = (Long)dataRow.getData().get(TEST_CASE_ID_KEY);
            dataRow.getData().put(key, map.getOrDefault(testCaseId, new ArrayList()));
        });
    }

    private List<Long> extractTestCaseIds(List<DataRow> dataRows) {
        return dataRows.stream().map(DataRow::getData).map(data -> (Long)data.get(TEST_CASE_ID_KEY)).toList();
    }
}

