/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSelectStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.service.internal.batchexport.ExportDaoUtils;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.batchexport.models.DatasetModel;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.ParameterModel;
import org.squashtest.tm.service.internal.batchexport.models.TestCaseModel;
import org.squashtest.tm.service.internal.batchexport.models.TestStepModel;
import org.squashtest.tm.service.internal.library.PathService;

@Repository
public class TestCaseExportDao {
    private static final String TEST_CASE_IDS = "testCaseIds";
    private static final InfoListItem TEST_CASE_NATURE = Tables.INFO_LIST_ITEM.as("nature");
    private static final InfoListItem TEST_CASE_TYPE = Tables.INFO_LIST_ITEM.as("type");
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dsl;
    @Inject
    private PathService pathService;

    public ExportModel findModel(List<Long> tclnIds) {
        ExportModel model = new ExportModel();
        List<TestCaseModel> tclnModels = this.findTestCaseModels(tclnIds);
        List<TestStepModel> stepModels = this.findStepsModel(tclnIds);
        List<ParameterModel> paramModels = this.findParametersModel(tclnIds);
        List<DatasetModel> datasetModels = this.findDatasetsModel(tclnIds);
        List<CoverageModel> coverageModels = this.findTestCaseCoverageModel(tclnIds);
        ExportDaoUtils.setPathForCoverage(this.em, this.pathService, coverageModels);
        model.setCoverages(coverageModels);
        model.setTestCases(tclnModels);
        model.setTestSteps(stepModels);
        model.setParameters(paramModels);
        model.setDatasets(datasetModels);
        return model;
    }

    public ExportModel findSimpleModel(List<Long> tclnIds) {
        ExportModel model = new ExportModel();
        List<TestCaseModel> tclnModels = this.findTestCaseModels(tclnIds);
        model.setTestCases(tclnModels);
        return model;
    }

    private List<CoverageModel> findTestCaseCoverageModel(List<Long> tcIds) {
        return ExportDaoUtils.loadModels(this.em, "testCase.excelExportCoverage", tcIds, TEST_CASE_IDS, CoverageModel.class);
    }

    private List<TestCaseModel> loadTestCaseModelsFromFolderWithJOOQ(List<Long> tclnIds) {
        ArrayList<TestCaseModel> result = new ArrayList<TestCaseModel>();
        TableField contentOrderField = Tables.TCLN_RELATIONSHIP.CONTENT_ORDER;
        this.getTestCaseModelSelect((Field<Integer>)contentOrderField).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)TEST_CASE_NATURE).on(TestCaseExportDao.TEST_CASE_NATURE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).join((TableLike)TEST_CASE_TYPE).on(TestCaseExportDao.TEST_CASE_TYPE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).join((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.SCRIPTED_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.KEYWORD_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.AUTOMATED_TEST_TECHNOLOGY).on(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.eq((Field)Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID)).where(Tables.TEST_CASE.TCLN_ID.in(tclnIds)).fetch().forEach(record -> {
            TestCaseModel model = this.createTestCaseModelFromQueryResult((Record)record);
            result.add(model);
        });
        return result;
    }

    private List<TestCaseModel> loadTestCaseModelsFromLibraryWithJOOQ(List<Long> tclnIds) {
        ArrayList<TestCaseModel> result = new ArrayList<TestCaseModel>();
        TableField contentOrderField = Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER;
        this.getTestCaseModelSelect((Field<Integer>)contentOrderField).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)TEST_CASE_NATURE).on(TestCaseExportDao.TEST_CASE_NATURE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE)).join((TableLike)TEST_CASE_TYPE).on(TestCaseExportDao.TEST_CASE_TYPE.ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).join((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.SCRIPTED_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.KEYWORD_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.AUTOMATED_TEST_TECHNOLOGY).on(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.eq((Field)Tables.AUTOMATED_TEST_TECHNOLOGY.AT_TECHNOLOGY_ID)).where(Tables.TEST_CASE.TCLN_ID.in(tclnIds)).fetch().forEach(record -> {
            TestCaseModel model = this.createTestCaseModelFromQueryResult((Record)record);
            result.add(model);
        });
        return result;
    }

    private SelectSelectStep<Record> getTestCaseModelSelect(Field<Integer> contentOrder) {
        return this.dsl.select(new SelectFieldOrAsterisk[]{Tables.TEST_CASE.TCLN_ID, Tables.TEST_CASE.UUID, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.IMPORTANCE_AUTO, Tables.TEST_CASE.AUTOMATABLE, Tables.TEST_CASE.TC_STATUS, Tables.TEST_CASE.PREREQUISITE, Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY, Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON, Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME, Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW, TestCaseExportDao.TEST_CASE_NATURE.LABEL, TestCaseExportDao.TEST_CASE_NATURE.CODE, TestCaseExportDao.TEST_CASE_TYPE.LABEL, TestCaseExportDao.TEST_CASE_TYPE.CODE, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.SCRIPT, Tables.KEYWORD_TEST_CASE.TCLN_ID, this.getMilestonesField().as("MILESTONES"), this.getAttachmentCountField().as("ATTACHMENT_COUNT"), this.getReqVersionCoverageCountField().as("REQ_VERSION_COVERAGE_COUNT"), this.getIterationCountField().as("ITERATION_COUNT"), this.getCallerCountField().as("CALLER_COUNT"), contentOrder.as("CONTENT_ORDER"), this.getDatasetCountField().as("DATASET_COUNT"), this.getMilestoneCountField().as("MILESTONE_COUNT"), this.getTestStepCountField().as("TEST_STEP_COUNT"), this.getParameterCount().as("PARAMETER_COUNT"), this.getExecutionCountField().as("EXECUTION_COUNT"), this.getCallStepCountField().as("CALL_STEP_COUNT"), this.getTcKindField().as("KIND"), Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY, Tables.AUTOMATION_REQUEST.TRANSMITTED_ON, Tables.AUTOMATION_REQUEST.REQUEST_STATUS, Tables.TEST_CASE.TA_TEST, Tables.AUTOMATED_TEST_TECHNOLOGY.NAME, Tables.TEST_CASE.SCM_REPOSITORY_ID, Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE, this.getMilestoneStatusField().as("MILESTONE_STATUS"), this.getMilestoneEndDateField().as("MILESTONE_END_DATE"), this.getIssueCountField().as("ISSUE_COUNT"), Tables.TEST_CASE.DRAFTED_BY_AI});
    }

    private Field<String> getMilestonesField() {
        return DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.MILESTONE.LABEL).separator("|")).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getAttachmentCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.ATTACHMENT.ATTACHMENT_ID)).from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID)).asField();
    }

    private Field<Integer> getReqVersionCoverageCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getIterationCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.ITERATION.ITERATION_ID)).from((TableLike)Tables.ITERATION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getCallerCountField() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).from((TableLike)Tables.TEST_CASE_STEPS).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getDatasetCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.DATASET.DATASET_ID)).from((TableLike)Tables.DATASET).where(Tables.DATASET.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getMilestoneCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).from((TableLike)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getTestStepCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.TEST_CASE_STEPS.STEP_ID)).from((TableLike)Tables.TEST_CASE_STEPS).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getParameterCount() {
        return DSL.select((SelectField)DSL.count((Field)Tables.PARAMETER.PARAM_ID)).from((TableLike)Tables.PARAMETER).where(Tables.PARAMETER.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getExecutionCountField() {
        return DSL.select((SelectField)DSL.count((Field)Tables.EXECUTION.EXECUTION_ID)).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<Integer> getCallStepCountField() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).from((TableLike)Tables.CALL_TEST_STEP).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private Field<String> getTcKindField() {
        return DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.name()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.name()).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.name()).otherwise((Object)TestCaseKind.STANDARD.name());
    }

    private Field<Integer> getMilestoneStatusField() {
        return DSL.select((SelectField)DSL.groupConcat((Field)Tables.MILESTONE.STATUS).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator("|")).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
    }

    private Field<Object> getMilestoneEndDateField() {
        return DSL.select((SelectField)DSL.groupConcat((Field)Tables.MILESTONE.END_DATE).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator("|")).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).asField();
    }

    private Field<Integer> getIssueCountField() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).from((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asField();
    }

    private TestCaseModel createTestCaseModelFromQueryResult(Record record) {
        return new TestCaseModel((Long)record.get((Field)Tables.PROJECT.PROJECT_ID), (Boolean)record.get((Field)Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW), (String)record.get((Field)Tables.PROJECT.NAME), (Integer)Objects.requireNonNull(record.get("CONTENT_ORDER")) + 1, (Long)record.get((Field)Tables.TEST_CASE.TCLN_ID), (String)record.get((Field)Tables.TEST_CASE.UUID), (String)record.get((Field)Tables.TEST_CASE.REFERENCE), (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME), (String)record.get("MILESTONES"), (Boolean)record.get((Field)Tables.TEST_CASE.IMPORTANCE_AUTO), TestCaseImportance.valueOf((String)((String)record.get((Field)Tables.TEST_CASE.IMPORTANCE))), (org.squashtest.tm.domain.infolist.InfoListItem)new ListItemReference((String)record.get((Field)TestCaseExportDao.TEST_CASE_NATURE.CODE), (String)record.get((Field)TestCaseExportDao.TEST_CASE_NATURE.LABEL)), (org.squashtest.tm.domain.infolist.InfoListItem)new ListItemReference((String)record.get((Field)TestCaseExportDao.TEST_CASE_TYPE.CODE), (String)record.get((Field)TestCaseExportDao.TEST_CASE_TYPE.LABEL)), TestCaseStatus.valueOf((String)((String)record.get((Field)Tables.TEST_CASE.TC_STATUS))), TestCaseAutomatable.valueOf((String)((String)record.get((Field)Tables.TEST_CASE.AUTOMATABLE))), (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION), (String)record.get((Field)Tables.TEST_CASE.PREREQUISITE), ((Integer)Objects.requireNonNull(record.get("REQ_VERSION_COVERAGE_COUNT"))).longValue(), ((Integer)Objects.requireNonNull(record.get("CALLER_COUNT"))).longValue(), Long.valueOf(Objects.requireNonNull(record.get("ATTACHMENT_COUNT")).toString()), ((Integer)Objects.requireNonNull(record.get("ITERATION_COUNT"))).longValue(), (Date)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON), (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY), (Date)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON), (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY), TestCaseKind.valueOf((String)((String)record.get("KIND"))), (String)record.get((Field)Tables.SCRIPTED_TEST_CASE.SCRIPT), ((Integer)Objects.requireNonNull(record.get("DATASET_COUNT"))).longValue(), ((Integer)Objects.requireNonNull(record.get("MILESTONE_COUNT"))).longValue(), ((Integer)Objects.requireNonNull(record.get("TEST_STEP_COUNT"))).longValue(), ((Integer)Objects.requireNonNull(record.get("PARAMETER_COUNT"))).longValue(), ((Integer)Objects.requireNonNull(record.get("EXECUTION_COUNT"))).longValue(), (Integer)record.get((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_PRIORITY), (Date)record.get((Field)Tables.AUTOMATION_REQUEST.TRANSMITTED_ON), (String)record.get((Field)Tables.AUTOMATION_REQUEST.REQUEST_STATUS), (Long)record.get((Field)Tables.TEST_CASE.TA_TEST), (String)record.get((Field)Tables.AUTOMATED_TEST_TECHNOLOGY.NAME), (Long)record.get((Field)Tables.TEST_CASE.SCM_REPOSITORY_ID), (String)record.get((Field)Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE), (String)record.get("MILESTONE_STATUS"), (String)record.get("MILESTONE_END_DATE"), ((Integer)Objects.requireNonNull(record.get("CALL_STEP_COUNT"))).longValue(), ((Integer)Objects.requireNonNull(record.get("ISSUE_COUNT"))).longValue(), (Boolean)record.get((Field)Tables.TEST_CASE.DRAFTED_BY_AI));
    }

    private List<TestCaseModel> findTestCaseModels(List<Long> tclnIds) {
        ArrayList<TestCaseModel> models = new ArrayList<TestCaseModel>(tclnIds.size());
        List<TestCaseModel> buffer = this.loadTestCaseModelsFromFolderWithJOOQ(tclnIds);
        models.addAll(buffer);
        buffer = this.loadTestCaseModelsFromLibraryWithJOOQ(tclnIds);
        models.addAll(buffer);
        List<ExportModel.CustomField> cufModels = ExportDaoUtils.loadModels(this.em, "testCase.excelExportCUF", tclnIds, TEST_CASE_IDS, ExportModel.CustomField.class);
        for (TestCaseModel model : models) {
            Long id = model.getId();
            ListIterator<ExportModel.CustomField> cufIter = cufModels.listIterator();
            while (cufIter.hasNext()) {
                ExportModel.CustomField cuf = cufIter.next();
                if (!id.equals(cuf.getOwnerId())) continue;
                model.addCuf(cuf);
                cufIter.remove();
            }
        }
        return models;
    }

    private List<TestStepModel> findStepsModel(List<Long> tcIds) {
        ArrayList<TestStepModel> models = new ArrayList<TestStepModel>(tcIds.size());
        List<TestStepModel> buffer = ExportDaoUtils.loadModels(this.em, "testStep.excelExportActionSteps", tcIds, TEST_CASE_IDS, TestStepModel.class);
        models.addAll(buffer);
        buffer = ExportDaoUtils.loadModels(this.em, "testStep.excelExportCallSteps", tcIds, TEST_CASE_IDS, TestStepModel.class);
        models.addAll(buffer);
        List<ExportModel.CustomField> cufModels = ExportDaoUtils.loadModels(this.em, "testStep.excelExportCUF", tcIds, TEST_CASE_IDS, ExportModel.CustomField.class);
        for (TestStepModel model : models) {
            Long id = model.getId();
            ListIterator<ExportModel.CustomField> cufIter = cufModels.listIterator();
            while (cufIter.hasNext()) {
                ExportModel.CustomField cuf = cufIter.next();
                if (!id.equals(cuf.getOwnerId())) continue;
                model.addCuf(cuf);
                cufIter.remove();
            }
        }
        return models;
    }

    private List<ParameterModel> findParametersModel(List<Long> tcIds) {
        return ExportDaoUtils.loadModels(this.em, "parameter.excelExport", tcIds, TEST_CASE_IDS, ParameterModel.class);
    }

    private List<DatasetModel> findDatasetsModel(List<Long> tcIds) {
        return ExportDaoUtils.loadModels(this.em, "dataset.excelExport", tcIds, TEST_CASE_IDS, DatasetModel.class);
    }
}

