/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.testplanretriever;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.internal.testautomation.TaParametersBuilder;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.testautomation.testplanretriever.AllCustomFieldValuesForExec;
import org.squashtest.tm.service.testautomation.testplanretriever.CustomFieldValuesForExec;

@Service
@Transactional
public class AutomatedTestBuilderService<C extends CustomFieldValuesForExec> {
    private final UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    protected Provider<TaParametersBuilder> paramBuilder;
    protected CustomFieldValueFinderService customFieldValueFinder;

    @Inject
    protected AutomatedTestBuilderService(Provider<TaParametersBuilder> paramBuilder, CustomFieldValueFinderService customFieldValueFinder, UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService) {
        this.paramBuilder = paramBuilder;
        this.customFieldValueFinder = customFieldValueFinder;
        this.ultimateLicenseAvailabilityService = ultimateLicenseAvailabilityService;
    }

    public Triple<TestPlanItem, Map<String, Object>, Map<String, Object>> createTestWithParams(TestPlanItem item, C customFieldValuesForExec, Credentials scrCredentials, Long itemExecutionId, String testCasePath) {
        if (this.ultimateLicenseAvailabilityService.isAvailable()) {
            return this.createTestWithParamsUltimate(item, (AllCustomFieldValuesForExec)customFieldValuesForExec, scrCredentials, itemExecutionId, testCasePath);
        }
        return this.createTestWithParamsComunity(item, (CustomFieldValuesForExec)customFieldValuesForExec, scrCredentials, itemExecutionId, testCasePath);
    }

    private Triple<TestPlanItem, Map<String, Object>, Map<String, Object>> createTestWithParamsComunity(TestPlanItem item, CustomFieldValuesForExec customFieldValuesForExec, Credentials scrCredentials, Long itemExecutionId, String testCasePath) {
        TestCase testCase = item.getReferencedTestCase();
        Dataset dataset = item.getReferencedDataset();
        List<CustomFieldValue> tcFields = customFieldValuesForExec.getValueForTestCase(testCase.getId());
        Map<String, Object> params = ((TaParametersBuilder)this.paramBuilder.get()).testCase().addEntity(testCase).addCustomFields(tcFields).dataset().addEntity(dataset).scmRepository().addEntity(testCase.getScmRepository()).scmRepositoryCredentials().addEntity(scrCredentials).build();
        params.put("TC_EXECUTION_ID", itemExecutionId);
        Map<String, Object> metadata = this.buildTestCaseMetadata(testCase, testCasePath);
        return new ImmutableTriple((Object)item, params, metadata);
    }

    private Triple<TestPlanItem, Map<String, Object>, Map<String, Object>> createTestWithParamsUltimate(TestPlanItem item, AllCustomFieldValuesForExec customFieldValuesForExec, Credentials scrCredentials, Long itemExecutionId, String testCasePath) {
        TestCase testCase = item.getReferencedTestCase();
        Dataset dataset = item.getReferencedDataset();
        List<CustomFieldValue> tcFields = customFieldValuesForExec.getValueForTestCase(testCase.getId());
        List<CustomFieldValue> iterFields = customFieldValuesForExec.getValueForIteration(item.getParentIteration().getId());
        List<CustomFieldValue> campFields = customFieldValuesForExec.getValueForCampaign(item.getParentIteration().getCampaign().getId());
        List<CustomFieldValue> testSuiteFields = item.getTestSuites().stream().map(TestSuite::getId).map(customFieldValuesForExec::getValueForTestSuite).flatMap(Collection::stream).toList();
        Map<String, Object> params = ((TaParametersBuilder)this.paramBuilder.get()).testCase().addEntity(testCase).addCustomFields(tcFields).iteration().addCustomFields(iterFields).campaign().addCustomFields(campFields).testSuite().addCustomFields(testSuiteFields).dataset().addEntity(dataset).scmRepository().addEntity(testCase.getScmRepository()).scmRepositoryCredentials().addEntity(scrCredentials).build();
        params.put("TC_EXECUTION_ID", itemExecutionId);
        Map<String, Object> metadata = this.buildTestCaseMetadata(testCase, testCasePath);
        return new ImmutableTriple((Object)item, params, metadata);
    }

    public CustomFieldValuesForExec fetchCustomFieldValues(Collection<TestPlanItem> items) {
        Map<Long, List<CustomFieldValue>> testCaseCfv = this.fetchTestCaseCfv(items);
        if (this.ultimateLicenseAvailabilityService.isAvailable()) {
            Map<Long, List<CustomFieldValue>> iterationCfv = this.fetchIterationCfv(items);
            Map<Long, List<CustomFieldValue>> campaignCfv = this.fetchCampaignCfv(items);
            Map<Long, List<CustomFieldValue>> testSuiteCfv = this.fetchTestSuiteCfv(items);
            return new AllCustomFieldValuesForExec(testCaseCfv, iterationCfv, campaignCfv, testSuiteCfv);
        }
        return new CustomFieldValuesForExec(testCaseCfv);
    }

    protected Map<Long, List<CustomFieldValue>> fetchTestCaseCfv(Collection<TestPlanItem> items) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        for (TestPlanItem item : items) {
            testCases.add(item.getReferencedTestCase());
        }
        return this.customFieldValueFinder.findAllCustomFieldValues(testCases).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchIterationCfv(Collection<TestPlanItem> items) {
        ArrayList<Iteration> iterations = new ArrayList<Iteration>();
        for (TestPlanItem item : items) {
            iterations.add(item.getParentIteration());
        }
        return this.customFieldValueFinder.findAllCustomFieldValues(iterations).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchCampaignCfv(Collection<TestPlanItem> items) {
        ArrayList<Campaign> campaigns = new ArrayList<Campaign>();
        for (TestPlanItem item : items) {
            campaigns.add(item.getParentIteration().getCampaign());
        }
        return this.customFieldValueFinder.findAllCustomFieldValues(campaigns).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchTestSuiteCfv(Collection<TestPlanItem> items) {
        ArrayList testSuites = new ArrayList();
        for (TestPlanItem item : items) {
            testSuites.addAll(item.getTestSuites());
        }
        return this.customFieldValueFinder.findAllCustomFieldValues(testSuites).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    protected Map<String, Object> buildTestCaseMetadata(TestCase testCase, String testCasePath) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", testCase.getName());
        metadata.put("reference", testCase.getAutomatedTestReference());
        metadata.put("uuid", testCase.getUuid());
        metadata.put("nature", testCase.getNature().getCode());
        metadata.put("importance", testCase.getImportance().name());
        metadata.put("type", testCase.getType().getCode());
        metadata.put("technology", testCase.getAutomatedTestTechnology().getName());
        metadata.put("path", this.getPathAsArray(testCasePath));
        return metadata;
    }

    protected Object getPathAsArray(String testCasePath) {
        return new ArrayList<String>(Arrays.asList(testCasePath.split(" > ")));
    }
}

