/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.loaders.common;

import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.FetchPlan;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.HintOption;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.HintOptions;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.JoinOption;

public class FetchPlanBuilder<KEY, TYPE> {
    private HintOptions hintOptions = new HintOptions();
    private Set<TypedQuery<TYPE>> joinOptionQueries = new HashSet<TypedQuery<TYPE>>();
    private Set<KEY> ids;
    private TypedQuery<TYPE> mainQuery;

    public FetchPlanBuilder(Collection<KEY> ids) {
        this.ids = new HashSet<KEY>(Objects.requireNonNull(ids));
    }

    public FetchPlanBuilder<KEY, TYPE> addJoinQuery(Supplier<TypedQuery<TYPE>> querySupplier) {
        this.joinOptionQueries.add(querySupplier.get());
        return this;
    }

    public FetchPlanBuilder<KEY, TYPE> addHint(HintOption hintOption) {
        this.hintOptions.add(hintOption);
        return this;
    }

    public FetchPlanBuilder<KEY, TYPE> addHints(HintOptions hintOptions) {
        this.hintOptions.addAll(hintOptions);
        return this;
    }

    public FetchPlanBuilder<KEY, TYPE> withMainQuery(Supplier<TypedQuery<TYPE>> mainQuerySupplier) {
        this.mainQuery = mainQuerySupplier.get();
        return this;
    }

    public FetchPlan<KEY, TYPE> build() {
        Set joinOptions = this.joinOptionQueries.stream().map(typeTypedQuery -> new JoinOption(this.hintOptions, typeTypedQuery)).collect(Collectors.toSet());
        return new FetchPlan(this.hintOptions, joinOptions, this.mainQuery, this.ids);
    }
}

