/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.QueryAggregationColumn;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.QueryOrderingColumn;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.QueryProfile;
import org.squashtest.tm.service.internal.query.QuerydslToolbox;

class ProjectionPlanner {
    private InternalQueryModel internalQueryModel;
    private ExtendedHibernateQuery<?> query;
    private QuerydslToolbox utils;
    private ColumnAliasing columnAliasing;

    ProjectionPlanner(InternalQueryModel internalQueryModel, ExtendedHibernateQuery<?> query) {
        this.internalQueryModel = internalQueryModel;
        this.query = query;
        this.utils = new QuerydslToolbox();
        this.columnAliasing = new ColumnAliasing(this.utils, this.internalQueryModel);
    }

    ProjectionPlanner(InternalQueryModel definition, ExtendedHibernateQuery<?> query, QuerydslToolbox utils) {
        this.internalQueryModel = definition;
        this.query = query;
        this.utils = utils;
        this.columnAliasing = new ColumnAliasing(this.utils, this.internalQueryModel);
    }

    void modifyQuery() {
        this.addProjections();
        this.addGroupBy();
        this.addSortBy();
    }

    private void addProjections() {
        List<Expression<?>> projections;
        QueryProfile profile = this.internalQueryModel.getQueryProfile();
        if (Objects.requireNonNull(profile) == QueryProfile.SUBWHERE_QUERY) {
            Expression select1 = Expressions.constant((Object)1);
            projections = new ArrayList<Expression>(1);
            projections.add((Expression)select1);
        } else {
            projections = this.columnAliasing.getProjectedColumns().stream().map(AliasedColumn::renderAsAliasedSelect).toList();
        }
        this.query.select((Expression)Projections.tuple(this.toArray(projections))).distinct();
    }

    private void addGroupBy() {
        List<Expression> groupBy = this.columnAliasing.getGroupedColumns().stream().map(AliasedColumn::renderAsAliasElseAsColumn).toList();
        this.query.groupBy(groupBy.toArray(new Expression[0]));
    }

    private void addSortBy() {
        Iterator<AliasedColumn> aliasIterator = this.columnAliasing.getSortedColumns().iterator();
        List<OrderSpecifier> orders = this.internalQueryModel.getOrderingColumns().stream().map(column -> {
            AliasedColumn aliasedColumn = (AliasedColumn)aliasIterator.next();
            Expression<?> expression = aliasedColumn.renderAsAliasElseAsColumn();
            return new OrderSpecifier(column.getOrder(), expression);
        }).toList();
        this.query.orderBy(orders.toArray(new OrderSpecifier[0]));
    }

    private final Expression<?>[] toArray(List<Expression<?>> expressions) {
        return expressions.toArray(new Expression[0]);
    }

    private static final class AliasedColumn {
        private QueryColumnPrototypeInstance columnInstance;
        private String alias;
        private Function<QueryColumnPrototypeInstance, Expression<?>> renderingFunction;

        public AliasedColumn(QueryColumnPrototypeInstance columnInstance, String alias, Function<QueryColumnPrototypeInstance, Expression<?>> renderingFunction) {
            this.columnInstance = columnInstance;
            this.alias = alias;
            this.renderingFunction = renderingFunction;
        }

        public Expression<?> renderAsAliasedSelect() {
            SimpleExpression rendered = this.renderingFunction.apply(this.columnInstance);
            if (this.alias != null) {
                rendered = Expressions.as(rendered, (String)this.alias);
            }
            return rendered;
        }

        public Expression<?> renderAsAliasElseAsColumn() {
            if (this.alias != null) {
                return Expressions.stringPath((String)this.alias);
            }
            return this.renderingFunction.apply(this.columnInstance);
        }
    }

    static final class ColumnAliasing {
        private static final String HIBERNATE_STYLE_ALIAS_TEMPLATE = "col_%d_0_%s";
        private QuerydslToolbox utils;
        private int counter = 0;
        private Map<String, String> aliasByColumnLabel = new HashMap<String, String>();
        private Map<String, String> extraAliasByColumnLabel = new HashMap<String, String>();
        private List<AliasedColumn> projectedColumns;
        private List<AliasedColumn> groupedColumns;
        private List<AliasedColumn> sortedColumns;

        ColumnAliasing(QuerydslToolbox utils, InternalQueryModel queryModel) {
            this.utils = utils;
            this.planProjections(queryModel);
            this.planGroupBy(queryModel);
            this.planSortBy(queryModel);
        }

        private ColumnAliasing() {
        }

        private final void planProjections(InternalQueryModel queryModel) {
            this.projectedColumns = new ArrayList<AliasedColumn>();
            for (QueryProjectionColumn column : queryModel.getProjectionColumns()) {
                String alias = this.registerNewRegularAlias((QueryColumnPrototypeInstance)column);
                AliasedColumn projected = new AliasedColumn((QueryColumnPrototypeInstance)column, alias, this.utils::createAsSelect);
                this.projectedColumns.add(projected);
            }
            List<QueryOrderingColumn> otherLevelEnumColumns = this.findSortByLevelEnum(queryModel);
            for (QueryColumnPrototypeInstance queryColumnPrototypeInstance : otherLevelEnumColumns) {
                String extraAlias = this.registerNewExtraProjectionAlias(queryColumnPrototypeInstance);
                AliasedColumn projected = new AliasedColumn(queryColumnPrototypeInstance, extraAlias, this.utils::createAsCaseWhen);
                this.projectedColumns.add(projected);
            }
        }

        private final void planGroupBy(InternalQueryModel queryModel) {
            this.groupedColumns = new ArrayList<AliasedColumn>();
            for (QueryAggregationColumn column : queryModel.getAggregationColumns()) {
                String alias = this.retrieveRegularAlias((QueryColumnPrototypeInstance)column);
                this.groupedColumns.add(new AliasedColumn((QueryColumnPrototypeInstance)column, alias, this.utils::createAsGroupBy));
                String extraAlias = this.retrieveExtraProjectionAlias((QueryColumnPrototypeInstance)column);
                if (!this.isLevelEnum((QueryColumnPrototypeInstance)column) || extraAlias == null) continue;
                this.groupedColumns.add(new AliasedColumn((QueryColumnPrototypeInstance)column, extraAlias, this.utils::createAsGroupBy));
            }
        }

        private final void planSortBy(InternalQueryModel queryModel) {
            this.sortedColumns = new ArrayList<AliasedColumn>();
            for (QueryOrderingColumn column : queryModel.getOrderingColumns()) {
                String effectiveAlias = null;
                effectiveAlias = this.isLevelEnum((QueryColumnPrototypeInstance)column) ? this.retrieveExtraProjectionAlias((QueryColumnPrototypeInstance)column) : this.retrieveRegularAlias((QueryColumnPrototypeInstance)column);
                this.sortedColumns.add(new AliasedColumn((QueryColumnPrototypeInstance)column, effectiveAlias, this.utils::createAsSortBy));
            }
        }

        private List<QueryOrderingColumn> findSortByLevelEnum(InternalQueryModel queryModel) {
            return queryModel.getOrderingColumns().stream().filter(this::isLevelEnum).toList();
        }

        private boolean isLevelEnum(QueryColumnPrototypeInstance column) {
            return column.getDataType().isAssignableToLevelEnum();
        }

        public List<AliasedColumn> getProjectedColumns() {
            return this.projectedColumns;
        }

        public List<AliasedColumn> getGroupedColumns() {
            return this.groupedColumns;
        }

        public List<AliasedColumn> getSortedColumns() {
            return this.sortedColumns;
        }

        private String registerNewRegularAlias(QueryColumnPrototypeInstance instance) {
            String alias = null;
            String label = instance.getColumn().getLabel();
            if (!this.aliasByColumnLabel.containsKey(label)) {
                alias = this.generate();
                this.aliasByColumnLabel.put(label, alias);
            }
            return alias;
        }

        private String registerNewExtraProjectionAlias(QueryColumnPrototypeInstance instance) {
            String label = instance.getColumn().getLabel();
            String extraAlias = this.generate();
            this.extraAliasByColumnLabel.put(label, extraAlias);
            return extraAlias;
        }

        private String retrieveRegularAlias(QueryColumnPrototypeInstance instance) {
            String label = instance.getColumn().getLabel();
            return this.aliasByColumnLabel.get(label);
        }

        private String retrieveExtraProjectionAlias(QueryColumnPrototypeInstance instance) {
            String label = instance.getColumn().getLabel();
            return this.extraAliasByColumnLabel.get(label);
        }

        private String generate() {
            int cnt = this.counter++;
            String ctxt = this.utils.getSubContext();
            ctxt = ctxt != null ? ctxt : "";
            return String.format(HIBERNATE_STYLE_ALIAS_TEMPLATE, cnt, ctxt);
        }
    }
}

