/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.XrayParsingException;

public class XrayInfoModel {
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    private final Set<String> keys = new HashSet<String>();

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    public void addEntity(Entity entity, String filename) {
        if (Objects.nonNull(entity)) {
            String type = entity.getType();
            if (!this.entities.containsKey(type)) {
                this.entities.put(type, entity);
            } else {
                this.entities.get(type).mergingEntity(entity);
            }
            if (this.keys.contains(entity.getKey())) {
                throw new XrayParsingException(filename, "Duplicate jira keys found in the import.");
            }
            this.keys.add(entity.getKey());
        }
    }

    public static class Entity {
        private String key;
        private String type;
        private int entityCount = 1;
        private final Set<String> status = new HashSet<String>();
        private final Set<String> priorities = new HashSet<String>();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getEntityCount() {
            return this.entityCount;
        }

        public Set<String> getStatus() {
            return this.status;
        }

        public Set<String> getPriorities() {
            return this.priorities;
        }

        public void mergingEntity(Entity entity) {
            this.entityCount += entity.getEntityCount();
            this.status.addAll(entity.getStatus());
            this.priorities.addAll(entity.getPriorities());
        }
    }
}

