/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractJdbcDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

public class JdbcExecutionDeletionHandler
extends AbstractJdbcDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcExecutionDeletionHandler.class);
    private final Set<Long> executionIds;
    private final Condition inExecutionIds;

    public JdbcExecutionDeletionHandler(Collection<Long> executionIds, DSLContext dslContext, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId, EntityManager entityManager) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
        this.executionIds = new HashSet<Long>(executionIds);
        this.inExecutionIds = Tables.EXECUTION.EXECUTION_ID.in(executionIds);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public void deleteExecutions() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.performDeletions();
        this.cleanWorkingTable();
        this.logEndProcess();
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Deleted executions %s. Time elapsed %s", this.inExecutionIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    private void performDeletions() {
        this.deleteDenormalizedCustomFieldValues();
        this.deleteDenormalizedEnvironmentVariables();
        this.deleteDenormalizedEnvironmentTags();
        this.deleteExecutionSteps();
        this.deleteKeywordExecution();
        this.deleteExecutionEntities();
        this.deleteIssueLists();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
    }

    private void deleteDenormalizedCustomFieldValues() {
        this.workingTables.delete(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID);
        this.workingTables.delete(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, Tables.DENORMALIZED_FIELD_VALUE.DFV_ID);
        this.logDelete((Table<?>)Tables.DENORMALIZED_FIELD_VALUE);
    }

    private void deleteDenormalizedEnvironmentVariables() {
        this.workingTables.delete(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID, Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID);
        this.logDelete((Table<?>)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE);
    }

    private void deleteDenormalizedEnvironmentTags() {
        this.workingTables.delete(Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID, Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID);
        this.logDelete((Table<?>)Tables.DENORMALIZED_ENVIRONMENT_TAG);
    }

    private void deleteExecutionSteps() {
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.EXECUTION_STEP_ID);
        this.logDelete((Table<?>)Tables.EXECUTION_STEP);
    }

    private void deleteKeywordExecution() {
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.KEYWORD_EXECUTION.EXECUTION_ID);
        this.logDelete((Table<?>)Tables.KEYWORD_EXECUTION);
    }

    private void deleteExecutionEntities() {
        this.workingTables.delete(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.SCRIPTED_EXECUTION.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.SESSION_NOTE.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION_EVENT.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION.EXECUTION_ID);
        this.logDelete((Table<?>)Tables.EXECUTION);
    }

    private void deleteIssueLists() {
        this.workingTables.delete(Tables.ISSUE_LIST.ISSUE_LIST_ID, Tables.ISSUE.ISSUE_LIST_ID);
        this.workingTables.delete(Tables.ISSUE_LIST.ISSUE_LIST_ID, Tables.ISSUE_LIST.ISSUE_LIST_ID);
        this.logDelete((Table<?>)Tables.ISSUE_LIST);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.addDenormalizedFieldValue();
        this.addDenormalizedEnvironmentVariable();
        this.addDenormalizedEnvironmentTag();
        this.addIssueList();
        this.addExecution();
        this.addExecutionSteps();
        this.addCustomFieldValues();
        this.addAttachmentList();
        this.addAutomatedExecutionFailureDetails();
        this.logReferenceEntitiesComplete();
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.makeSelectAttachmentList(Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION.ATTACHMENT_LIST_ID).union(this.makeSelectAttachmentList(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID)));
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, () -> this.makeSelectCustomFieldValues(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, BindableEntity.EXECUTION_STEP).union(this.makeSelectCustomFieldValues(Tables.EXECUTION.EXECUTION_ID, BindableEntity.EXECUTION)));
    }

    private void addExecutionSteps() {
        this.workingTables.addEntity(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, () -> this.makeSelectClause(Tables.EXECUTION_STEP.EXECUTION_STEP_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).where(this.inExecutionIds));
    }

    private void addExecution() {
        this.workingTables.addEntity(Tables.EXECUTION.EXECUTION_ID, () -> this.makeSelectClause(Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).where(this.inExecutionIds));
    }

    private void addIssueList() {
        this.workingTables.addEntity(Tables.ISSUE_LIST.ISSUE_LIST_ID, () -> this.makeSelectClause(Tables.ISSUE_LIST.ISSUE_LIST_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.ISSUE_LIST).on(Tables.EXECUTION.ISSUE_LIST_ID.eq((Field)Tables.ISSUE_LIST.ISSUE_LIST_ID)).where(this.inExecutionIds).union((Select)this.makeSelectClause(Tables.ISSUE_LIST.ISSUE_LIST_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).innerJoin((TableLike)Tables.ISSUE_LIST).on(Tables.EXECUTION_STEP.ISSUE_LIST_ID.eq((Field)Tables.ISSUE_LIST.ISSUE_LIST_ID)).where(this.inExecutionIds)));
    }

    private void addAutomatedExecutionFailureDetails() {
        this.workingTables.addEntity(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, () -> this.makeSelectClause(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).where(this.inExecutionIds));
    }

    private void addDenormalizedEnvironmentTag() {
        this.workingTables.addEntity(Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID, () -> this.makeSelectClause(Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_TAG).on(Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).where(this.inExecutionIds));
    }

    private void addDenormalizedEnvironmentVariable() {
        this.workingTables.addEntity(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID, () -> this.makeSelectClause(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE).on(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).where(this.inExecutionIds));
    }

    private void addDenormalizedFieldValue() {
        this.workingTables.addEntity(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, () -> this.makeSelectClause(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(this.inExecutionIds.and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)DenormalizedFieldHolderType.EXECUTION.name()))).union((Select)this.makeSelectClause(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).innerJoin((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).where(this.inExecutionIds.and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)DenormalizedFieldHolderType.EXECUTION_STEP.name())))));
    }

    private void logStartProcess() {
        LOGGER.info(String.format("Deleted executions %s. Time elapsed %s", this.executionIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }
}

