/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.PivotSubElementRecordProcessor;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.IterationPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class IterationPivotDaoImpl
extends AbstractPivotDao<IterationPivot>
implements IterationPivotDao {
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public IterationPivotDaoImpl(AdminPivotConverterService adminPivotConverterService, DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasIterationByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueIterationByProjectIdQuery(Long projectId) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.ITERATION);
        return this.dsl.select((SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join(customFieldValuesTable).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(Long projectId) {
        SelectConditionStep iterationQuery = this.dsl.select((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)DSL.val(null, Integer.class).as((Field)Tables.TEST_PLAN_ITEM.ITEM_ORDER), (SelectField)Tables.ITERATION.ITERATION_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.ITERATION.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.ITERATION.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep sessionOverviewQuery = DSL.select((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.TEST_PLAN_ITEM.ITEM_ORDER, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.EXPLORATORY_SESSION_OVERVIEW.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        return iterationQuery.unionAll((Select)sessionOverviewQuery).orderBy((OrderField)Tables.ITERATION.ITERATION_ID, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).fetchSize(50);
    }

    @Override
    public void getIterationByProjectId(Long projectId, Consumer<IterationPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        ResultQuery resultQuery = this.dsl.select(new SelectFieldOrAsterisk[]{Tables.ITERATION.ITERATION_ID, Tables.ITERATION.NAME, Tables.ITERATION.DESCRIPTION, Tables.ITERATION.REFERENCE, Tables.ITERATION.ITERATION_STATUS, Tables.ITERATION.ACTUAL_START_AUTO, Tables.ITERATION.ACTUAL_END_AUTO, Tables.ITERATION.ACTUAL_START_DATE, Tables.ITERATION.ACTUAL_END_DATE, Tables.ITERATION.SCHEDULED_START_DATE, Tables.ITERATION.SCHEDULED_END_DATE, Tables.ITERATION.CREATED_BY, Tables.ITERATION.CREATED_ON, Tables.ITERATION.LAST_MODIFIED_BY, Tables.ITERATION.LAST_MODIFIED_ON, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.LABEL, Tables.TEST_PLAN_ITEM.DATASET_ID, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.TEST_PLAN_ITEM.CREATED_BY, Tables.TEST_PLAN_ITEM.CREATED_ON, Tables.TEST_PLAN_ITEM.LAST_MODIFIED_BY, Tables.TEST_PLAN_ITEM.LAST_MODIFIED_ON, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.NAME, Tables.EXPLORATORY_SESSION_OVERVIEW.REFERENCE, Tables.EXPLORATORY_SESSION_OVERVIEW.CHARTER, Tables.EXPLORATORY_SESSION_OVERVIEW.COMMENTS, Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_STATUS, Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_DURATION, Tables.EXPLORATORY_SESSION_OVERVIEW.DUE_DATE}).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.ITERATION.ITERATION_ID, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).fetchSize(50);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.ITERATION, writingToJsonConsumer, writingAttachmentConsumer);
    }

    @Override
    protected IterationPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        IterationPivot iterationPivot = this.executionWorkspaceConverterService.iterationRecordToIterationPivot(record);
        this.appendTestPlanItemToIterationPivot(iterationPivot, record);
        return iterationPivot;
    }

    private void appendTestPlanItemToIterationPivot(IterationPivot iterationPivot, Record record) {
        if (record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID) != null) {
            iterationPivot.addTestPlanItem(this.executionWorkspaceConverterService.tpiRecordToTpiPivot(record));
        }
    }

    @Override
    protected void fillPivotObject(IterationPivot pivotObject, Record record) {
        this.appendTestPlanItemToIterationPivot(pivotObject, record);
    }

    @Override
    protected List<PivotSubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getCufPivotContainer(projectId), this.getAttachmentPivotContainer(this.getAttachmentByProjectIdQuery(projectId), (Field<Long>)Tables.ITERATION.ITERATION_ID, (Record record) -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, TestCasePivotDao.ATTACHMENT_HOLDER_ID, TestCasePivotDao.ATTACHMENT_HOLDER_TYPE)));
    }

    private PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Long projectId) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(this.getCustomFieldValueIterationByProjectIdQuery(projectId), (Field<Long>)Tables.ITERATION.ITERATION_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot, CustomFieldValuePivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(IterationPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        pivotObject.addAllCustomFields(this.getSubElement(CustomFieldValuePivot.class, subElementsByClazz));
        this.addAndWriteAttachmentPivot(this.getSubElement(AttachmentPivot.class, subElementsByClazz), pivotObject, writingAttachmentConsumer);
    }

    private void addAndWriteAttachmentPivot(List<AttachmentPivot> attachmentPivots, IterationPivot iterationPivot, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        Map sessionOverviewPivotById = iterationPivot.getTestPlanItems().stream().map(TestPlanItemPivot::getSessionOverview).filter(Objects::nonNull).collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, Function.identity()));
        this.addAndWriteAttachmentPivot(attachmentPivots, iterationPivot, AttachmentEntity.ITERATION, Map.of(AttachmentEntity.EXPLORATORY_SESSION_OVERVIEW, sessionOverviewPivotById), writingAttachmentConsumer);
    }
}

