/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.copier.BoundEntityCopy;
import org.squashtest.tm.service.internal.library.LibraryUtils;

public class NodeCopierVisitor
implements NodeVisitor {
    private static final String UNCHECKED = "unchecked";
    private final EntityManager entityManager;
    private final AttachmentManagerService attachmentManagerService;
    private NodeContainer<? extends TreeNode> destination;
    private final String copySuffix;
    private final Map<String, Map<Long, Long>> pairingIdsSourceCopyNode;
    private final List<BoundEntityCopy> boundEntityCopies = new ArrayList<BoundEntityCopy>();
    private final List<BoundEntityCopy> boundEntityCopiesProjectChanged = new ArrayList<BoundEntityCopy>();
    private boolean projectChanged = false;

    public NodeCopierVisitor(EntityManager entityManager, AttachmentManagerService attachmentManagerService, NodeContainer<? extends TreeNode> destination, String copySuffix, Map<String, Map<Long, Long>> pairingIdsSourceCopyNode) {
        this.entityManager = entityManager;
        this.attachmentManagerService = attachmentManagerService;
        this.destination = destination;
        this.copySuffix = copySuffix;
        this.pairingIdsSourceCopyNode = pairingIdsSourceCopyNode;
    }

    public void setDestination(NodeContainer<? extends TreeNode> destination) {
        this.destination = destination;
    }

    public void setProjectChanged(boolean projectChanged) {
        this.projectChanged = projectChanged;
    }

    public List<BoundEntityCopy> getBoundEntityCopies() {
        return this.boundEntityCopies;
    }

    public List<BoundEntityCopy> getBoundEntityCopiesProjectChanged() {
        return this.boundEntityCopiesProjectChanged;
    }

    public void performCopy(TreeNode node) {
        node.accept((NodeVisitor)this);
    }

    public void visit(Campaign source) {
        Campaign copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((Campaign)copy).setDescription(arg_0));
        this.migrateMilestonesIfProjectChanged((MilestoneHolder)copy);
        this.entityManager.persist((Object)copy);
        this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), copy.getId());
    }

    public void visit(Iteration source) {
        Iteration copy = this.copyNode(source, this.destination);
        this.addCustomFieldIteration(source, copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((Iteration)copy).setDescription(arg_0));
        copy.migrateTestPlan(this.destination.getProject().getCampaignLibrary());
        this.entityManager.persist((Object)copy);
    }

    public void visit(TestSuite source) {
        TestSuite copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((TestSuite)copy).setDescription(arg_0));
        this.addTestPlanToTestSuiteCopy((Iteration)this.destination, source, copy);
        this.entityManager.persist((Object)copy);
    }

    private void addTestPlanToTestSuiteCopy(Iteration iteration, TestSuite source, TestSuite copy) {
        List<TestPlanItem> copyOfTestPlan = source.getTestPlanItems().stream().filter(testPlanItem -> !testPlanItem.isTestCaseDeleted()).map(testPlanItem -> testPlanItem.createCopy(iteration.getTestPlan())).toList();
        iteration.getTestPlan().addTransientItems(copyOfTestPlan);
        copy.bindTestPlanItems(copyOfTestPlan, iteration);
    }

    public void visit(Sprint source) {
        Sprint copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((Sprint)copy).setDescription(arg_0));
        if (this.projectChanged) {
            copy.migrateTestPlans();
        }
        this.entityManager.persist((Object)copy);
    }

    public void visit(SprintGroup source) {
        SprintGroup copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((SprintGroup)copy).setDescription(arg_0));
        this.entityManager.persist((Object)copy);
        this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), copy.getId());
    }

    public void visit(Requirement source) {
        throw new UnsupportedOperationException("Copy of Requirement is not supported");
    }

    public void visit(HighLevelRequirement source) {
        throw new UnsupportedOperationException("Copy of HighLevelRequirement is not supported");
    }

    public void visit(TestCase source) {
        throw new UnsupportedOperationException("Copy of TestCase is not supported");
    }

    public <ENTITY extends LibraryNode> void visitFolder(Folder<ENTITY> source) {
        Folder<ENTITY> copy = this.copyNode((ENTITY)source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> copy.setDescription(arg_0));
        this.entityManager.persist(copy);
        this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), copy.getId());
    }

    public void visit(CampaignFolder source) {
        this.visitFolder((Folder)source);
    }

    public void visit(RequirementFolder source) {
        this.visitFolder((Folder)source);
    }

    public void visit(TestCaseFolder source) {
        this.visitFolder((Folder)source);
    }

    private <ENTITY extends TreeNode & Copiable> ENTITY copyNode(ENTITY source, NodeContainer<? extends TreeNode> destination) {
        NodeContainer<? extends TreeNode> container = destination;
        TreeNode copyNode = (TreeNode)((Copiable)source).createCopy();
        this.renameIfNeeded((ENTITY)copyNode, (NodeContainer<ENTITY>)container);
        container.addContentWithoutSet(copyNode);
        return (ENTITY)copyNode;
    }

    protected <ENTITY extends TreeNode & Copiable> void renameIfNeeded(ENTITY copy, NodeContainer<ENTITY> destination) {
        String name = ((Copiable)copy).getName();
        if (destination.isContentNameAvailable(name)) {
            return;
        }
        String newName = LibraryUtils.generateUniqueCopyName(destination.getContentNames(), name, 255, this.copySuffix);
        ((Copiable)copy).setName(newName);
    }

    private void addCustomField(BoundEntity source, BoundEntity copy) {
        if (this.projectChanged) {
            this.boundEntityCopiesProjectChanged.add(new BoundEntityCopy(source.getId(), copy));
        } else {
            this.boundEntityCopies.add(new BoundEntityCopy(source.getId(), copy));
        }
    }

    private void addCustomFieldIteration(Iteration source, Iteration copy) {
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        copy.getTestSuites().forEach(testSuiteCopy -> {
            TestSuite testSuiteSource = source.getTestSuiteByName(testSuiteCopy.getName());
            this.addCustomField((BoundEntity)testSuiteSource, (BoundEntity)testSuiteCopy);
        });
    }

    protected void handleAttachment(AttachmentHolder source, AttachmentHolder copy, String richText, Consumer<String> consumer) {
        this.entityManager.persist((Object)copy.getAttachmentList());
        this.attachmentManagerService.copyContentsOnExternalRepository(copy);
        this.updateRichText(source.getAttachmentList(), copy.getAttachmentList(), richText, consumer);
    }

    private void updateRichText(AttachmentList sourceList, AttachmentList copyList, String richText, Consumer<String> consumer) {
        if (StringUtils.isBlank((CharSequence)richText)) {
            return;
        }
        String updatedDescription = this.attachmentManagerService.handleRichTextAttachments(sourceList, copyList, richText);
        if (!richText.equals(updatedDescription)) {
            consumer.accept(updatedDescription);
        }
    }

    private void migrateMilestonesIfProjectChanged(MilestoneHolder member) {
        if (this.projectChanged) {
            List milestonesProject = this.destination.getProject().getMilestones();
            member.getMilestones().removeIf(m -> !milestonesProject.contains(m));
        }
    }
}

