/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker;

import jakarta.inject.Inject;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueFindContext;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.RemoteProject;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.exception.bugtracker.BadCredentialsException;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.internal.bugtracker.adapter.InternalBugtrackerConnector;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;

@Service(value="squashtest.tm.service.BugTrackersService")
public class BugTrackersServiceImpl
implements BugTrackersService {
    @Inject
    private BugTrackerConnectorFactory bugTrackerConnectorFactory;
    @Inject
    private CredentialsProvider credentialsProvider;

    @Override
    public Credentials getCredentials(BugTracker server) {
        AuthenticationPolicy policy = server.getAuthenticationPolicy();
        Optional<Credentials> maybeCredentials = policy == AuthenticationPolicy.USER ? this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)server) : this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
        if (!maybeCredentials.isPresent()) {
            throw new BadCredentialsException();
        }
        Credentials credentials = maybeCredentials.get();
        return credentials;
    }

    @Override
    public boolean isCredentialsNeeded(BugTracker bugTracker) {
        return bugTracker.getAuthenticationPolicy() != AuthenticationPolicy.APP_LEVEL && !this.credentialsProvider.hasCredentials((ThirdPartyServer)bugTracker);
    }

    @Override
    public BugTrackerInterfaceDescriptor getInterfaceDescriptor(BugTracker bugTracker) {
        InternalBugtrackerConnector connector = this.bugTrackerConnectorFactory.createConnector(bugTracker);
        return connector.getInterfaceDescriptor();
    }

    @Override
    public BugTrackerProviderDescriptor getProviderDescriptor(String kind) {
        return this.bugTrackerConnectorFactory.findDescriptor(kind);
    }

    @Override
    public URL getViewIssueUrl(String issueId, BugTracker bugTracker) {
        return this.connect(bugTracker).makeViewIssueUrl(bugTracker, issueId);
    }

    @Override
    public void testCredentials(BugTracker bugTracker, Credentials credentials) {
        InternalBugtrackerConnector connector = this.bugTrackerConnectorFactory.createConnector(bugTracker);
        if (!connector.supports(credentials.getImplementedProtocol())) {
            throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().toString());
        }
        connector.checkCredentials(credentials);
    }

    public RemoteProject findProjectById(String projectId, BugTracker bugTracker) {
        return this.connect(bugTracker).findProject(projectId);
    }

    private InternalBugtrackerConnector connect(BugTracker bugTracker) {
        InternalBugtrackerConnector connector = this.bugTrackerConnectorFactory.createConnector(bugTracker);
        AuthenticationPolicy authPolicy = bugTracker.getAuthenticationPolicy();
        Supplier<BugTrackerNoCredentialsException> throwIfNull = () -> {
            StringBuilder errorBuilder = new StringBuilder("Cannot authenticate because no valid credentials were found for authentication on the remote server.");
            if (authPolicy == AuthenticationPolicy.APP_LEVEL) {
                errorBuilder.append(" Squash-TM is supposed to use application-level credentials for that and it seems they were not configured properly. Please contact your administrator in order to fix the situation.");
            }
            throw new BugTrackerNoCredentialsException(errorBuilder.toString(), null);
        };
        Optional<Credentials> maybeCredentials = switch (authPolicy) {
            case AuthenticationPolicy.USER -> this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)bugTracker);
            case AuthenticationPolicy.APP_LEVEL -> this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)bugTracker);
            default -> throw new RuntimeException("BugTrackerService#connect : forgot to implement policy " + bugTracker.getAuthenticationPolicy().toString());
        };
        Credentials creds = maybeCredentials.orElseThrow(throwIfNull);
        AuthenticationProtocol protocol = creds.getImplementedProtocol();
        if (!connector.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        connector.authenticate(creds);
        return connector;
    }

    @Override
    public RemoteIssue createIssue(RemoteIssue issue, BugTracker bugTracker) {
        RemoteIssue newissue = this.connect(bugTracker).createIssue(issue);
        newissue.setBugtracker(bugTracker.getName());
        return newissue;
    }

    @Override
    public RemoteIssue createReportIssueTemplate(String projectName, BugTracker bugTracker, RemoteIssueContext context) {
        RemoteIssue issue = this.connect(bugTracker).createReportIssueTemplate(projectName, context);
        issue.setBugtracker(bugTracker.getName());
        return issue;
    }

    @Override
    public RemoteIssue getIssue(String key, BugTracker bugTracker) {
        RemoteIssue issue = this.connect(bugTracker).findIssue(key);
        issue.setBugtracker(bugTracker.getName());
        return issue;
    }

    @Override
    public Future<List<RemoteIssue>> getIssues(Long projectId, Collection<String> issueKeyList, BugTracker bugTracker, UserCredentialsCache credentialsCache, LocaleContext localeContext, SecurityContext secContext) {
        try {
            this.credentialsProvider.restoreCache(credentialsCache);
            LocaleContextHolder.setLocaleContext((LocaleContext)localeContext);
            SecurityContextHolder.setContext((SecurityContext)secContext);
            List<RemoteIssue> issues = this.connect(bugTracker).findKnownIssues(issueKeyList, new RemoteIssueFindContext(projectId));
            String bugtrackerName = bugTracker.getName();
            for (RemoteIssue issue : issues) {
                issue.setBugtracker(bugtrackerName);
            }
            CompletableFuture<List<RemoteIssue>> completableFuture = CompletableFuture.completedFuture(issues);
            return completableFuture;
        }
        finally {
            this.credentialsProvider.unloadCache();
            SecurityContextHolder.clearContext();
        }
    }

    @Override
    public void forwardAttachments(String remoteIssueKey, BugTracker bugtracker, List<Attachment> attachments) {
        this.connect(bugtracker).forwardAttachments(remoteIssueKey, attachments);
    }

    @Override
    public Set<String> getProviderKinds() {
        return this.bugTrackerConnectorFactory.getProviderKinds();
    }

    @Override
    public void linkIssueToRemoteRequirements(String remoteIssueKey, List<RemoteRequirementAndProjectId> remoteReqIds, BugTracker bugtracker) {
        this.connect(bugtracker).linkIssues(bugtracker.getId(), remoteIssueKey, remoteReqIds);
    }

    @Override
    public Object forwardDelegateCommand(DelegateCommand command, BugTracker bugtracker) {
        return this.connect(bugtracker).executeDelegateCommand(command);
    }

    @Override
    public RemoteIssueSearchForm getRemoteIssueSearchForm(BugTracker bugTracker, BugTrackerBindingInfo bugTrackerBindingInfo) {
        return this.connect(bugTracker).createIssueSearchForm(bugTrackerBindingInfo);
    }

    @Override
    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest searchRequest, BugTracker bugTracker) {
        Optional<? extends RemoteIssue> remoteIssue = this.connect(bugTracker).searchIssue(searchRequest);
        return remoteIssue.map(this::withHtmlSanitized);
    }

    private RemoteIssue withHtmlSanitized(RemoteIssue issue) {
        issue.setDescription(HTMLSanitizeUtils.cleanHtml((String)issue.getDescription()));
        issue.setComment(HTMLSanitizeUtils.cleanHtml((String)issue.getComment()));
        if (AdvancedIssue.class.isAssignableFrom(issue.getClass())) {
            AdvancedIssue advancedIssue = (AdvancedIssue)issue;
            advancedIssue.setSummary(HTMLSanitizeUtils.cleanHtml((String)advancedIssue.getSummary()));
            advancedIssue.getFieldValues().forEach((fieldId, value) -> {
                boolean rendersAsHtml;
                Field field = advancedIssue.getProject().getFieldScheme(advancedIssue.getCurrentScheme()).stream().filter(f -> f.getId().equals(fieldId)).findFirst().orElse(null);
                boolean bl = rendersAsHtml = field != null && field.getRendering().getInputType().getConfiguration().containsKey(CommonConfigurationKey.RENDER_AS_HTML.value);
                if (rendersAsHtml) {
                    advancedIssue.setFieldValue(fieldId, this.withHtmlSanitized((FieldValue)value));
                }
            });
        }
        if (BTIssue.class.isAssignableFrom(issue.getClass())) {
            BTIssue btIssue = (BTIssue)issue;
            btIssue.setSummary(HTMLSanitizeUtils.cleanHtml((String)btIssue.getSummary()));
        }
        return issue;
    }

    private FieldValue withHtmlSanitized(FieldValue fieldValue) {
        fieldValue.setScalar(HTMLSanitizeUtils.cleanHtml((String)fieldValue.getScalar()));
        return fieldValue;
    }

    @Override
    public BugTrackerBindingInfo getBugTrackerBindingInfo(GenericProject project) {
        if (!project.isBoundToBugtracker()) {
            return null;
        }
        Long projectId = project.getId();
        Long bugTrackerId = project.getBugTracker().getId();
        List remoteProjectNames = project.getBugtrackerProjectNames();
        return new BugTrackerBindingInfo(projectId, bugTrackerId, remoteProjectNames);
    }
}

