/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;

public class TestCaseNodeWalker
implements TestCaseLibraryNodeVisitor {
    private final List<TestCase> outputList = new LinkedList<TestCase>();
    private final Map<Long, List<Long>> tree;
    private final Map<Long, TestCase> testcases;

    public TestCaseNodeWalker() {
        this.tree = Collections.emptyMap();
        this.testcases = Collections.emptyMap();
    }

    public TestCaseNodeWalker(Map<Long, List<Long>> tree, List<TestCase> testcases) {
        this.tree = tree;
        this.testcases = testcases.stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
    }

    public List<TestCase> sort(Collection<Long> nodes) {
        for (Long source : nodes) {
            this.process(source);
        }
        return this.outputList;
    }

    private void process(Long node) {
        TestCase testCase = this.testcases.get(node);
        if (testCase != null) {
            this.outputList.add(testCase);
            return;
        }
        List children = this.tree.getOrDefault(node, Collections.emptyList());
        for (Long child : children) {
            this.process(child);
        }
    }

    public List<TestCase> walk(List<TestCaseLibraryNode> inputList) {
        for (TestCaseLibraryNode node : inputList) {
            node.accept((TestCaseLibraryNodeVisitor)this);
        }
        return this.outputList;
    }

    public void visit(TestCase testCase) {
        if (!this.outputList.contains(testCase)) {
            this.outputList.add(testCase);
        }
    }

    public void visit(TestCaseFolder testCaseFolder) {
        for (TestCaseLibraryNode node : testCaseFolder.getContent()) {
            node.accept((TestCaseLibraryNodeVisitor)this);
        }
    }
}

