/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.DenormalizedCustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.MultiValuedCustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.internal.dto.resultimport.CustomFieldDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.testautomation.resultimport.CustomFieldImportVerificationService;

@Service
public class CustomFieldImportVerificationServiceImpl
implements CustomFieldImportVerificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldImportVerificationServiceImpl.class);

    @Override
    public RawValue parseCustomFieldDtoValue(CustomFieldDto customFieldDto, Execution execution, CustomFieldValue customFieldValue, PartialErrorDto partialErrors) {
        boolean isValueList;
        Object fieldValue = customFieldDto.getValue();
        boolean isMultiValued = MultiValuedCustomFieldValue.class.isAssignableFrom(customFieldValue.getClass());
        if (isMultiValued != (isValueList = fieldValue instanceof ArrayList)) {
            String errorMessage = isMultiValued ? "Custom field %s in test case %s must have a list of values." : "Custom field %s in test case %s must have a single value, not a list.";
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), errorMessage.formatted(customFieldDto.getCode(), execution.getReferencedTestCase().getAutomatedTestReference()));
            return null;
        }
        return isMultiValued ? new RawValue((List)((ArrayList)fieldValue)) : new RawValue(fieldValue.toString());
    }

    @Override
    public boolean validateCustomFieldImport(Execution execution, CustomField customField, RawValue rawValue, PartialErrorDto partialErrors) {
        return switch (customField.getInputType()) {
            case InputType.DATE_PICKER -> this.validateDateField(rawValue, customField, execution, partialErrors);
            case InputType.CHECKBOX -> this.validateCheckboxField(rawValue, customField, execution, partialErrors);
            case InputType.NUMERIC -> this.validateNumericField(rawValue, customField, execution, partialErrors);
            case InputType.TAG -> this.validateTagField(customField, rawValue, execution, partialErrors);
            case InputType.DROPDOWN_LIST -> this.validateDropdownField(customField, rawValue, execution, partialErrors);
            default -> {
                LOGGER.warn("No specific validation for custom field type {}. Custom field: {}", (Object)customField.getInputType(), (Object)customField.getName());
                yield true;
            }
        };
    }

    private boolean validateDateField(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        try {
            DateUtils.parseIso8601Date((String)rawValue.getValue());
        }
        catch (ParseException parseException) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field %s in test case %s has an invalid date format: %s. Expected format is ISO 8601.".formatted(customField.getName(), execution.getReferencedTestCase().getAutomatedTestReference(), rawValue.getValue()));
            return false;
        }
        return true;
    }

    private boolean validateCheckboxField(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        if (!"true".equals(rawValue.getValue()) && !"false".equals(rawValue.getValue())) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field %s in test case %s must be either true or false.".formatted(customField.getName(), execution.getReferencedTestCase().getAutomatedTestReference()));
            return false;
        }
        return true;
    }

    private boolean validateNumericField(RawValue rawValue, CustomField customField, Execution execution, PartialErrorDto partialErrors) {
        try {
            Double.parseDouble(rawValue.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field %s in test case %s must be a valid number.".formatted(customField.getName(), execution.getReferencedTestCase().getAutomatedTestReference()));
            return false;
        }
        return true;
    }

    private boolean validateTagField(CustomField customField, RawValue rawValue, Execution execution, PartialErrorDto partialErrors) {
        Set allowedValues = ((MultiSelectField)customField).getOptions();
        if (rawValue.getValues() != null && rawValue.getValues().stream().anyMatch(value -> allowedValues.stream().noneMatch(option -> option.getLabel().equals(value)))) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field %s in test case %s has an invalid value: %s. Allowed values are: %s.".formatted(customField.getName(), execution.getReferencedTestCase().getAutomatedTestReference(), rawValue.getValues(), allowedValues.stream().map(DenormalizedCustomFieldOption::getLabel).collect(Collectors.joining(", "))));
            return false;
        }
        return true;
    }

    private boolean validateDropdownField(CustomField customField, RawValue rawValue, Execution execution, PartialErrorDto partialErrors) {
        List allowedValues = ((SingleSelectField)customField).getOptions();
        if (allowedValues.stream().noneMatch(option -> option.getLabel().equals(rawValue.getValue()))) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Custom field %s in test case %s has an invalid value: %s. Allowed values are: %s.".formatted(customField.getName(), execution.getReferencedTestCase().getAutomatedTestReference(), rawValue.getValue(), allowedValues.stream().map(DenormalizedCustomFieldOption::getLabel).collect(Collectors.joining(", "))));
            return false;
        }
        return true;
    }
}

