/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.loaders;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Subgraph;
import jakarta.persistence.TypedQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NestedEntityGraphQueryBuilder<T> {
    private final EntityManager entityManager;
    private final Class<T> entityType;
    private final String baseQuery;
    private final EntityGraph<T> entityGraph;
    private final Map<String, Subgraph<?>> subgraphs = new HashMap();

    public NestedEntityGraphQueryBuilder(EntityManager entityManager, Class<T> entityType, String baseQuery, Map<String, Object> structure) {
        this.entityManager = entityManager;
        this.entityType = entityType;
        this.baseQuery = baseQuery;
        this.entityGraph = entityManager.createEntityGraph(entityType);
        this.processEntityGraph(structure);
    }

    private void processEntityGraph(Map<String, Object> structure) {
        for (Map.Entry<String, Object> entry : structure.entrySet()) {
            String attribute = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                this.entityGraph.addAttributeNodes(new String[]{attribute});
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map subgraphStructure = (Map)value;
            Subgraph subgraph = this.entityGraph.addSubgraph(attribute);
            this.subgraphs.put(attribute, subgraph);
            this.processSubgraph(subgraphStructure, subgraph, attribute);
        }
    }

    private void processSubgraph(Map<String, Object> structure, Subgraph<?> parentGraph, String parentPath) {
        for (Map.Entry<String, Object> entry : structure.entrySet()) {
            String attribute = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                parentGraph.addAttributeNodes(new String[]{attribute});
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map subgraphStructure = (Map)value;
            String newPath = parentPath + "." + attribute;
            Subgraph subgraph = parentGraph.addSubgraph(attribute);
            this.subgraphs.put(newPath, subgraph);
            this.processSubgraph(subgraphStructure, subgraph, newPath);
        }
    }

    public static <T> NestedEntityGraphQueryBuilder<T> of(EntityManager entityManager, Class<T> entityType, String baseQuery, Map<String, Object> structure) {
        return new NestedEntityGraphQueryBuilder<T>(entityManager, entityType, baseQuery, structure);
    }

    public List<T> executeDistinctList() {
        return this.executeDistinctList(null);
    }

    public List<T> executeDistinctList(Map<String, Object> parameters) {
        TypedQuery<T> query = this.buildDistinctQuery(parameters);
        return query.getResultList();
    }

    private TypedQuery<T> buildDistinctQuery(Map<String, Object> parameters) {
        return this.buildQuery(parameters);
    }

    private TypedQuery<T> buildQuery(Map<String, Object> parameters) {
        TypedQuery query = this.entityManager.createQuery(this.baseQuery, this.entityType);
        query.setHint("jakarta.persistence.fetchgraph", this.entityGraph);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((TypedQuery)query).setParameter(arg_0, arg_1));
        }
        return query;
    }

    public static sealed interface GraphDefinition {
        public static Attribute attr(String name) {
            return new Attribute(name);
        }

        public static Subgraph sub(String name, GraphDefinition ... children) {
            return new Subgraph(name, children);
        }

        public String name();

        public static Map<String, Object> graphDefinition(GraphDefinition ... definitions) {
            HashMap<String, Object> rootMap = new HashMap<String, Object>();
            GraphDefinition[] graphDefinitionArray = definitions;
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                GraphDefinition def = graphDefinitionArray[n2];
                def.buildMap(rootMap);
                ++n2;
            }
            return rootMap;
        }

        public void buildMap(Map<String, Object> var1);

        public record Attribute(String name) implements GraphDefinition
        {
            @Override
            public void buildMap(Map<String, Object> parentMap) {
                parentMap.put(this.name, null);
            }
        }

        public record Subgraph(String name, GraphDefinition[] children) implements GraphDefinition
        {
            @Override
            public void buildMap(Map<String, Object> parentMap) {
                HashMap<String, Object> childMap = new HashMap<String, Object>();
                GraphDefinition[] graphDefinitionArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    GraphDefinition child = graphDefinitionArray[n2];
                    child.buildMap(childMap);
                    ++n2;
                }
                parentMap.put(this.name, childMap);
            }
        }
    }
}

