/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record5;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementFolderDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementLibraryDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.requirement.RequirementVersionsGrid;
import org.squashtest.tm.service.internal.repository.display.RequirementDisplayDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Repository
public class RequirementDisplayDaoImpl
implements RequirementDisplayDao {
    private final DSLContext dsl;
    private final ActiveMilestoneHolder activeMilestoneHolder;

    public RequirementDisplayDaoImpl(DSLContext dsl, ActiveMilestoneHolder activeMilestoneHolder) {
        this.dsl = dsl;
        this.activeMilestoneHolder = activeMilestoneHolder;
    }

    @Override
    public RequirementLibraryDto findRequirementLibraryDtoById(long libraryId) {
        return (RequirementLibraryDto)this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY.RL_ID.as("ID"), (SelectField)Tables.REQUIREMENT_LIBRARY.ATTACHMENT_LIST_ID, (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.DESCRIPTION, (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.REQUIREMENT_LIBRARY).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY.RL_ID.eq((Field)Tables.PROJECT.RL_ID)).where(Tables.REQUIREMENT_LIBRARY.RL_ID.eq((Object)libraryId)).fetchOneInto(RequirementLibraryDto.class);
    }

    @Override
    public RequirementFolderDto getRequirementFolderDtoById(long requirementFolderId) {
        return (RequirementFolderDto)((Record5)this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.as("ID"), (SelectField)Tables.RESOURCE.ATTACHMENT_LIST_ID, (SelectField)Tables.RESOURCE.DESCRIPTION, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).innerJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Object)requirementFolderId)).fetchOne()).into(RequirementFolderDto.class);
    }

    @Override
    public List<String> findRequirementVersionNamesByRequirementIds(List<Long> requirementIds) {
        SelectOnConditionStep baseQuery = this.requirementVersionNamesBaseQuery();
        Optional<Milestone> optionalMilestone = this.activeMilestoneHolder.getActiveMilestone();
        Long milestoneId = null;
        if (optionalMilestone.isPresent()) {
            milestoneId = optionalMilestone.get().getId();
            baseQuery = baseQuery.innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID));
        }
        SelectConditionStep conditionStep = baseQuery.where(Tables.REQUIREMENT.RLN_ID.in(requirementIds));
        if (milestoneId != null) {
            conditionStep = conditionStep.and(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Object)milestoneId));
        }
        return conditionStep.fetch().getValues((Field)Tables.RESOURCE.NAME);
    }

    @Override
    public GridResponse findVersionsById(Long requirementId, GridRequest request) {
        return new RequirementVersionsGrid(requirementId).getRows(request, this.dsl);
    }

    private SelectOnConditionStep<Record1<String>> requirementVersionNamesBaseQuery() {
        return this.dsl.select((SelectField)Tables.RESOURCE.NAME).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID));
    }
}

