/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.TestCandidateAnalysis;

public interface TestCandidateAnalysisDao
extends JpaRepository<TestCandidateAnalysis, Long> {
    @Query(value="SELECT p FROM Project p WHERE p.id IN :projectIds")
    public Set<Project> findProjectsByIds(@Param(value="projectIds") List<Long> var1);

    @Query(value="SELECT tca FROM TestCandidateAnalysis tca WHERE tca.createdBy = :createdBy AND tca.createdOn = (SELECT MAX(tca2.createdOn) FROM TestCandidateAnalysis tca2 WHERE tca2.createdBy = :createdBy)")
    public TestCandidateAnalysis findLastByCreatedBy(@Param(value="createdBy") String var1);

    @Modifying
    @Query(value="UPDATE TestCandidateAnalysis tca SET tca.nbOfProcessedTestCases = tca.nbOfProcessedTestCases + :increment WHERE tca.id = :analysisId")
    public void incrementProcessedTestCases(@Param(value="analysisId") Long var1, @Param(value="increment") int var2);
}

