/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportStatus;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportType;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotCreateEntityDuringImportException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotCreateImportFileException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.NoDataImportedException;
import org.squashtest.tm.exception.projectimport.CannotDeleteImportStatusRunningException;
import org.squashtest.tm.exception.projectimport.CannotDeletePivotFileException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.repository.PivotFormatImportDao;
import org.squashtest.tm.service.internal.repository.hibernate.CustomPivotFormatImportDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomFieldPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.FolderPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.GlobalProjectPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.InfoListPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ProjectPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.RequirementPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.TestCasePivotImporterService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
public class GlobalProjectPivotImporterServiceImpl
implements GlobalProjectPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalProjectPivotImporterServiceImpl.class);
    private static final String FILES_DIR = "Files";
    private static final String LOGS_DIR = "Logs";
    private final PivotFileManager pivotFileManager;
    private final PivotFormatImportDao pivotFormatImportDao;
    private final CustomPivotFormatImportDao customPivotFormatImportDao;
    private final GenericProjectManagerService genericProjectManager;
    private final UserAccountService userAccountService;
    private final CustomFieldPivotImporterService customFieldImporterService;
    private final InfoListPivotImporterService infoListImporterService;
    private final FolderPivotImporterService folderImporterService;
    private final RequirementPivotImporterService requirementImporterService;
    private final TestCasePivotImporterService testCaseImporterService;
    private final ExecutionWorkspacePivotImporterService executionWorkspacePivotImporterService;
    private final PlatformTransactionManager transactionManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ConfigurationService configurationService;
    private final Environment environment;
    private final CustomPivotImporterService customPivotImporterService;
    private final AttachmentManagerService attachmentManagerService;
    private final ProjectPivotImporterService projectPivotImporterService;
    @PersistenceContext
    private EntityManager entityManager;

    public GlobalProjectPivotImporterServiceImpl(PivotFileManager pivotFileManager, PivotFormatImportDao pivotFormatImportDao, CustomPivotFormatImportDao customPivotFormatImportDao, GenericProjectManagerService genericProjectManager, UserAccountService userAccountService, CustomFieldPivotImporterService customFieldImporterService, InfoListPivotImporterService infoListImporterService, FolderPivotImporterService folderImporterService, RequirementPivotImporterService requirementImporterService, TestCasePivotImporterService testCaseImporterService, ExecutionWorkspacePivotImporterService executionWorkspacePivotImporterService, PlatformTransactionManager transactionManager, PermissionEvaluationService permissionEvaluationService, ConfigurationService configurationService, Environment environment, CustomPivotImporterService customPivotImporterService, AttachmentManagerService attachmentManagerService, ProjectPivotImporterService projectPivotImporterService) {
        this.pivotFileManager = pivotFileManager;
        this.pivotFormatImportDao = pivotFormatImportDao;
        this.customPivotFormatImportDao = customPivotFormatImportDao;
        this.genericProjectManager = genericProjectManager;
        this.userAccountService = userAccountService;
        this.customFieldImporterService = customFieldImporterService;
        this.infoListImporterService = infoListImporterService;
        this.folderImporterService = folderImporterService;
        this.requirementImporterService = requirementImporterService;
        this.testCaseImporterService = testCaseImporterService;
        this.executionWorkspacePivotImporterService = executionWorkspacePivotImporterService;
        this.transactionManager = transactionManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.configurationService = configurationService;
        this.environment = environment;
        this.customPivotImporterService = customPivotImporterService;
        this.attachmentManagerService = attachmentManagerService;
        this.projectPivotImporterService = projectPivotImporterService;
    }

    @Override
    public void validateImportFilePreconditions(long projectId, MultipartFile multipartFile, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        AtomicReference projectPivot = new AtomicReference();
        ArrayList<InfoListPivot> infoListPivotList = new ArrayList<InfoListPivot>();
        Set<ExecutionStatus> disabledExecutionStatuses = this.getDisabledExecutionStatus(projectId, pivotMetaDataModel);
        List<String> attachmentTypeWhiteList = this.getAttachmentTypeWhiteList();
        Long maxAttachmentSize = this.getMaxAttachmentSize();
        this.pivotFileManager.readPivotFile(multipartFile, (zis, entry) -> {
            if (!entry.getName().endsWith(".json")) {
                this.checkAttachment((ZipEntry)entry, attachmentTypeWhiteList, maxAttachmentSize, pivotMetaDataModel);
                return;
            }
            JsonImportFile jsonImportFile = JsonImportFile.fromFileName(entry.getName());
            switch (jsonImportFile) {
                case INFO_LISTS: {
                    infoListPivotList.addAll(this.infoListImporterService.getInfoListPivotListFromZis(zis));
                    break;
                }
                case EXECUTIONS: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromExecution(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case ITERATIONS: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromIteration(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case TEST_SUITES: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromTestSuite(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case SPRINTS: {
                    this.executionWorkspacePivotImporterService.validateExecutionStatusFromSprint(zis, disabledExecutionStatuses, pivotMetaDataModel);
                    break;
                }
                case PROJECTS: {
                    projectPivot.set(this.projectPivotImporterService.getProjectPivotFromZis(zis));
                    break;
                }
            }
        });
        this.infoListImporterService.validateInfoList(infoListPivotList, (ProjectPivot)projectPivot.get(), projectId, pivotMetaDataModel);
    }

    private Set<ExecutionStatus> getDisabledExecutionStatus(Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        Set<ExecutionStatus> disabledExecutionStatuses = this.genericProjectManager.disabledExecutionStatuses(projectId);
        HashSet<ExecutionStatus> availableStatuses = new HashSet<ExecutionStatus>(Arrays.asList(ExecutionStatus.values()));
        availableStatuses.removeAll(disabledExecutionStatuses);
        availableStatuses.removeAll(ExecutionStatus.TA_STATUSES_ONLY);
        pivotMetaDataModel.addAllAvailableExecutionStatus(availableStatuses);
        return disabledExecutionStatuses;
    }

    private void checkAttachment(ZipEntry zipEntry, List<String> attachmentTypeWhiteList, Long maxAttachmentSize, PivotMetaDataModel pivotMetaDataModel) {
        if (!zipEntry.getName().contains("attachment")) {
            return;
        }
        pivotMetaDataModel.incrementAttachmentCount();
        String attachmentType = FilenameUtils.getExtension((String)zipEntry.getName());
        if (!attachmentTypeWhiteList.contains(attachmentType)) {
            pivotMetaDataModel.addUnauthorizedAttachmentType(attachmentType);
            pivotMetaDataModel.incrementUnauthorizedAttachmentTypesCount();
        }
        if (zipEntry.getSize() > maxAttachmentSize) {
            pivotMetaDataModel.setAttachmentMaxSize(zipEntry.getSize());
            pivotMetaDataModel.incrementAttachmentMaxSizeCount();
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'IMPORT')  or hasRole('ROLE_ADMIN')")
    @Transactional
    public void createImportRequest(long projectId, MultipartFile multipartFile, String importName, PivotFormatImportType importType, PivotMetaDataModel pivotMetaDataModel) {
        User currentUser = this.userAccountService.findCurrentUser();
        String filesFolderPath = this.getFilesFolderPath(importType);
        try {
            this.checkJsonFile(multipartFile);
            File filesFolder = new File(filesFolderPath);
            if (!filesFolder.exists() && !filesFolder.mkdirs()) {
                throw new CouldNotCreateImportFileException();
            }
            this.saveBaseServerUrl(pivotMetaDataModel);
            this.saveLocale(pivotMetaDataModel);
            File importFile = this.createImportFile(multipartFile, pivotMetaDataModel, filesFolder);
            this.savePivotImportRequest(projectId, importName, currentUser, importType, importFile);
        }
        catch (IOException e) {
            LOGGER.error("GlobalProjectPivotImporterService - Failed to create import file \"{}\" in folder path: {}", new Object[]{multipartFile.getOriginalFilename(), filesFolderPath, e});
            throw new CouldNotCreateImportFileException();
        }
    }

    private void checkJsonFile(MultipartFile multipartFile) throws IOException {
        this.pivotFileManager.readPivotFile(multipartFile, (zis, entry) -> {
            if (!entry.getName().endsWith(".json")) {
                return;
            }
            this.pivotFileManager.checkJsonFileName(entry.getName());
            this.pivotFileManager.checkJsonSyntaxError((ZipEntry)entry, (ZipInputStream)zis);
        });
    }

    private String generateImportFileName(MultipartFile multipartFile) {
        String originalFilename = multipartFile.getOriginalFilename();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSS");
        String timestamp = LocalDateTime.now().format(formatter);
        return String.format("%s-%s.%s", FilenameUtils.getBaseName((String)originalFilename), timestamp, FilenameUtils.getExtension((String)originalFilename));
    }

    private void saveBaseServerUrl(PivotMetaDataModel pivotMetaDataModel) {
        pivotMetaDataModel.setBaseUrl(this.attachmentManagerService.getBaseFileUploadUrl());
    }

    private void saveLocale(PivotMetaDataModel pivotMetaDataModel) {
        Locale locale = LocaleContextHolder.getLocale();
        pivotMetaDataModel.setLocale(locale);
    }

    private File createImportFile(MultipartFile multipartFile, PivotMetaDataModel pivotMetaDataModel, File filesFolder) throws IOException {
        String importFileName = this.generateImportFileName(multipartFile);
        File importFile = new File(filesFolder, importFileName);
        this.pivotFileManager.copyPivotFileToImport(multipartFile, importFile, pivotMetaDataModel);
        return importFile;
    }

    private String getPivotFormatImportFolderPath() {
        String pivotFormatImportFolderPath = this.environment.getProperty("squash.project-imports.folder-path");
        if (Objects.isNull(pivotFormatImportFolderPath)) {
            LOGGER.error("The property \"squash.project-imports.folder-path\" is not set", new Object[0]);
            throw new CouldNotCreateImportFileException();
        }
        return pivotFormatImportFolderPath;
    }

    private String getFilesFolderPath(PivotFormatImportType importType) {
        Path filesFolderPath = Paths.get(this.getPivotFormatImportFolderPath(), this.getFolderForImportType(importType), FILES_DIR);
        return filesFolderPath.toString();
    }

    private String getFolderForImportType(PivotFormatImportType importType) {
        return StringUtils.capitalize((String)importType.name().toLowerCase());
    }

    private void savePivotImportRequest(long projectId, String importName, User currentUser, PivotFormatImportType importType, File importFile) {
        GenericProject project = this.genericProjectManager.findById(projectId);
        PivotFormatImport pivotFormatImport = new PivotFormatImport();
        pivotFormatImport.setName(importName);
        pivotFormatImport.setCreatedBy(currentUser);
        pivotFormatImport.setCreatedOn(new Date());
        pivotFormatImport.setType(importType);
        pivotFormatImport.setFilePath(importFile.getPath());
        pivotFormatImport.setProject((Project)project);
        this.pivotFormatImportDao.save(pivotFormatImport);
    }

    @Override
    @Transactional
    public void deleteImportRequests(long projectId, List<Long> idImportRequests) {
        this.checkCanImportPermission(projectId);
        if (idImportRequests.isEmpty()) {
            return;
        }
        List pivotFormatImports = this.pivotFormatImportDao.findAllById(idImportRequests);
        for (PivotFormatImport pivotFormatImport : pivotFormatImports) {
            if (pivotFormatImport.getStatus() == PivotFormatImportStatus.RUNNING) {
                throw new CannotDeleteImportStatusRunningException(String.format("Cannot delete the import \"%s\" #%s because it is running", pivotFormatImport.getName(), pivotFormatImport.getId()), pivotFormatImport.getName());
            }
            this.pivotFormatImportDao.delete(pivotFormatImport);
            this.clearImportFiles(pivotFormatImport);
        }
    }

    private void clearImportFiles(PivotFormatImport pivotFormatImport) {
        File folderFile = new File(this.getPivotFormatImportFolderPath());
        File importFile = new File(pivotFormatImport.getFilePath());
        File importLogFile = new File(this.getImportErrorLogFilePath(pivotFormatImport.getId(), pivotFormatImport.getType()));
        this.checkAndDeleteImportFile(folderFile, importFile, pivotFormatImport);
        this.checkAndDeleteImportFile(folderFile, importLogFile, pivotFormatImport);
    }

    private void checkAndDeleteImportFile(File folderFile, File importFile, PivotFormatImport pivotFormatImport) {
        if (importFile.exists()) {
            this.checkImportFilePath(folderFile, importFile, pivotFormatImport.getName());
            try {
                FileUtils.forceDelete((File)importFile);
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to delete import file \"{}\" in folder path: {}", new Object[]{importFile.getName(), importFile.getPath(), ioException});
                throw new CannotDeletePivotFileException(pivotFormatImport.getName());
            }
        }
    }

    private void checkImportFilePath(File folderFile, File importFile, String importName) {
        if (Objects.isNull(folderFile) || !importFile.toPath().startsWith(folderFile.toPath())) {
            LOGGER.error("Import file is not in the \"Files\" folder directory", new Object[0]);
            throw new CannotDeletePivotFileException(importName);
        }
    }

    @Override
    public void importProject(PivotFormatImport pivotFormatImport) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        PivotFormatImportStatus finalStatus = PivotFormatImportStatus.FAILURE;
        try {
            try {
                this.logImportStarted(pivotFormatImport, false);
                Project project = new Project();
                File importFile = new File(pivotFormatImport.getFilePath());
                Throwable throwable = null;
                Object var8_10 = null;
                try (ZipFile zipFile = new ZipFile(importFile);){
                    this.importProjectInfoFromZipArchive((GenericProject)project, zipFile, pivotFormatImport);
                    ProjectIdsReferences projectIdsReferences = new ProjectIdsReferences((GenericProject)project);
                    finalStatus = this.importEntitiesInProject(zipFile, projectIdsReferences, pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                this.handleError(pivotFormatImport, transaction, e);
                this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
            }
        }
        finally {
            this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
        }
    }

    @Override
    public void importInExistingProject(PivotFormatImport pivotFormatImport) {
        Project existingProject = pivotFormatImport.getProject();
        this.checkCanImportPermission(existingProject.getId());
        PivotFormatImportStatus finalStatus = PivotFormatImportStatus.FAILURE;
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            try {
                this.logImportStarted(pivotFormatImport, true);
                ProjectIdsReferences projectIdsReferences = new ProjectIdsReferences((GenericProject)existingProject);
                File importFile = new File(pivotFormatImport.getFilePath());
                Throwable throwable = null;
                Object var9_11 = null;
                try (ZipFile zipFile = new ZipFile(importFile);){
                    finalStatus = this.importEntitiesInProject(zipFile, projectIdsReferences, pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                this.handleError(pivotFormatImport, transaction, e);
                this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
            }
        }
        finally {
            this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
        }
    }

    private void saveFinalImportStatus(Long importId, PivotFormatImportStatus finalStatus) {
        this.doInTransaction(() -> {
            LOGGER.info("GlobalProjectPivotImporterService - The import with id: {} has ended with status: {}", new Object[]{importId, finalStatus});
            this.customPivotFormatImportDao.updatePivotFormatImportStatus(importId, finalStatus);
            if (PivotFormatImportStatus.SUCCESS.equals((Object)finalStatus) || PivotFormatImportStatus.WARNING.equals((Object)finalStatus)) {
                this.customPivotFormatImportDao.updatePivotFormatImportSuccessfullyImportedOn(importId, new Date());
            }
        });
    }

    private void logImportStarted(PivotFormatImport pivotFormatImport, boolean importInExistingProject) {
        this.doInTransaction(() -> {
            if (importInExistingProject) {
                LOGGER.info("GlobalProjectPivotImporterService - Starting new import with id: {} for project: {}. Project id: {}", new Object[]{pivotFormatImport.getId(), pivotFormatImport.getProject().getName(), pivotFormatImport.getProject().getId()});
            } else {
                LOGGER.info("GlobalProjectPivotImporterService - Starting new import with id: {}. This import will create a new project.", new Object[]{pivotFormatImport.getId()});
            }
            this.customPivotFormatImportDao.updatePivotFormatImportStatus(pivotFormatImport.getId(), PivotFormatImportStatus.RUNNING);
        });
    }

    private void handleError(PivotFormatImport pivotFormatImport, TransactionStatus transaction, Throwable e) {
        this.transactionManager.rollback(transaction);
        String message = String.format(" Import id: %s - Failed to import data in existing project \"%s\" with id %s.", pivotFormatImport.getId(), pivotFormatImport.getProject().getName(), pivotFormatImport.getProject().getId());
        this.createErrorLogFile(pivotFormatImport, e);
        LOGGER.error(message, e);
    }

    private void createErrorLogFile(PivotFormatImport pivotFormatImport, Throwable ex) {
        File logFolder = new File(this.getLogsFolderPath(pivotFormatImport.getType()));
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getImportErrorLogFilePath(pivotFormatImport.getId(), pivotFormatImport.getType());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(logFilePath);){
                ex.printStackTrace(pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not generate error log file for import: %s", pivotFormatImport.getId()), (Throwable)e);
        }
    }

    @Override
    public String getImportErrorLogFilePath(Long importId, PivotFormatImportType importType) {
        return String.format("%s/import-%s-error.log", this.getLogsFolderPath(importType), importId);
    }

    @Override
    public String getImportWarningLogFilePath(Long importId, PivotFormatImportType importType) {
        return String.format("%s/import-%s-warning.log", this.getLogsFolderPath(importType), importId);
    }

    private String getLogsFolderPath(PivotFormatImportType importType) {
        Path logsFolderPath = Paths.get(this.getPivotFormatImportFolderPath(), this.getFolderForImportType(importType), LOGS_DIR);
        return logsFolderPath.toString();
    }

    private PivotFormatImportStatus importEntitiesInProject(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) throws IOException {
        boolean importHasWarnings;
        HibernateConfig.enableBatch(this.entityManager, 50);
        PivotImportMetadata pivotImportMetadata = new PivotImportMetadata();
        pivotImportMetadata.setPivotMetaDataModel(this.customPivotImporterService.getPivotMetadataFromPivot(zipFile));
        pivotImportMetadata.setAttachmentTypeWhiteList(this.getAttachmentTypeWhiteList());
        pivotImportMetadata.setMaxAttachmentSize(this.getMaxAttachmentSize());
        this.customFieldImporterService.importCustomFieldsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        if (pivotImportMetadata.getPivotOptions().isImportInfoList()) {
            this.infoListImporterService.importInfoListsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        }
        this.projectPivotImporterService.importProjectInformationFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.REQUIREMENT_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.requirementImporterService.importRequirementsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.TEST_CASE_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.testCaseImporterService.importTestCasesFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.testCaseImporterService.importCalledTestCasesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.CAMPAIGN_FOLDERS_AND_SPRINT_GROUPS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importCampaignsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importIterationsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importTestSuitesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importSprintsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importExecutionsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        zipFile.close();
        this.checkIfImportHasImportedAtLeastOneEntity(pivotFormatImport, pivotImportMetadata);
        boolean bl = importHasWarnings = !pivotImportMetadata.getImportWarningEntries().isEmpty();
        if (importHasWarnings) {
            this.createWarningLogFile(pivotImportMetadata.getImportWarningEntries(), pivotFormatImport);
        }
        return importHasWarnings ? PivotFormatImportStatus.WARNING : PivotFormatImportStatus.SUCCESS;
    }

    private void createWarningLogFile(List<ImportWarningEntry> importWarningEntries, PivotFormatImport pivotFormatImport) throws IOException {
        File logFolder = new File(this.getLogsFolderPath(pivotFormatImport.getType()));
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getImportWarningLogFilePath(pivotFormatImport.getId(), pivotFormatImport.getType());
        GlobalProjectPivotImporterServiceImpl.writeWarningLogToFile(importWarningEntries, logFilePath);
    }

    private static void writeWarningLogToFile(List<ImportWarningEntry> entries, String filePath) throws IOException {
        Set types = entries.stream().map(ImportWarningEntry::entityType).collect(Collectors.toSet());
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            for (EntityType type : types) {
                writer.write(type.name());
                writer.newLine();
                List<ImportWarningEntry> filteredEntries = entries.stream().filter(e -> e.entityType().equals((Object)type)).toList();
                for (ImportWarningEntry entry : filteredEntries) {
                    writer.write(entry.message());
                    writer.newLine();
                }
                writer.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<String> getAttachmentTypeWhiteList() {
        String whiteListStr = this.configurationService.findConfiguration("uploadfilter.fileExtensions.whitelist");
        return Arrays.stream(whiteListStr.split(",")).map(String::trim).toList();
    }

    private Long getMaxAttachmentSize() {
        String maxAttachmentSizeLimitStr = this.configurationService.findConfiguration("uploadfilter.upload.sizeLimitInBytes");
        return Long.valueOf(maxAttachmentSizeLimitStr);
    }

    private void checkIfImportHasImportedAtLeastOneEntity(PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        if (!pivotImportMetadata.isAtLeastOneEntity()) {
            String message = String.format("Import Id: %s - No data has been imported. Please check the import file and try again.", pivotFormatImport.getId());
            LOGGER.error(message, new Object[0]);
            throw new NoDataImportedException(message);
        }
    }

    private void importProjectInfoFromZipArchive(GenericProject project, ZipFile zipFile, PivotFormatImport pivotFormatImport) throws IOException {
        LOGGER.info("Import Id: {} -  Starting to create new project from zip archive \"{}\"", new Object[]{pivotFormatImport.getId(), zipFile.getName()});
        ZipEntry entry = zipFile.getEntry(JsonImportFile.PROJECTS.getFileName());
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
            this.handleProject(jsonInputStream, project, pivotFormatImport);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void handleProject(InputStream jsonInputStream, GenericProject project, PivotFormatImport pivotFormatImport) {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
                while (jsonParser.nextToken() != null) {
                    if (!"project".equals(jsonParser.currentName())) continue;
                    project = this.parseAndCreateProject(jsonParser, project);
                    LOGGER.info("Import Id: {} - New project \"{}\" created successfully with id {}", new Object[]{pivotFormatImport.getId(), project.getName(), project.getId()});
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String message = String.format("Import id: %s - Could not create new project named \"%s\"", pivotFormatImport.getId(), project.getName());
            LOGGER.error(message, new Object[0]);
            throw new CouldNotCreateEntityDuringImportException(message, (Throwable)e);
        }
    }

    private GenericProject parseAndCreateProject(JsonParser jsonParser, GenericProject project) throws IOException {
        jsonParser.nextToken();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.currentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "name": {
                    project.setName(jsonParser.getText());
                    break;
                }
                case "description": {
                    project.setDescription(jsonParser.getText());
                    break;
                }
                case "label": {
                    project.setLabel(jsonParser.getText());
                    break;
                }
            }
        }
        return this.genericProjectManager.persist(project);
    }

    private void doInTransaction(Runnable runnable) {
        TransactionStatus transaction = null;
        try {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(3);
            transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            runnable.run();
            this.entityManager.flush();
            this.entityManager.clear();
            this.transactionManager.commit(transaction);
        }
        catch (Exception ex) {
            if (transaction != null) {
                this.transactionManager.rollback(transaction);
            }
            throw ex;
        }
    }

    private void checkCanImportPermission(long projectId) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.IMPORT.name(), Project.class.getName());
    }
}

