/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record11;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ProjectPivot;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.ProjectPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class ProjectPivotDaoImpl
implements ProjectPivotDao {
    private final DSLContext dsl;
    private final AdminPivotConverterService adminPivotConverterService;

    public ProjectPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        this.dsl = dsl;
        this.adminPivotConverterService = adminPivotConverterService;
    }

    private ResultQuery<? extends Record> getProjectQuery(Long projectId) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.PROJECT_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.LABEL, (SelectField)Tables.PROJECT.DESCRIPTION, (SelectField)Tables.PROJECT.CREATED_BY, (SelectField)Tables.PROJECT.CREATED_ON, (SelectField)Tables.PROJECT.LAST_MODIFIED_BY, (SelectField)Tables.PROJECT.LAST_MODIFIED_ON, (SelectField)Tables.PROJECT.REQ_CATEGORIES_LIST, (SelectField)Tables.PROJECT.TC_NATURES_LIST, (SelectField)Tables.PROJECT.TC_TYPES_LIST, (SelectField)Tables.PROJECT.RL_ID, (SelectField)Tables.PROJECT.TCL_ID, (SelectField)Tables.PROJECT.CL_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.CFB_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentQuery(Long projectId) {
        SelectConditionStep projectQuery = this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.PROJECT_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.PROJECT.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.PROJECT).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.PROJECT.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId));
        return this.dsl.selectFrom((TableLike)projectQuery).unionAll(this.getReqLibraryAttachmentQuery(projectId)).unionAll(this.getTcLibraryAttachmentQuery(projectId)).unionAll(this.getCampaignLibraryAttachmentQuery(projectId)).orderBy((OrderField)Tables.PROJECT.PROJECT_ID).fetchSize(50);
    }

    private SelectConditionStep<Record11<Long, Long, String, Long, Long, String, String, Timestamp, Timestamp, Long, byte[]>> getLibraryAttachmentQuery(Long projectId, Field<Long> projectLibraryIdField, Table<?> libraryTable, Field<Long> libraryIdField, Field<Long> attachmentListIdField, AttachmentEntity attachmentEntityType) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)libraryIdField.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)attachmentEntityType.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.PROJECT).join(libraryTable).on(libraryIdField.eq(projectLibraryIdField)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq(attachmentListIdField)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId));
    }

    private SelectConditionStep<Record11<Long, Long, String, Long, Long, String, String, Timestamp, Timestamp, Long, byte[]>> getReqLibraryAttachmentQuery(Long projectId) {
        return this.getLibraryAttachmentQuery(projectId, (Field<Long>)Tables.PROJECT.RL_ID, (Table<?>)Tables.REQUIREMENT_LIBRARY, (Field<Long>)Tables.REQUIREMENT_LIBRARY.RL_ID, (Field<Long>)Tables.REQUIREMENT_LIBRARY.ATTACHMENT_LIST_ID, AttachmentEntity.REQUIREMENT_LIBRARY);
    }

    private SelectConditionStep<Record11<Long, Long, String, Long, Long, String, String, Timestamp, Timestamp, Long, byte[]>> getTcLibraryAttachmentQuery(Long projectId) {
        return this.getLibraryAttachmentQuery(projectId, (Field<Long>)Tables.PROJECT.TCL_ID, (Table<?>)Tables.TEST_CASE_LIBRARY, (Field<Long>)Tables.TEST_CASE_LIBRARY.TCL_ID, (Field<Long>)Tables.TEST_CASE_LIBRARY.ATTACHMENT_LIST_ID, AttachmentEntity.TEST_CASE_LIBRARY);
    }

    private SelectConditionStep<Record11<Long, Long, String, Long, Long, String, String, Timestamp, Timestamp, Long, byte[]>> getCampaignLibraryAttachmentQuery(Long projectId) {
        return this.getLibraryAttachmentQuery(projectId, (Field<Long>)Tables.PROJECT.CL_ID, (Table<?>)Tables.CAMPAIGN_LIBRARY, (Field<Long>)Tables.CAMPAIGN_LIBRARY.CL_ID, (Field<Long>)Tables.CAMPAIGN_LIBRARY.ATTACHMENT_LIST_ID, AttachmentEntity.CAMPAIGN_LIBRARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectPivot getProjectByProjectId(Long projectId) {
        Throwable throwable = null;
        Object var4_4 = null;
        try (Stream stream = this.getProjectQuery(projectId).stream();){
            Iterator iterator = stream.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Record record = (Record)iterator.next();
            ProjectPivot projectPivot = this.adminPivotConverterService.recordToProjectPivot(record);
            this.appendCustomFieldBindings(record, projectPivot);
            iterator.forEachRemaining(r -> this.appendCustomFieldBindings((Record)r, projectPivot));
            this.appendAttachments(projectPivot, projectId);
            return projectPivot;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private void appendAttachments(ProjectPivot projectPivot, Long projectId) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = this.getAttachmentQuery(projectId).stream();){
            stream.forEach(record -> {
                AttachmentPivot attachmentPivot = this.adminPivotConverterService.recordToAttachmentPivot((Record)record, TestCasePivotDao.ATTACHMENT_HOLDER_ID, TestCasePivotDao.ATTACHMENT_HOLDER_TYPE);
                if (Objects.nonNull(attachmentPivot.getContent())) {
                    this.appendAttachments(projectPivot, attachmentPivot);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendAttachments(ProjectPivot projectPivot, AttachmentPivot attachmentPivot) {
        switch (attachmentPivot.getAttachmentEntity()) {
            case PROJECT: {
                projectPivot.addAttachment(attachmentPivot);
                break;
            }
            case REQUIREMENT_LIBRARY: {
                projectPivot.getRequirementLibrary().addAttachment(attachmentPivot);
                break;
            }
            case TEST_CASE_LIBRARY: {
                projectPivot.getTestCaseLibrary().addAttachment(attachmentPivot);
                break;
            }
            case CAMPAIGN_LIBRARY: {
                projectPivot.getCampaignLibrary().addAttachment(attachmentPivot);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected attachment entity type: " + String.valueOf(attachmentPivot.getAttachmentEntity()));
            }
        }
    }

    private void appendCustomFieldBindings(Record record, ProjectPivot projectPivot) {
        if (record.get((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID) != null) {
            this.adminPivotConverterService.appendCustomFieldBinding(record, projectPivot);
        }
    }
}

