/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.CalledTestCasesPivot;
import org.squashtest.tm.service.pivot.converters.TestCasePivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CalledTestCasePivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class CalledTestCasePivotDaoImpl
implements CalledTestCasePivotDao {
    private final DSLContext dsl;
    private final TestCasePivotDao testCasePivotDao;
    private final TestCasePivotConverterService testCasePivotConverterService;

    public CalledTestCasePivotDaoImpl(DSLContext dsl, TestCasePivotDao testCasePivotDao, TestCasePivotConverterService testCasePivotConverterService) {
        this.dsl = dsl;
        this.testCasePivotDao = testCasePivotDao;
        this.testCasePivotConverterService = testCasePivotConverterService;
    }

    @Override
    public boolean hasCalledTestCase(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    @Override
    public void getCalledTestCaseByProjectId(Long projectId, Consumer<CalledTestCasesPivot> consumer) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithCalledByProjectId = this.testCasePivotDao.getCteTestCaseWithNonProjectTcByProjectId(projectId);
        ResultQuery resultQuery = this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithCalledByProjectId}).select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES, (SelectField)Tables.CALL_TEST_STEP.CALLED_DATASET).from(cteTestCaseWithCalledByProjectId).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (OrderField)Tables.TEST_CASE_STEPS.STEP_ORDER).fetchSize(50);
        this.consumeCalledTestCase(resultQuery, consumer);
    }

    private <T extends Record> void consumeCalledTestCase(ResultQuery<T> resultQuery, Consumer<CalledTestCasesPivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                CalledTestCasesPivot calledTestCasesPivot = this.testCasePivotConverterService.calledTestCaseRecordToCalledTestCasePivot(record);
                writingToJsonConsumer.accept(calledTestCasesPivot);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

