/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.util.Date;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot;
import org.squashtest.tm.service.internal.pivot.converters.FolderPivotConverterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.pivot.converters.FolderPivotConverterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.pivot.converters.FolderPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.FolderPivotDao;

@Service
public class FolderPivotConverterServiceImpl
implements FolderPivotConverterService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Override
    public <NODE extends LibraryNode, FOLDER extends Folder<NODE> & AuditableMixin> FOLDER pivotToFolder(FolderPivot folderPivot) {
        Folder<?> folder = this.createFolder(folderPivot.getKind());
        folder.setName(folderPivot.getName());
        FolderPivot folderPivot2 = folderPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)folderPivot2);
        Object[] objectArray = new Object[]{this, folderPivot2, joinPoint};
        FolderPivotConverterServiceImpl$AjcClosure1 folderPivotConverterServiceImpl$AjcClosure1 = new FolderPivotConverterServiceImpl$AjcClosure1(objectArray);
        folder.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(folderPivotConverterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        ((AuditableMixin)folder).setCreatedBy(folderPivot.getCreatedBy());
        ((AuditableMixin)folder).setCreatedOn(folderPivot.getCreatedOn());
        return (FOLDER)folder;
    }

    @Override
    public SprintGroup pivotToSprintGroup(FolderPivot folderPivot) {
        SprintGroup sprintGroup = new SprintGroup();
        sprintGroup.setName(folderPivot.getName());
        FolderPivot folderPivot2 = folderPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)folderPivot2);
        Object[] objectArray = new Object[]{this, folderPivot2, joinPoint};
        FolderPivotConverterServiceImpl$AjcClosure3 folderPivotConverterServiceImpl$AjcClosure3 = new FolderPivotConverterServiceImpl$AjcClosure3(objectArray);
        sprintGroup.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(folderPivotConverterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        sprintGroup.setCreatedBy(folderPivot.getCreatedBy());
        sprintGroup.setCreatedOn(folderPivot.getCreatedOn());
        return sprintGroup;
    }

    private Folder<?> createFolder(EntityType entityType) {
        return switch (entityType) {
            case EntityType.CAMPAIGN_FOLDER -> new CampaignFolder();
            case EntityType.REQUIREMENT_FOLDER -> new RequirementFolder();
            case EntityType.TEST_CASE_FOLDER -> new TestCaseFolder();
            default -> throw new IllegalArgumentException(String.format("%s is not a valid folder type", entityType));
        };
    }

    @Override
    public FolderPivot generateMainFolderNonProjectEntity(EntityType kind, EntityType parentType) {
        FolderPivot folderPivot = new FolderPivot();
        folderPivot.setPivotId("EXT_IMP");
        folderPivot.setName(".EXTERNAL_IMPORTED");
        folderPivot.setKind(kind);
        folderPivot.setParentType(parentType);
        return folderPivot;
    }

    @Override
    public FolderPivot generatedFolderRecordToFolderPivot(Record record, Field<Long> projectIdField, EntityType kind) {
        FolderPivot folderPivot = new FolderPivot();
        folderPivot.setPivotIdGenerated((Long)record.get(projectIdField));
        folderPivot.setName((String)record.get((Field)Tables.PROJECT.NAME));
        folderPivot.setKind(kind);
        folderPivot.setParentType(kind);
        folderPivot.setParentId("EXT_IMP");
        return folderPivot;
    }

    @Override
    public FolderPivot folderRecordToFolderPivot(Record record, EntityType entityType) {
        return switch (entityType) {
            case EntityType.REQUIREMENT_FOLDER -> this.requirementRecordToFolderPivot(record);
            case EntityType.TEST_CASE_FOLDER -> this.testCaseRecordToFolderPivot(record);
            case EntityType.CAMPAIGN_FOLDER -> this.campaignRecordToFolderPivot(record);
            default -> throw new IllegalArgumentException("Unsupported entity type: " + String.valueOf(entityType));
        };
    }

    private FolderPivot requirementRecordToFolderPivot(Record record) {
        FolderPivot folderPivot = new FolderPivot();
        folderPivot.setPivotId((Long)record.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID));
        folderPivot.setName((String)record.get((Field)Tables.RESOURCE.NAME));
        folderPivot.setKind(EntityType.REQUIREMENT_FOLDER);
        folderPivot.setDescription((String)record.get((Field)Tables.RESOURCE.DESCRIPTION));
        folderPivot.setCreatedBy((String)record.get((Field)Tables.RESOURCE.CREATED_BY));
        folderPivot.setCreatedOn((Date)record.get((Field)Tables.RESOURCE.CREATED_ON));
        folderPivot.setLastModifiedBy((String)record.get((Field)Tables.RESOURCE.LAST_MODIFIED_BY));
        folderPivot.setLastModifiedOn((Date)record.get((Field)Tables.RESOURCE.LAST_MODIFIED_ON));
        Long parentId = (Long)record.get((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID);
        if (Objects.isNull(parentId)) {
            folderPivot.setParentType(EntityType.REQUIREMENT_LIBRARY);
        } else {
            folderPivot.setParentType(EntityType.REQUIREMENT_FOLDER);
            folderPivot.setParentId(parentId);
        }
        return folderPivot;
    }

    private FolderPivot testCaseRecordToFolderPivot(Record record) {
        FolderPivot folderPivot = new FolderPivot();
        folderPivot.setPivotId((Long)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
        folderPivot.setName((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME));
        folderPivot.setKind(EntityType.TEST_CASE_FOLDER);
        folderPivot.setDescription((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION));
        folderPivot.setCreatedBy((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY));
        folderPivot.setCreatedOn((Date)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON));
        folderPivot.setLastModifiedBy((String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY));
        folderPivot.setLastModifiedOn((Date)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON));
        Long parentId = (Long)record.get((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID);
        if (Objects.isNull(parentId)) {
            folderPivot.setParentType(EntityType.TEST_CASE_LIBRARY);
        } else {
            folderPivot.setParentType(EntityType.TEST_CASE_FOLDER);
            folderPivot.setParentId(parentId);
        }
        return folderPivot;
    }

    private FolderPivot campaignRecordToFolderPivot(Record record) {
        FolderPivot folderPivot = new FolderPivot();
        folderPivot.setPivotId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
        folderPivot.setName((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
        folderPivot.setDescription((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION));
        folderPivot.setKind(EntityType.valueOf((String)((String)record.get(FolderPivotDao.CAMPAIGN_KIND))));
        folderPivot.setParentType(EntityType.valueOf((String)((String)record.get(FolderPivotDao.CAMPAIGN_PARENT_TYPE))));
        folderPivot.setCreatedBy((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY));
        folderPivot.setCreatedOn((Date)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON));
        folderPivot.setLastModifiedBy((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY));
        folderPivot.setLastModifiedOn((Date)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON));
        Long parentId = (Long)record.get((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID);
        if (parentId != null) {
            folderPivot.setParentId(parentId);
        }
        return folderPivot;
    }

    static {
        FolderPivotConverterServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getDescription_aroundBody0(FolderPivotConverterServiceImpl folderPivotConverterServiceImpl, FolderPivot folderPivot, JoinPoint joinPoint) {
        return folderPivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody2(FolderPivotConverterServiceImpl folderPivotConverterServiceImpl, FolderPivot folderPivot, JoinPoint joinPoint) {
        return folderPivot.getDescription();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FolderPivotConverterServiceImpl.java", FolderPivotConverterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot", "", "", "", "java.lang.String"), 57);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot", "", "", "", "java.lang.String"), 67);
    }
}

