/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.exception.CouldNotParseJsonFileException;
import org.squashtest.tm.exception.pivot.projectexporter.ExportPivotAttachmentException;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.InvalidJsonFileNameForImport;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.pivot.exception.PivotJsonWritingException;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.pivot.PivotFileManager;

@Service
public class PivotFileManagerImpl
implements PivotFileManager {
    private static final String ERROR_WRITING_TO_JSON = "Error during the generation of the pivot format while writing to the JSON file: ";

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyPivotFileToImport(MultipartFile multipartFile, File importFile, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        var4_4 = null;
        var5_6 = null;
        try {
            zis = new ZipInputStream(multipartFile.getInputStream());
            try {
                fos = new FileOutputStream(importFile);
                try {
                    zos = new ZipOutputStream(fos);
                    try {
                        zos.setLevel(0);
                        buffer = new byte[8192];
                        while ((entry = zis.getNextEntry()) != null) {
                            if ("metadata.json".equals(entry.getName())) continue;
                            newEntry = new ZipEntry(entry.getName());
                            if (entry.getMethod() == 0) {
                                newEntry.setMethod(0);
                                newEntry.setSize(entry.getSize());
                                newEntry.setCrc(entry.getCrc());
                            }
                            zos.putNextEntry(newEntry);
                            while ((length = zis.read(buffer)) > 0) {
                                zos.write(buffer, 0, length);
                            }
                        }
                        jsonEntry = new ZipEntry("metadata.json");
                        zos.putNextEntry(jsonEntry);
                        new ObjectMapper().writeValue((OutputStream)zos, (Object)pivotMetaDataModel);
                    }
                    finally {
                        if (zos != null) {
                            zos.close();
                        }
                    }
                    ** if (fos == null) goto lbl-1000
                }
                catch (Throwable var5_7) {
                    if (var4_4 == null) {
                        var4_4 = var5_7;
                    } else if (var4_4 != var5_7) {
                        var4_4.addSuppressed(var5_7);
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    throw var4_4;
                }
lbl-1000:
                // 1 sources

                {
                    fos.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (zis == null) goto lbl-1000
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                } else if (var4_4 != var5_8) {
                    var4_4.addSuppressed(var5_8);
                }
                if (zis != null) {
                    zis.close();
                }
                throw var4_4;
            }
lbl-1000:
            // 1 sources

            {
                zis.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var5_9) {
            if (var4_4 == null) {
                var4_4 = var5_9;
            } else if (var4_4 != var5_9) {
                var4_4.addSuppressed(var5_9);
            }
            throw var4_4;
        }
    }

    @Override
    public void writeObjectToZip(JsonFactory jsonFactory, PivotFileManager.ConsumerThrowing<JsonGenerator, IOException> writeToJson, JsonImportFile jsonImportFile, ArchiveOutputStream<ZipArchiveEntry> archive) throws IOException {
        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(jsonImportFile.getFileName());
        archive.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)stream);){
                        jsonGenerator.setCodec((ObjectCodec)mapper);
                        writeToJson.accept(jsonGenerator);
                        jsonGenerator.flush();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    archive.write(stream.toByteArray());
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new PivotJsonWritingException("Error while writing %s".formatted(jsonImportFile.getFileName()), e);
            }
        }
        finally {
            archive.closeArchiveEntry();
        }
    }

    @Override
    public void writePivotObjectToZip(JsonFactory jsonFactory, Consumer<JsonGenerator> writeToJson, JsonImportFile jsonImportFile, ArchiveOutputStream<ZipArchiveEntry> archive) throws IOException {
        this.writeObjectToZip(jsonFactory, jsonGenerator -> {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(jsonImportFile.getJsonFieldKind());
            jsonGenerator.writeStartArray();
            writeToJson.accept((JsonGenerator)jsonGenerator);
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }, jsonImportFile, archive);
    }

    @Override
    public <P extends AbstractPivotObject> void writePivotObject(P pivotObject, JsonGenerator jsonGenerator, JsonImportFile jsonImportFile) {
        try {
            jsonGenerator.writeObject(pivotObject);
        }
        catch (IOException e) {
            throw new PivotJsonWritingException("Error while writing %s on the pivot object with id %s".formatted(jsonImportFile.getFileName(), pivotObject.getPivotId()), e);
        }
    }

    @Override
    public File createAttachmentDir(File tmpAttachmentDir, AttachmentPivotType attachmentPivotType) {
        Path attachmentPath = tmpAttachmentDir.toPath().resolve(attachmentPivotType.getDirectoryName());
        File attachmentDirectory = attachmentPath.toFile();
        if (!attachmentDirectory.exists() && !attachmentDirectory.mkdirs()) {
            throw new ExportPivotAttachmentException("Error while creating the temporary attachment directory %s".formatted(attachmentPath));
        }
        return attachmentDirectory;
    }

    @Override
    public void saveTmpSaveAttachment(File attachmentDirectory, AttachmentPivot attachmentPivot) {
        Path targetPath = attachmentDirectory.toPath().resolve(attachmentPivot.getZipImportFileName());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                out.write(attachmentPivot.getContent());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ExportPivotAttachmentException("Error while saving the attachment '%s' with ID '%s' to the temporary directory %s".formatted(attachmentPivot.getOriginalFileName(), attachmentPivot.getPivotId(), targetPath), (Throwable)e);
        }
    }

    @Override
    public void addAttachmentsToZip(ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, File attachmentDirectory) throws IOException {
        if (Objects.requireNonNull(attachmentDirectory.listFiles()).length == 0) {
            return;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> pathStream = Files.walk(attachmentDirectory.toPath(), new FileVisitOption[0]);){
            pathStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                String relativePath = tmpAttachmentDir.toPath().relativize((Path)path).toString().replace(File.separatorChar, '/');
                String entryName = "%s/%s".formatted("attachments", relativePath);
                File file2 = path.toFile();
                try {
                    ZipArchiveEntry entry = new ZipArchiveEntry(file2, entryName);
                    entry.setMethod(0);
                    entry.setSize(file2.length());
                    entry.setCrc(this.computeCrc32(file2));
                    archive.putArchiveEntry((ArchiveEntry)entry);
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                        in.transferTo((OutputStream)archive);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    archive.closeArchiveEntry();
                    FileUtils.delete((File)file2);
                }
                catch (IOException e) {
                    throw new ExportPivotAttachmentException("Error while adding attachment '%s' to the export zip file %s".formatted(file2.getName(), relativePath), (Throwable)e);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FileUtils.delete((File)attachmentDirectory);
    }

    private long computeCrc32(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int len;
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)is).read(buffer)) > 0) {
                crc.update(buffer, 0, len);
            }
            return crc.getValue();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void readPivotFile(MultipartFile multipartFile, PivotFileManager.BiConsumerThrowing<ZipInputStream, ZipEntry, IOException> zipEntryConsumer) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zis = new ZipInputStream(multipartFile.getInputStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                zipEntryConsumer.accept(zis, entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void checkJsonFileName(String entryName) {
        boolean nameIsValid = EnumSet.allOf(JsonImportFile.class).stream().anyMatch(enumEntry -> enumEntry.getFileName().equals(entryName));
        if (!nameIsValid) {
            String message = String.format("Invalid json file name for pivot import: \" %s\"", entryName);
            throw new InvalidJsonFileNameForImport(entryName, message);
        }
    }

    @Override
    public void checkJsonSyntaxError(ZipEntry entry, ZipInputStream zis) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JsonParser jsonParser = jsonFactory.createParser((InputStream)zis);){
                jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                while (jsonParser.nextToken() != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            String message = String.format("Failed to parse json file with name \"%s\". Please verify the syntax of your file.", entry.getName());
            throw new CouldNotParseJsonFileException(entry.getName(), message, (Exception)((Object)e));
        }
    }

    @Override
    public <T> Consumer<T> consumerThrowingIOException(PivotFileManager.ConsumerThrowing<T, IOException> t) {
        return i -> {
            try {
                t.accept(i);
            }
            catch (IOException e) {
                throw new PivotJsonWritingException(ERROR_WRITING_TO_JSON, e);
            }
        };
    }

    @Override
    public <T> Consumer<T> consumerThrowingRecordAndId(PivotFileManager.BiConsumerThrowing<T, AtomicInteger, IOException> records) {
        AtomicInteger idGenerator = new AtomicInteger(0);
        return i -> {
            try {
                records.accept(i, idGenerator);
            }
            catch (IOException e) {
                throw new PivotJsonWritingException(ERROR_WRITING_TO_JSON, e);
            }
        };
    }
}

